/// \file resource_dumb.h
/// Resource manager plugin for DUMB files

#ifndef RESOURCE_DUMB_H_INCLUDED
#define RESOURCE_DUMB_H_INCLUDED

#include <sstream>
#include "dumb/include/dumb.h"
#include "resource.h"

class DumbResource: public StringResource
{
	public: // Types
		enum FileType {
			FT_Mod,
			FT_It,
			FT_Xm,
			FT_S3m
		};
		
	public: // Public static functions
		static Resource* Factory()
		{ return new DumbResource; }
		
	public: // Public variables
		FileType ft;
		DUH* data;
		DUMBFILE* datafile;
		
	public: // Public functions
		DumbResource();
		DumbResource(const std::string& data);
		~DumbResource();
		
		void Save(std::iostream* f);
		void Load(std::iostream* f);
};

#endif

// The end
