/// \file resource.cpp
/// Resource manager

#include "resource.h"

using namespace std;

#undef getc
static int getc(istream* f)
{ return f->get(); }

static unsigned short mgetw(istream* f)
{ int i = f->get() << 8; i |= f->get(); return i; }

static unsigned short igetw(istream* f)
{ int i = f->get(); i |= f->get() << 8; return i; }

static unsigned int igetl(istream* f)
{ int i = f->get(); i |= f->get() << 8; i |= f->get() << 16; i |= f->get() << 24; return i; }

#undef putc
static void putc(int c, ostream* f)
{ f->put(c); }

static void mputw(unsigned short s, ostream* f)
{ f->put(s >> 8); f->put(s); }

static void iputw(unsigned short s, ostream* f)
{ f->put(s); f->put(s >> 8); }

static void iputl(unsigned int s, ostream* f)
{ f->put(s); f->put(s >> 8); f->put(s >> 16); f->put(s >> 24); }

static int pf_fclose(void *userdata)
{ return 0; }

static int pf_getc(void *userdata)
{ return ((iostream*) userdata)->get(); }

static int pf_ungetc(int c, void *userdata)
{ ((iostream*) userdata)->unget(); return c; }

static long pf_fread(void *p, long n, void *userdata)
{ ((iostream*) userdata)->read((char*) p, n); return n; }

static int pf_putc(int c, void *userdata)
{ ((iostream*) userdata)->put(c); return c; }

static long pf_fwrite(const void *p, long n, void *userdata)
{ ((iostream*) userdata)->write((const char*) p, n); return n; }

static int pf_fseek(void *userdata, int offset)
{ ((iostream*) userdata)->seekg(offset, ios::cur); return 0; }

static int pf_feof(void *userdata)
{ return ((iostream*) userdata)->eof(); }

static int pf_ferror(void *userdata)
{ return !((iostream*) userdata)->good(); }

static PACKFILE_VTABLE pack_vtable = {
	pf_fclose,
	pf_getc,
	pf_ungetc,
	pf_fread,
	pf_putc,
	pf_fwrite,
	pf_fseek,
	pf_feof,
	pf_ferror,
};

ResourceManager::Resource::~Resource()
{
}

void ResourceManager::Resource::Save(iostream* f)
{
}

void ResourceManager::Resource::Load(iostream* f)
{
}

PACKFILE* ResourceManager::CreatePackfile(iostream* file)
{
	return pack_fopen_vtable(&pack_vtable, file);
}

ResourceManager::ResourceManager(): file(NULL)
{
}

ResourceManager::~ResourceManager()
{
	Unload();
}

bool ResourceManager::Load(const string& filename)
{
	Unload();
	
	file = new fstream(filename.c_str(), ios::in | ios::binary);
	if(!file)
		return false;
	
	int magic = mgetw(file);
	if(magic != MagicNumber)
		return false;
		
	int version = getc(file);
	if(version != 1)
		return false;
	
	int num = igetw(file);
	
	for(int i = 0; i < num; i++)
	{
		string temp;
		char c;
		while((c = getc(file)))
			temp += c;
		
		int off = igetl(file);
		
		contents[temp] = off;
	}
		
	return true;
}

void ResourceManager::Save(const string& filename)
{
	delete file;
	file = new fstream(filename.c_str(), ios::out | ios::binary);
	contents.clear();
	
	mputw(MagicNumber, file);
	putc(FileVersion, file);
	iputw(pairs.size(), file);
	
	for(map<string, Resource*>::iterator i = pairs.begin(); i != pairs.end(); i++)
	{
		file->write(i->first.c_str(), i->first.length() + 1);
		iputl(0, file);
	}
	
	for(map<string, Resource*>::iterator i = pairs.begin(); i != pairs.end(); i++)
	{
		contents[i->first] = file->tellp();
		i->second->Save(file);
	}
	
	file->seekp(5, ios::beg);
	for(map<string, unsigned int>::iterator i = contents.begin(); i != contents.end(); i++)
	{
		file->write(i->first.c_str(), i->first.length() + 1);
		iputl(i->second, file);
	}
	
	delete file;
	file = new fstream(filename.c_str(), ios::in | ios::binary);
}

void ResourceManager::Unload()
{
	delete file;
	file = NULL;
	
	contents.clear();
	
	for(map<string, Resource*>::iterator i = pairs.begin(); i != pairs.end(); i++)
	{
		delete i->second;
	}
	pairs.clear();
}

void ResourceManager::Remove(const string& name, bool fromContents)
{
	if(fromContents)
		contents.erase(name);
		
	map<std::string, Resource*>::iterator val = pairs.find(name);
	if(val == pairs.end())
		return;
		
	delete val->second;
	pairs.erase(val);
}

void ResourceManager::Add(const std::string& name, Resource* data)
{
	std::map<std::string, Resource*>::iterator val = pairs.find(name);
	if(val != pairs.end())
		delete val->second;
	pairs[name] = data;
}

ResourceManager::Resource* ResourceManager::Retrieve(const std::string& name, Resource* (*Factory)())
{
	std::map<std::string, Resource*>::iterator val = pairs.find(name);
	if(val != pairs.end())
	{
		return val->second;
	}
	
	std::map<std::string, unsigned int>::iterator loc = contents.find(name);
	if(loc == contents.end())
		return NULL;
	
	file->seekg(loc->second, std::ios::beg);
	Resource* r = Factory();
	Add(name, r);
	r->Load(file);
	return r;
}

StringResource::StringResource()
{
}

StringResource::StringResource(const string& data): data(data)
{
}

void StringResource::Save(std::iostream* f)
{
	iputl(data.length(), f);
	f->write(data.data(), data.length());
}

void StringResource::Load(std::iostream* f)
{
	unsigned int len = igetl(f);
	data.resize(len);
	f->read(&data[0], len);
}

BitmapResource::BitmapResource(): data(NULL)
{
}

BitmapResource::BitmapResource(BITMAP* data): data(data)
{
}

BitmapResource::~BitmapResource()
{
	destroy_bitmap(data);
}

void BitmapResource::Save(std::iostream* f)
{
	PACKFILE* file = ResourceManager::CreatePackfile(f);
	save_bmp_pf(file, data, NULL);
	pack_fclose(file);
}

void BitmapResource::Load(std::iostream* f)
{
	PACKFILE* file = ResourceManager::CreatePackfile(f);
	data = load_bmp_pf(file, NULL);
	pack_fclose(file);
}

FontResource::FontResource(): data(NULL)
{
}

FontResource::FontResource(BITMAP* data): BitmapResource(data)
{
	this->data = grab_font_from_bitmap(BitmapResource::data);
}

FontResource::~FontResource()
{
	destroy_font(data);
}

void FontResource::Load(std::iostream* f)
{
	int mode = get_color_conversion();
	set_color_conversion(COLORCONV_NONE);
	BitmapResource::Load(f);
	set_color_conversion(mode);
	data = grab_font_from_bitmap(BitmapResource::data);
}

// The end
