/// \file main.cpp
/// Engine

#include <allegro.h>
#include "dumb/include/dumb.h"
#include "resource.h"
#include "global.h"
#include "gamescreen.h"
#include "mainmenu.h"

FONT* g_font = font;
ResourceManager* g_data = NULL;
ResourceManager* g_music = NULL;
AL_DUH_PLAYER* g_player = NULL;

volatile static int game_time = 0;
static void timer()
{
	++game_time;
}

int main(int argc, char* argv[])
{
	allegro_init();
	set_config_file("akilah.ini");
	install_keyboard();
	install_mouse();
	install_timer();
	install_sound(DIGI_AUTODETECT, MIDI_NONE, NULL);
	srand(time(NULL));
	
	set_color_depth(16);
	set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0);
	//set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0);
	
	// Put up a dummy loading screen
	clear(screen);
	textprintf_centre_ex(screen, g_font, SCREEN_W / 2, SCREEN_H / 2, -1, -1, "Loading...");
	
	BITMAP* buffer = create_bitmap(SCREEN_W, SCREEN_H);
	
	g_data = new ResourceManager;
	if(!g_data->Load("global.dat"))
		g_data->Load("global_safe.dat");
	FontResource* fr = g_data->Retrieve<FontResource>("font");
	g_font = fr->data;
	
	g_music = new ResourceManager;
	if(!g_music->Load("music.dat"))
	{
		delete g_music;
		g_music = NULL;
	}
	
	install_int_ex(timer, BPS_TO_TIMER(30));
	
	GameScreen* cur_screen = new MainMenuScreen;
	
	while(1)
	{
		if(game_time)
		{
			game_time = 0;
			
			GameScreen* next_screen = cur_screen->Logic();
			if(!next_screen)
				break;
			if(next_screen != cur_screen)
				cur_screen = next_screen;
			else
			{
				cur_screen->Draw(buffer);
				vsync();
				blit(buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
			}
		}
		else
			rest(1);
	}
	
	al_stop_duh(g_player);
	delete g_music;
	g_music = NULL;
	
	delete g_data;
	g_data = NULL;
	
	destroy_bitmap(buffer);
	
	dumb_exit();
	allegro_exit();
	
	return 0;
}
END_OF_MAIN()

// The end
