/// \file gendat.cpp
/// Generate some resource files

#define ALLEGRO_NO_MAGIC_MAIN
#include <iostream>
#include <sstream>
#include <allegro.h>
#include "resource.h"
#include "resource_jpeg.h"
#include "resource_dumb.h"
#include "jpgalleg/jpgalleg.h"

using namespace std;

static void AddBitmap(ResourceManager& r, const char* filename, const char* rname)
{
	BITMAP* bmp = load_bitmap(filename, NULL);
	if(!bmp)
		cout << "Failed to load " << filename << endl;
	else
	{
		cout << "Adding " << rname << endl;
		r.Add(rname, new BitmapResource(bmp));
	}
}

static void AddJpeg(ResourceManager& r, const char* filename, const char* rname)
{
	BITMAP* bmp = load_bitmap(filename, NULL);
	if(!bmp)
		cout << "Failed to load " << filename << endl;
	else
	{
		cout << "Adding " << rname << endl;
		r.Add(rname, new JpegResource(bmp));
	}
}

static void AddFile(ResourceManager& r, const char* filename, const char* rname)
{
	ifstream ini(filename, ios::binary);
	if(!ini.good())
		cout << "Failed to load " << filename << endl;
	else
	{
		ini.seekg(0, ios::end);
		unsigned int len = ini.tellg();
		ini.seekg(0, ios::beg);
		StringResource* sr = new StringResource;
		sr->data.resize(len);
		ini.read(&sr->data[0], len);
		cout << "Adding " << rname << endl;
		r.Add(rname, sr);
	}
}

static void AddEnemies(ResourceManager& r)
{
	al_ffblk info;
	if(al_findfirst("data/stoned.*.bmp", &info, FA_ARCH) != 0)
	{
		cout << "No enemies found." << endl;
		return;
	}
	
	int cur_e = 0;
	
	do {
		int id = atoi(&info.name[7]);
		
		BITMAP* stoned;
		BITMAP* suprised;
		
		stringstream file, name;
		file << "data/stoned." << id << ".bmp";
		stoned = load_bitmap(file.str().c_str(), NULL);
		
		file.str("");
		file << "data/suprised." << id << ".bmp";
		suprised = load_bitmap(file.str().c_str(), NULL);
		
		if(!stoned || !suprised)
			cout << "Failed to load enemy " << id << endl;
		else
		{
			cout << "Adding enemy " << cur_e << endl;
			name << "stoned[" << cur_e << "]";
			r.Add(name.str(), new MaskedJpegResource(stoned));
			name.str("");
			name << "suprised[" << cur_e << "]";
			r.Add(name.str(), new MaskedJpegResource(suprised));
			++cur_e;
		}
	} while(al_findnext(&info) == 0);
	
	al_findclose(&info);
	
	r.Add("enemy_count", new BasicResource<int>(cur_e));
}

static void AddDeans(ResourceManager& r)
{
	al_ffblk info;
	if(al_findfirst("data/dean.*.bmp", &info, FA_ARCH) != 0)
	{
		cout << "No deans found." << endl;
		return;
	}
	
	int cur_d = 0;
	
	do {
		int id = atoi(&info.name[5]);
		
		BITMAP* dean;
		BITMAP* busted;
		
		stringstream file, name;
		file << "data/dean." << id << ".bmp";
		dean = load_bitmap(file.str().c_str(), NULL);
		
		file.str("");
		file << "data/busted." << id << ".bmp";
		busted = load_bitmap(file.str().c_str(), NULL);
		
		if(!dean || !busted)
			cout << "Failed to load dean " << id << endl;
		else
		{
			cout << "Adding dean " << cur_d << endl;
			name << "dean[" << cur_d << "]";
			r.Add(name.str(), new MaskedJpegResource(dean));
			name.str("");
			name << "busted[" << cur_d << "]";
			r.Add(name.str(), new MaskedJpegResource(busted));
			++cur_d;
		}
	} while(al_findnext(&info) == 0);
	
	al_findclose(&info);
	
	r.Add("dean_count", new BasicResource<int>(cur_d));
}

static void AddLevels(ResourceManager& r)
{
	al_ffblk info;
	if(al_findfirst("data/level.*.jpg", &info, FA_ARCH) != 0)
	{
		cout << "No levels found." << endl;
		return;
	}
	
	int cur_l = 0;
	
	do {
		int id = atoi(&info.name[6]);
		
		BITMAP* bg;
		
		stringstream file, name;
		file << "data/level." << id << ".jpg";
		bg = load_jpg(file.str().c_str(), NULL);
		
		if(!bg)
			cout << "Failed to load level " << id << endl;
		else
		{
			cout << "Adding level " << cur_l << endl;
			name << "level[" << cur_l << "]";
			r.Add(name.str(), new JpegResource(bg));
			++cur_l;
		}
	} while(al_findnext(&info) == 0);
	
	al_findclose(&info);
	
	r.Add("level_count", new BasicResource<int>(cur_l));
}

static void AddTunes(ResourceManager& r)
{
	int cur_t = 0;
	al_ffblk info;
	
#define GET_TRACKS(_ft, _ext) \
	if(al_findfirst("data/music/*." _ext, &info, FA_ARCH) == 0) \
	{ \
		do { \
			if(string("fanfare.s3m") != info.name) \
			{ \
				stringstream file, name; \
				file << "data/music/" << info.name; \
				name << "track[" << cur_t << "]"; \
				ifstream ini(file.str().c_str(), ios::binary); \
				if(!ini.good()) \
					cout << "Failed to load " << file.str() << endl; \
				else \
				{ \
					ini.seekg(0, ios::end); \
					unsigned int len = ini.tellg(); \
					ini.seekg(0, ios::beg); \
					DumbResource* sr = new DumbResource; \
					sr->ft = _ft; \
					sr->StringResource::data.resize(len); \
					ini.read(&sr->StringResource::data[0], len); \
					cout << "Adding " << name.str() << endl; \
					r.Add(name.str(), sr); \
					++cur_t; \
				} \
			} \
		} while(al_findnext(&info) == 0); \
		al_findclose(&info); \
	}
	
	GET_TRACKS(DumbResource::FT_Mod, "mod")
	GET_TRACKS(DumbResource::FT_It, "it")
	GET_TRACKS(DumbResource::FT_Xm, "xm")
	GET_TRACKS(DumbResource::FT_S3m, "s3m")
	
	if(!cur_t)
	{
		cout << "No tunes found." << endl;
		return;
	}
	
	r.Add("track_count", new BasicResource<int>(cur_t));
	
	ifstream ini("data/music/fanfare.s3m", ios::binary);
	if(!ini.good())
		cout << "Failed to load data/music/fanfare.s3m" << endl;
	else
	{
		ini.seekg(0, ios::end);
		unsigned int len = ini.tellg();
		ini.seekg(0, ios::beg);
		DumbResource* sr = new DumbResource;
		sr->ft = DumbResource::FT_S3m;
		sr->StringResource::data.resize(len);
		ini.read(&sr->StringResource::data[0], len);
		cout << "Adding fanfare" << endl;
		r.Add("fanfare", sr);
	}
}

int main(int argc, char* argv[])
{
	install_allegro(SYSTEM_NONE, &errno, atexit);
	set_color_depth(16);
	set_color_conversion(COLORCONV_KEEP_ALPHA);
	jpgalleg_init();
	
	ResourceManager r;
	BITMAP* bmp;
		
	set_color_conversion(COLORCONV_NONE);
	bmp = load_bitmap("data/font.pcx", NULL);
	if(!bmp)
		cout << "Failed to load data/font.pcx" << endl;
	else
		r.Add("font", new FontResource(bmp));
	set_color_conversion(COLORCONV_KEEP_ALPHA);
	
	AddFile(r, "data/credits.txt", "credits");
	AddJpeg(r, "data/mainmenu.jpg", "mainmenu");
	AddJpeg(r, "data/help_screen.jpg", "help_screen");
		
	cout << "Saving global.dat\n" << endl;
	r.Save("global.dat");
	
	AddFile(r, "data/safe/credits.txt", "credits");
	AddJpeg(r, "data/safe/mainmenu.jpg", "mainmenu");
		
	cout << "Saving global_safe.dat\n" << endl;
	r.Save("global_safe.dat");
	r.Unload();
	
	AddBitmap(r, "data/akilah.bmp", "akilah");
	AddBitmap(r, "data/finger.bmp", "finger");
	AddBitmap(r, "data/referral.bmp", "referral");
	
	AddBitmap(r, "data/andrew.bmp", "andrew");
	AddBitmap(r, "data/andrew.bubble.bmp", "andrew_bubble");
	
	AddJpeg(r, "data/faces.normal.jpg", "faces_normal");
	AddJpeg(r, "data/faces.angry.jpg", "faces_angry");
	AddJpeg(r, "data/faces.happy.jpg", "faces_happy");
	
	AddJpeg(r, "data/load_screen.jpg", "load_screen");
	AddJpeg(r, "data/win_screen.jpg", "win_screen");
	AddJpeg(r, "data/lose_screen.jpg", "lose_screen");
	AddJpeg(r, "data/iss_screen.jpg", "iss_screen");
	
	AddFile(r, "data/aaphrases.txt", "aaphrases");
		
	cout << "Saving akilah.dat\n" << endl;
	r.Save("akilah.dat");
	
	AddBitmap(r, "data/safe/finger.bmp", "finger");
	AddJpeg(r, "data/safe/lose_screen.jpg", "lose_screen");
	
	cout << "Saving akilah_safe.dat\n" << endl;
	r.Save("akilah_safe.dat");
	r.Unload();
	
	AddEnemies(r);
	AddDeans(r);
	cout << "Saving enemies.dat\n" << endl;
	r.Save("enemies.dat");
	r.Unload();
	
	AddLevels(r);
	cout << "Saving levels.dat\n" << endl;
	r.Save("levels.dat");
	r.Unload();
	
	AddTunes(r);
	cout << "Saving music.dat\n" << endl;
	r.Save("music.dat");
	
	return 0;
}

// The end
