/// \file game.cpp
/// GLobal data structures

#include <math.h>
#include <sstream>
#include <algorithm>
#include "global.h"
#include "game.h"
#include "resource_jpeg.h"

using namespace std;

Game game;

Game::Game()
{
}

Game::~Game()
{
	End();
}

void Game::New()
{
	End();
	
	// Put up a dummy loading screen
	clear(screen);
	textprintf_centre_ex(screen, g_font, SCREEN_W / 2, SCREEN_H / 2, -1, -1, "Loading...");
	
	if(!res.Load("akilah.dat"))
		res.Load("akilah_safe.dat");
	
	al_poll_duh(g_player);
	
	// Put up a nicer loading screen
	BitmapResource* ls = res.Retrieve<JpegResource>("load_screen");
	blit(ls->data, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
	res.Remove("load_screen");
	
	al_poll_duh(g_player);
	
	ene.Load("enemies.dat");
	
	al_poll_duh(g_player);
	
	int num = ene.Retrieve<BasicResource<int> >("enemy_count")->data;
	for(int i = 0; i < num; i++)
	{
		Enemy* e = new Enemy(i);
		enemies.push_back(e);
	
		al_poll_duh(g_player);
	}
	
	num = ene.Retrieve<BasicResource<int> >("dean_count")->data;
	for(int i = 0; i < num; i++)
	{
		Enemy* e = new Enemy(i, true);
		enemies.push_back(e);
	
		al_poll_duh(g_player);
	}
	
	random_shuffle(enemies.begin(), enemies.end());
	cur_enemy = enemies.begin();
	NextEnemy();
	
	lev.Load("levels.dat");
	num_lev = lev.Retrieve<BasicResource<int> >("level_count")->data;
	background = lev.Retrieve<JpegResource>("level[0]")->data;
	camx = (background->w - SCREEN_W) / 2;
	cam_move = 0;
	
	al_poll_duh(g_player);
	
	score = misses = referrals = num_ene = 0;
	level = 1;
	level_rem = 5;
	spawn_cd = 30;
}

void Game::End()
{
	for(vector<Enemy*>::iterator i = enemies.begin(); i != enemies.end(); i++)
	{
		delete *i;
	}
	enemies.clear();
	
	res.Unload();
	ene.Unload();
	lev.Unload();
}

void Game::Levelup()
{
	// Put up a nicer loading screen
	/*BitmapResource* ls = res.Retrieve<BitmapResource>("load_screen");
	blit(ls->data, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
	res.Remove("load_screen");*/
	
	stringstream levname;
	levname << "level[" << ((level - 1) % num_lev) << "]";
	lev.Remove(levname.str());
	levname.str("");
	levname << "level[" << (level % num_lev) << "]";
	background = lev.Retrieve<JpegResource>(levname.str())->data;
	camx = (background->w - SCREEN_W) / 2;
	cam_move = 0;
	
	random_shuffle(enemies.begin(), enemies.end());
	
	cur_enemy = enemies.begin();
	NextEnemy();
	spawn_cd = 30;
	
	misses = num_ene = 0;
	level++;
	level_rem = (int) exp((double) level / 5) * 5;
}

Game::EResult Game::Logic()
{
	if(rand() % (cam_move ? 300 : 120) == 0)
		cam_move = ((rand() % 3) - 1) * PanSpeed;
	camx += cam_move;
	if(camx < 0)
	{
		camx = 0;
		cam_move = 0;
	}
	if(camx + SCREEN_W >= background->w)
	{
		camx = background->w - SCREEN_W;
		cam_move = 0;
	}
	
	if(cur_enemy == enemies.end())
	{
		win_cd--;
		if(win_cd <= 0)
			return R_Won;
	}
	else
	{
		--spawn_cd;
		if(spawn_cd < 0)
		{
			int x = rand() % (SCREEN_W - (*cur_enemy)->stoned->w);
			x += camx;
			(*cur_enemy)->Spawn(x, SCREEN_H - 100 - (*cur_enemy)->stoned->h);
			num_ene++;
			cur_enemy++;
			NextEnemy();
		}
	}
	
	for(vector<Enemy*>::iterator i = enemies.begin(); i != enemies.end(); i++)
	{
		(*i)->Logic();
	}
	
	if(misses >= 3)
		return R_Lost;
	if(referrals >= 3)
		return R_ISS;
	if(level_rem <= 0 && cur_enemy != enemies.end())
	{
		cur_enemy = enemies.end();
		win_cd = 120;
	}
	
	return R_None;
}

void Game::Shoot(int x, int y)
{
	for(vector<Enemy*>::reverse_iterator i = enemies.rbegin(); i != enemies.rend(); i++)
	{
		if((*i)->TakeHit(x - (*i)->x, y - (*i)->y))
			return;
	}
}

void Game::NextEnemy()
{
	if(level < 3)
	{
		while(cur_enemy != enemies.end() && (*cur_enemy)->dean)
			cur_enemy++;
	}
	spawn_cd = 60 - 10 * level / 3;
	if(spawn_cd < 20)
	{
		spawn_cd = 20;
	}
	if(rand() % 5 == 0)
		spawn_cd += 60;
	if(cur_enemy == enemies.end())
		win_cd = 120;
}

// The end
