/// \file akilahscreen.h
/// The main display screen for the game

#ifndef AKILAHSCREEN_H_INCLUDED
#define AKILAHSCREEN_H_INCLUDED

#include <vector>
#include <string>
#include "gamescreen.h"

class AkilahScreen: public GameScreen
{
	public: // Types
		enum { FireTime = 24 };
		enum { MessageSpeed = 3 };
		
	public: // Public variables
		bool down;
		bool paused;
		
		BITMAP* akilah;
		BITMAP* finger;
		BITMAP* referral;
		
		BITMAP* andrew;
		BITMAP* bubble;
		
		/// Akilah's faces (Normal, Sad, Happy)
		BITMAP* faces[3];
		/// Currently displayed face
		BITMAP* face;
		/// Time a face has been displayed
		int face_time;
		/// Saved misses value (for detecting change)
		int old_misses;
		
		int cross_x, cross_y;
		/// Where the mouse was clicked at the start of a fire
		int click_x, click_y;
		int fire_progress;
		
		/// Andrew time and state (-15..-1 is moving out, 0 is gone/waiting,
		/// 1..15 is moving in, else is talking).
		int andrew_time;
		/// List of messages Andrew can say
		std::vector<std::string> aaphrases;
		/// Message current on display
		std::vector<std::string>::iterator cur_phrase;
		/// Message left shift value (for scrolling)
		int message_pos;
		/// Equal to text_length(g_font, message)
		int message_max;

	public: // Public functions
		AkilahScreen();
		~AkilahScreen();
		
		GameScreen* Logic();
		
		void Draw(BITMAP* to);
};

#endif

// The end
