/// \file akilahscreen.cpp
/// The main game screen class

#include <sstream>
#include <algorithm>
#include "akilahscreen.h"
#include "mainmenu.h"
#include "winscreen.h"
#include "losescreen.h"
#include "global.h"
#include "game.h"
#include "resource_jpeg.h"

using namespace std;

AkilahScreen::AkilahScreen(): down(false), paused(false), old_misses(0), cross_x(SCREEN_W / 2), cross_y(SCREEN_H / 2), fire_progress(0), andrew_time(0)
{
	game.New();
	akilah = game.res.Retrieve<BitmapResource>("akilah")->data;
	finger = game.res.Retrieve<BitmapResource>("finger")->data;
	referral = game.res.Retrieve<BitmapResource>("referral")->data;
	
	andrew = game.res.Retrieve<BitmapResource>("andrew")->data;
	bubble = game.res.Retrieve<BitmapResource>("andrew_bubble")->data;
	
	faces[0] = game.res.Retrieve<JpegResource>("faces_normal")->data;
	faces[1] = game.res.Retrieve<JpegResource>("faces_angry")->data;
	faces[2] = game.res.Retrieve<JpegResource>("faces_happy")->data;
	face = faces[0];
	
	string& file = game.res.Retrieve<StringResource>("aaphrases")->data;
	string::size_type left, right;
	left = 0;
	while((right = file.find("\n", left)) != string::npos)
	{
		string line = file.substr(left, right - left - 1);
		aaphrases.push_back(line);
		left = right + 1;
		if(left > file.length())
			break;
	}
	random_shuffle(aaphrases.begin(), aaphrases.end());
	cur_phrase = aaphrases.begin();
}

AkilahScreen::~AkilahScreen()
{
}

GameScreen* AkilahScreen::Logic()
{
	al_poll_duh(g_player);
	
	if(paused)
	{
		if(keypressed())
		{
			int k = readkey() >> 8;
			if(k == KEY_ESC)
			{
				while(key[KEY_ESC]) rest(1);
				game.End();
				delete this;
				return new MainMenuScreen;
			}
			paused = false;
			while(keypressed())
			{
				clear_keybuf();
				rest(30);
			}
		}
		return this;
	}
	if(key[KEY_ESC])
		down = true;
	else if(down)
	{
		paused = true;
		down = false;
		clear_keybuf();
	}
		
	switch(game.Logic())
	{
		case Game::R_None:
			break;
		case Game::R_Won:
			if(!andrew_time)
			{
				old_misses = game.referrals;
				return new WinScreen(this);
			}
			else
				break;
		case Game::R_Lost:
			delete this;
			return new LoseScreen(false);
		case Game::R_ISS:
			delete this;
			return new LoseScreen(true);
	}
	
	cross_x = mouse_x;
	cross_y = mouse_y;
	if(cross_y > SCREEN_H - 100)
		cross_y = SCREEN_H - 100;
	
	if(fire_progress)
	{
		fire_progress++;
		if(fire_progress > FireTime)
			fire_progress = 0;
		if(fire_progress == FireTime / 2)
		{
			int old_score = game.score;
			game.Shoot(click_x, click_y);
			if(game.score > old_score)
			{
				face = faces[2];
				face_time = 0;
			}
		}
	}
	else if(mouse_b & 1)
	{
		fire_progress = 1;
		click_x = game.camx + cross_x;
		click_y = cross_y;
	}
	
	if(andrew_time < 0)
		andrew_time++;
	else if(andrew_time)
	{
		andrew_time++;
		if(message_pos <= message_max)
		{
			andrew_time = -15;
			cur_phrase++;
			if(cur_phrase == aaphrases.end())
			{
				random_shuffle(aaphrases.begin(), aaphrases.end());
				cur_phrase = aaphrases.begin();
			}
		}
		message_pos -= MessageSpeed;
	}
	else if(aaphrases.size() && game.num_ene > 1 && game.level >= 4)
	{
		andrew_time++;
		message_pos = SCREEN_W - andrew->w + 15 + 2 * MessageSpeed;
		message_max = SCREEN_W - bubble->w - andrew->w / 3 + 50 - text_length(g_font, cur_phrase->c_str());
	}
	
	if(old_misses < game.misses + game.referrals)
	{
		face = faces[1];
		face_time = 0;
		old_misses = game.misses + game.referrals;
	}
	if(face != faces[0])
	{
		face_time++;
		if(face_time > 15)
		{
			face = faces[0];
			face_time = 0;
		}
	}
		
	return this;
}

void AkilahScreen::Draw(BITMAP* to)
{
	blit(game.background, to, game.camx, 0, 0, 0, SCREEN_W, SCREEN_H - 100);
	rectfill(to, 0, SCREEN_H - 100, SCREEN_W - 1, SCREEN_H - 1, 0);
	
	for(vector<Enemy*>::iterator i = game.enemies.begin(); i != game.enemies.end(); i++)
	{
		(*i)->Draw(to, (*i)->x - game.camx, (*i)->y);
	}
	
	if(andrew_time)
	{
		if(andrew_time < 0)
		{
			masked_blit(andrew, to, 0, 0, SCREEN_W + (andrew_time * andrew->w / 15), 0, andrew->w, andrew->h);
		}
		else if(andrew_time < 15)
		{
			masked_blit(andrew, to, 0, 0, SCREEN_W - (andrew_time * andrew->w / 15), 0, andrew->w, andrew->h);
		}
		else
		{
			masked_blit(andrew, to, 0, 0, SCREEN_W - andrew->w, 0, andrew->w, andrew->h);
			masked_blit(bubble, to, 0, 0, SCREEN_W - bubble->w - andrew->w / 3, 0, bubble->w, bubble->h);
			int x1, y1, x2, y2;
			get_clip_rect(to, &x1, &y1, &x2, &y2);
			set_clip_rect(to, SCREEN_W - bubble->w - andrew->w / 3 + 50, 30, SCREEN_W - andrew->w + 30, 65);
			textprintf_ex(to, g_font, message_pos, 30, 0, -1, "%s", cur_phrase->c_str());
			set_clip_rect(to, x1, y1, x2, y2);
		}
	}
	
	if(fire_progress)
	{
		int y_sub = 0;
		if(fire_progress < FireTime / 3)
			y_sub = finger->h * 3 * fire_progress / FireTime;
		else if(fire_progress < FireTime * 2 / 3)
			y_sub = finger->h;
		else
			y_sub = finger->h * 3 * (FireTime - fire_progress) / FireTime;
		masked_blit(finger, to, 0, 0, (SCREEN_W + akilah->w) / 2 - 3, SCREEN_H - y_sub, finger->w, y_sub);
	}
	
	masked_blit(akilah, to, 0, 0, (SCREEN_W - akilah->w) / 2, SCREEN_H - akilah->h, akilah->w, akilah->h);
	masked_blit(face, to, 0, 0, (SCREEN_W + akilah->w) / 2 + finger->w, SCREEN_H - 100, face->w, face->h);
	
	line(to, cross_x - 3, cross_y - 3, cross_x + 3, cross_y + 3, makecol(0, 255, 255));
	line(to, cross_x + 3, cross_y - 3, cross_x - 3, cross_y + 3, makecol(0, 255, 255));
	
	string x;
	for(int i = 0; i < game.misses; i++)
		x += 'X';
	textprintf_ex(to, g_font, 15, SCREEN_H - 100, -1, 0, "Level:");
	textprintf_right_ex(to, g_font, 170, SCREEN_H - 100, -1, 0, " %02d", game.level);
	textprintf_ex(to, g_font, 15, SCREEN_H - 68, -1, 0, "Score:");
	textprintf_right_ex(to, g_font, 170, SCREEN_H - 68, -1, 0, "%03d", game.score);
	textprintf_ex(to, g_font, 15, SCREEN_H - 35, -1, 0, "Misses:");
	textprintf_ex(to, g_font, 110, SCREEN_H - 35, makecol(255, 0, 0), 0, "%s", x.c_str());
	textprintf_ex(to, g_font, SCREEN_W - 80, SCREEN_H - 100, -1, 0, "Ref:");
	for(int i = 0; i < game.referrals; i++)
		masked_blit(referral, to, 0, 0, SCREEN_W - 80 + i * 10, SCREEN_H - 65 + i * 10, referral->w, referral->h);
		
	if(paused)
	{
		textprintf_centre_ex(to, g_font, SCREEN_W / 2, SCREEN_H / 2 - 20, -1, 0, "Game Paused");
		textprintf_centre_ex(to, g_font, SCREEN_W / 2, SCREEN_H / 2 + 20, -1, 0, "ESC to exit / any other key to resume");
	}
}

// The end
