#include <iostream.h>
#include <fstream.h>
#include <allegro.h>
#include <string.h>

struct t_tab
{
	int index, attr;
};

int operator!=(t_tab& a, t_tab& b)
{
	return (a.index!=b.index) || (a.attr!=b.attr);
}

ostream& operator<<(ostream& o, const t_tab& x)
{
	o<< "<"<<x.index<<","<<x.attr<<">";
	return o;
}
int dat_index(DATAFILE*, char* name);
RGB* getpal();
void add_thumb(BITMAP*, int, RLE_SPRITE*);

int main(int argc, char* argv[])
{
	allegro_init();
	BITMAP* thumb=create_bitmap(256,256);
	for (int i=1; i<argc; ++i)
	{
		clear(thumb);
		ifstream in(argv[i]);
		if (!in)
		{
			cerr<<"Error opening tile-file "<<argv[i]<<endl;
			return 1;
		}
		char datfile_name[32];
		char ttab_name[32];
		char bm_name[32];
		t_tab tiles[256];
		for (int i=0; i<256; ++i)
		{
			tiles[i].index=0;
			tiles[i].attr=-1;
		}
		in >> datfile_name >> ttab_name >> bm_name;
		DATAFILE* dfile=load_datafile(datfile_name);
		if (!dfile)
		{
			cerr << "Error opening datafile "<<datfile_name<<endl;
			return 1;
		}
		else
			cout << "Reading datafile "<<datfile_name<<endl;
		while (1)
		{
			int i, a;
			char obj_name[32];
			in >> i >> obj_name >> a;
			if (in)
			{
				int ki=tiles[i].index=dat_index(dfile, obj_name);
				tiles[i].attr=a;
				if (ki==-1)
				{
					cerr<<"Error finding object " << obj_name << endl;
					return 1;
				}
				RLE_SPRITE* r=(RLE_SPRITE*) dfile[ki].dat;
				add_thumb(thumb, i, r);
			}
			else
				break;
		}
		unload_datafile(dfile);
		t_tab old_tiles[256];
		ifstream oldtab(ttab_name, ios::binary|ios::in);
		oldtab.read((char*) old_tiles, sizeof(old_tiles));
		oldtab.close();
		int different=0;
		for (int i=0; i<256; ++i)
		{
			if (old_tiles[i]!=tiles[i])
			{
				different++;
				cout << old_tiles[i] << tiles[i] << endl;
			}
		}
		if (different)
		{
			ofstream out(ttab_name, ios::binary|ios::out);
			out.write((char*)tiles, sizeof(tiles));
			cout << "Writing tile-map " << ttab_name<< endl;
		}
		cout << "Writing bitmap "<<bm_name<<endl;
		save_bitmap(bm_name, thumb, getpal());
	}
	destroy_bitmap(thumb);
	return 0;
}

#define NAME_PROP DAT_ID('N','A','M','E')
int dat_index(DATAFILE*d, char* n)
{
	int z=0;
	while (d->type!=DAT_END)
	{
		char *s=get_datafile_property(d, NAME_PROP);
		if (strcmp(s,n)==0)
			return z;
		else
			++d;
		++z;
	}
	// Not found - bomb out
	cerr << "Datafile object "<<n<<" not found" << endl;
	return -1;
}

RGB* getpal()
{
	static RGB our_pal[256];
	static int notgot=1;
	if (notgot)
	{
		DATAFILE* d=load_datafile("atlantis.dat");
		RGB* a_p=(RGB*) d[dat_index(d, "WinPal")].dat;
		for (int i=0; i<256; ++i)
			our_pal[i]=a_p[i];
		unload_datafile(d);
	}
	return our_pal;
}

void add_thumb(BITMAP* bm, int i, RLE_SPRITE* cel)
{
	BITMAP*	tmp=create_bitmap(cel->w, cel->h);
	clear(tmp);
	draw_rle_sprite(tmp, cel, 0, 0);
	int x=(i%16)*16;
	int y=(i/16)*16;
	stretch_blit(tmp, bm, 0, 0, cel->w, cel->h, x, y, 16, 16);
	destroy_bitmap(tmp);
}

