// titles.cc
#include <allegro.h>
#include "atlantis.h"
#include "ticker.h"
#include "input.h"

extern short int bubmap16[];

class TextLine
{
	public:
	TextLine(char**msg);
	~TextLine();
	void update();
	void unput();
	void put(BITMAP*);
	private:
	int tmr;
	char** init_m;
	char** cur_m;
};
	
	
class Bubble
{
	public:
	Bubble(int x, int y, fixed v);
	~Bubble();
	void update();
	void unput();
	void put(BITMAP*);
	static BITMAP* src, *osb;
	private:
	void modify(BITMAP* s, int x, int y, BITMAP* b);
	BITMAP* b;
	int x;
	int oy;
	fixed y, v;
};

Bubble::Bubble(int xx, int yy, fixed vv)
{
	x=xx;
	y=itofix(yy);
	v=vv;
	b=create_bitmap(32, 32);
}
Bubble::~Bubble()
{
	destroy_bitmap(b);
}

//this is the 'perfect' background
BITMAP* Bubble::src;
// this is the working buffer
BITMAP* Bubble::osb;

	

void Bubble::modify(BITMAP* s, int x, int y, BITMAP* b)
{
	short int * pi=bubmap16;
	for (int i=0; i<32; ++i)
		for (int j=0; j<32; ++j)
		{
			int c=getpixel(s, x+pi[0], y+pi[1]);
			if (c==-1) c=0;
			putpixel(b, i, j, c);
			pi+=2;
		}
}
void Bubble::unput()
{
	// repair background
	blit(src, osb, x, oy, x, oy, b->w,  b->h); 
}
void Bubble::update()
{
	y+=v;
	int yy=fixtoi(y);
	if (yy<-b->h) y+=itofix(osb->h+2*b->h);
	modify(osb,x,yy,b);
	blit(b, osb, 0, 0, x, yy, b->w, b->h);
}
void Bubble::put(BITMAP* targ)
{
	int yy=fixtoi(y);
	blit(osb, targ, x, oy, x, oy, b->w, b->h);
	blit(osb, targ, x, yy, x, yy, b->w, b->h);
	oy=yy;
}
extern void* find_data(const char*);

void show_titles()
{
	// some random numbers for velocities...
	static int vs[8]={829,626,423,582,223,766,527,53};
	static char* cred[]={"by Peter Hull", "press CTRL to start", "Made with Allegro", 
		"Thanks to:", "All at allegro.cc", "http://www.allegro.cc/", "Sirocco - you know why..."
		"The real Jack, Rebecca and Granville",0};
	BITMAP* logobmp=(BITMAP*) find_data("Logo");
	RGB* logopal=(RGB*) find_data("LogoPal");
	Bubble::osb=create_bitmap(SCREEN_W, SCREEN_H);
	Bubble::src=logobmp;
	Bubble* bs[8];
	for (int i=0; i<8; ++i)
		bs[i]=new Bubble(i*40,300, -itofix(vs[i])/1000);
	set_palette(logopal);
	blit(Bubble::src, screen, 0,0,0, 0, 320, 200);
	blit(Bubble::src, Bubble::osb, 0,0,0, 0, 320, 200);
	start_tick(30);
	TextLine tl(cred);
	do
	{
		wait_tick();
		tl.unput();
		for (int i=0; i<8; ++i)
			bs[i]->unput();
		tl.update();
		for (int i=0; i<8; ++i)
			bs[i]->update();
		tl.put(screen);
		for (int i=0; i<8; ++i)
			bs[i]->put(screen);
		Control->poll();
	} while (Control->value()==0);
	stop_tick();
	for (int i=0; i<8; ++i)
		delete bs[i];
	destroy_bitmap(Bubble::osb);
}

void show_end_titles()
{
	BITMAP* alex=(BITMAP*) find_data("Alex");
	RGB* alexpal=(RGB*) find_data("AlexPal");
	set_palette(alexpal);
	clear(screen);
	Control->release();
	blit(alex, screen, 0, 0, 0, 0, alex->w, alex->h);
	do
	{
		Control->poll();
	} while (!Control->value());
}
TextLine::TextLine(char** ms)
{
	tmr=1000;
	init_m=cur_m=ms;
}
TextLine::~TextLine()
{
}

void TextLine::unput()
{
	BITMAP* s=Bubble::osb;
	int y=s->h*3/4;
	int w=text_length(font, *cur_m);
	int h=text_height(font);
	int x=(s->w-w)/2;
	blit(Bubble::src, s, x, y, x, y, w, h);
}
void TextLine::update()
{
	BITMAP* s=Bubble::osb;
	int y=s->h*3/4;
	int x=s->w/2;
	if (--tmr<500)
	{
		text_mode(-1);
		textout_centre(s, font, *cur_m, x, y+1, makecol(255,255,255));
		if (tmr<0)
		{
			tmr=1000;	
			if (*(++cur_m)==0)
				cur_m=init_m;
		}
	}
}
void TextLine::put(BITMAP* b)
{
	BITMAP* s=Bubble::osb;
	int y=s->h*3/4;
	int w=text_length(font, *cur_m);
	int h=text_height(font);
	int x=(s->w-w)/2;
	blit(Bubble::osb, b, x, y, x, y, w, h);
}
		


