#include <allegro.h>

BITMAP* BitmapFromString(const char* s)
{
	BITMAP* n=create_bitmap(8,8);
	const int bl=bitmap_mask_color(n);
	const int wh=makecol(255,255,255);
	for (int y=0; y<8; ++y)
		for (int x=0; x<8; ++x)
			putpixel(n, x, y, *s++=='_' ? bl : wh);
	return n;
}

#define CROSS "____X_______X_______X_______X___XXXXXXXX____X_______X_______X___"

int main(int argc, char* argv[])
{
	allegro_init();
	set_gfx_mode(GFX_AUTODETECT, 640, 480, 0,0);
	install_mouse();
	install_timer();
	show_mouse(screen);
	BITMAP* myptr=BitmapFromString(argc==2 ? argv[1] : CROSS);
	set_mouse_sprite(myptr);
	while (mouse_b==0)
	{
	
	}
	destroy_bitmap(myptr);
	set_gfx_mode(GFX_TEXT, 80, 25, 0,0);
	return 0;
}

