#include <stdio.h>
#include <allegro.h>
#include "cast.h"
#include "map.h"
#include "hbag.h"
#include "actions.h"
#include "bstrm.h"
#include "level.h"
#include "input.h"

// Some strings
static char *q_ok="OK";
static char *q_inv="Inv.";
static char *q_get="Get";
static char *q_drop="Drop";

//

extern RLE_SPRITE* rle(const char*);
static int freddie=100;
StdCast::StdCast(Map& m) : MovingObj(m)
{
	move_to(100, freddie+=10);
	facing=1;
	f_r=f_u=f_l=f_d=0;
	s_r=s_u=s_l=s_d=0;
	step_x=step_y=step_xy_x=step_xy_y=1;
}
StdCast::~StdCast()
{
	if (f_r)
	{
		delete[] f_r;
		delete[] f_l;
		delete[] f_d;
		delete[] f_u;
	}
}

void StdCast::i_init(const char* a[], int f)
{
	c_u=c_d=c_l=c_r=f;
	const char** pi=a;
	f_u=new (RLE_SPRITE*)[f];
	f_d=new (RLE_SPRITE*)[f];
	f_r=new (RLE_SPRITE*)[f];
	f_l=new (RLE_SPRITE*)[f];
	for (int i=0; i<f; ++i)
	{
		f_u[i]=rle(*pi++);
	}
	for (int i=0; i<f; ++i)
	{
		f_r[i]=rle(*pi++);
	}
	for (int i=0; i<f; ++i)
	{
		f_d[i]=rle(*pi++);
	}
	for (int i=0; i<f; ++i)
	{
		f_l[i]=rle(*pi++);
	}
	choose_image();
}

int StdCast::take_step(int dx, int dy)
{
	if (dx<0) 
	{
		facing=4;
		s_l=(s_l+1)%c_l;		
	} else if (dx>0)
	{
		facing=2;
		s_r=(s_r+1)%c_r;		
	} else if (dy>0)
	{
		facing=3;
		s_d=(s_d+1)%c_d;		
	} else if (dy<0)
	{
		facing=1;
		s_u=(s_u+1)%c_u;		
	} else
		return 0;
	move_to(x+dx, y+dy);
	choose_image();
	return 1;
}

void StdCast::choose_image()
{
	switch(facing)
	{
		case 1:
			img=f_u[s_u];
			break;
		case 2:
			img=f_r[s_r];
			break;
		case 3:
			img=f_d[s_d];
			break;
		case 4:
			img=f_l[s_l];
			break;
	}
}
char* StdCast::properties()
{
	return "";
}
int StdCast::aa_query_name(char* n)
{
	char *t=properties();
	while(*t!='\0')
	{
		if (strcmp(t,n)==0)
			return AA_YES;
		while(*t++ !='\0')
		{ }
	}
	if (strcmp(n, "person?")==0)
		return AA_YES;
	if (strcmp(n, name())==0)
		return AA_YES;
	return AA_NO;
}
AAction* StdCast::actions()
{
	static AAction a[]={AA_GREET, AA_ASK, AA_END_LIST};
	return a;
}

int StdCast::aa_ask(HBag& b)
{
	int i=0;
	twin* ask_tab=knowledge();
	AParam p;
	AObject* x=b.choose("Ask about...", CF_Ever);
	if (x==0) return AA_NOTHING;
	
	b << ">Ask "<<name()<<" about "<< x->name() << "\n";
	while (ask_tab[i][0]!=0)
	{
		p.msg=ask_tab[i][0];
		if (x->do_action(_AA_QUERY_NAME, p)==AA_YES)
		{
			b<<"\""<<ask_tab[i][1]<<"\"\n";
			return AA_MSG;
		}
		i++;
	}
	p.msg="male?";
	if (x->do_action(_AA_QUERY_NAME, p)==AA_YES)
	{
		b<<"I don't know him very well\n";
		return AA_MSG;
	}
	p.msg="female?";
	if (x->do_action(_AA_QUERY_NAME, p)==AA_YES)
	{
		b<<"I don't know her very well\n";
		return AA_MSG;
	}
	b << ask_tab[i][1] << "\n";
	return AA_MSG;
}

StdCast::twin StdCast::know_tab[]={{0, "I don't know anything about that"}};

StdCast::twin* StdCast::knowledge()
{
	return know_tab;
}

void StdCast::i_init(char* blkname)
{
	BIStream in((char*) Level::current->find_data(blkname)->dat);
	int ver=in.version();
	in>>step_x>>step_y>>step_xy_x>>step_xy_y;
	char iname[32];
	in >> c_u;
	f_u=new (RLE_SPRITE*)[c_u];
	for (int i=0; i<c_u; ++i)
	{
		in >> iname;
		f_u[i]=rle(iname);
	}
	in >> c_r;
	f_r=new (RLE_SPRITE*)[c_r];
	for (int i=0; i<c_r; ++i)
	{
		in >> iname;
		f_r[i]=rle(iname);
	}
	in >> c_d;
	f_d=new (RLE_SPRITE*)[c_d];
	for (int i=0; i<c_d; ++i)
	{
		in >> iname;
		f_d[i]=rle(iname);
	}
	in >> c_l;
	f_l=new (RLE_SPRITE*)[c_l];
	for (int i=0; i<c_l; ++i)
	{
		in >> iname;
		f_l[i]=rle(iname);
	}
	choose_image();
}	
void StdCast::persist(BStream& b)
{
	TRACE("Cast %s: persistent %s \n", name(), b.reading() ? "read":"write");
	if (b.writing())
	{
		b<<get_x()<<get_y();
		for (int i=0; i<inv_items.count(); ++i)
			b<<inv_items[i]->persistent_name();
		b<<"<EOL>";
	}
	else
	{
		int x,y;
		b>>x>>y;
		move_to(x,y);
		inv_items.clear();
		while (1)
		{
			char n[64];
			b>>n;
			AObject* o=Level::current->find_obj(n);
			if (o)
				inv_items.add(o);
			else
				break;
		}
	}
}

int StdCast::do_action(AAction act, AParam p1, AParam )
{
	HBag& b=HBag::inst();
	MovableObj* mo;
	switch(act)
	{
		case AA_GREET:
			b<< ">Greet "<<name()<<"\n\"Hello\"\n";
			return AA_MSG;
		case AA_HELP:
			b<<"Help!\n\"I can't help you\"\n";
			return AA_MSG;
		case AA_GIVE:
		{
			AObject* o=b.choose("Give what?",CF_Acc);
			if (o)
			{
				AParam po;
				b << ">Give "<<o->name()<<" to "<<name()<<"\n";
				po.msg="person?";
				if (o->do_action(_AA_QUERY_NAME, po)==AA_YES)
				{
					b<<"That's a quaint idea!\n";
					return AA_NOTHING;
				}
				else b<<"sjo";
				MovingObj& m=*(MovingObj*)p1.obj;
				po.obj=o;
				m.do_action(_AA_DROPOBJ, po);
				b<< "OK\n";
				AObject::do_action(_AA_GETOBJ, po);
				return AA_CHANGED_INV;
			}
			else
				return AA_NOTHING;
		}
		case AA_ASK:
			return aa_ask(b);
		case _AA_QUERY_NAME:
			TRACE("Query '%s' on %s\n", p1.msg, name());
			return aa_query_name(p1.msg);
		case _AA_GETOBJ:
			mo = (MovableObj*) p1.obj;
			if (!inv_items.has(mo))
			{
				inv_items.add(mo);
				mo->move_nowhere();
				return AA_CHANGED_INV;
			}
			else
				return AA_NOTHING;
		case _AA_DROPOBJ:
			mo = (MovableObj*) p1.obj;
			if (inv_items.has(mo))
			{
				inv_items.remove(mo);
				mo->move_to(*this);
				return AA_CHANGED_INV;
			}
			else
				return AA_NOTHING;
		default:
			return AA_NOTHING;
	}
}

#ifdef HAS_EDITOR

static char msg[40];
static StdCast* psc;
static int did_edit_c;
static int d_inv_proc(int msg, DIALOG* d, int c)
{
	int ans=d_button_proc(msg, d, c);
	if (d->flags & D_SELECTED)
	{
		d->flags &= ~D_SELECTED;
		did_edit_c|=psc->edit_inventory();
	}
	return ans;
}
static DIALOG p_dlg[]={
{d_box_proc, 100, 60, 100, 100, 255, 0, 0, 0, 0, 0, NULL,NULL, NULL},
{d_text_proc, 101, 61, 98, 20, 255, 0, 0, 0, 0, 0, msg, NULL, NULL},
{d_button_proc, 130, 140, 40, 20, 255, 0, 0, D_EXIT, 0, 0, q_ok, NULL, NULL},
{d_inv_proc, 130, 120, 40, 20, 255, 0, 0, 0, 0, 0, q_inv, NULL, NULL},
{NULL}
};

int StdCast::edit()
{
	psc=this;
	did_edit_c=0;
	sprintf(msg, "%s(%d,%d)", name(), get_x(), get_y());
	popup_dialog(p_dlg, -1);
	return did_edit_c;
}

static MovingObj* pm;
static MList av_obj;

static char* haslist_func(int, int*);
static char* alllist_func(int, int*);
static int btn_get(int msg, DIALOG* me, int c);
static int btn_drop(int msg, DIALOG* me, int c);
static int did_edit;
static char mname[32];
static DIALOG gobj_dlg[]={
	{d_box_proc, 80, 30, 200, 160, 255, 0, 0, 0, 0, 0, NULL, NULL, NULL},
	{d_ctext_proc, 140, 30, 200, 10, 0, 255, 0, 0, 0, 0, mname, NULL, NULL},
	{d_button_proc, 110, 140, 40, 20, 255, 0, 0, D_EXIT, 0, 0, q_ok, NULL, NULL},
	{btn_drop, 152, 140, 40, 20, 255, 0, 0, 0, 0, 0, q_drop, NULL, NULL},
	{btn_get, 194, 140, 40, 20, 255, 0, 0, 0, 0, 0, q_get, NULL, NULL},
	{d_list_proc, 81,  41, 98, 80, 255, 0, 0, 0, 0, 0, haslist_func, NULL, NULL},
	{d_list_proc, 180, 41, 98, 80, 255, 0, 0, 0, 0, 0, alllist_func, NULL, NULL},
	{NULL}
};
int StdCast::edit_inventory()
{
	pm=this;
	did_edit=0;
	av_obj.clear();
	MList& e=Level::current->everything;
	for (int i=0; i<e.count(); ++i)
	{
		if (!e[i]->is_nowhere())
			av_obj.add(e[i]);
	}
	strcpy(mname, name());
	popup_dialog(gobj_dlg, -1);
	return did_edit;
}
static char* haslist_func(int index, int* num)
{
	AList& l=pm->inventory();
	if (index>=0)
	{
		return l[index]->name();
	}
	else
	{
		*num=l.count();
		return 0;
	}
}
static char* alllist_func(int index, int* num)
{
	if (index>=0)
	{
		return av_obj[index]->name();
	}
	else
	{
		*num=av_obj.count();
		return 0;
	}
}
static int btn_drop(int msg, DIALOG* me, int c)
{
	int ans=d_button_proc(msg, me, c);
	if (me->flags & D_SELECTED)
	{
		me->flags &= ~D_SELECTED;
		int ix=gobj_dlg[5].d1;
		MovableObj* o=pm->inventory()[ix];
		pm->inventory().remove(o);
		av_obj.add(o);
		o->move_to(pm->get_x(), pm->get_y());
		did_edit=1;
		broadcast_dialog_message(MSG_DRAW, 0);
	}
	return ans;
}
static int btn_get(int msg, DIALOG* me, int c)
{
	int ans=d_button_proc(msg, me, c);
	if (me->flags & D_SELECTED)
	{
		me->flags &= ~D_SELECTED;
		int ix=gobj_dlg[6].d1;
		MovableObj* o=av_obj[ix]; 
		av_obj.remove(o);
		pm->inventory().add(o);
		o->move_nowhere();
		did_edit=1;
		broadcast_dialog_message(MSG_DRAW, 0);
	}
	return ans;
}

#endif

