#include <allegro.h>

void slide_show(char* f)
{
	BITMAP* bm=create_bitmap(SCREEN_W,SCREEN_H);
	int deltime=get_config_int("slideshow", "delay", 8000);
	DATAFILE* d=load_datafile(f);
	if (d==0) return;
	fade_out(1);
	clear(screen);
	set_palette((PALETTE) d[0].dat);
	for (int i=1; d[i].type==DAT_BITMAP; ++i)
	{
		BITMAP* ld=(BITMAP*) d[i].dat;
		clear_to_color(bm, makecol(128,128,128));
		blit(ld, bm, 0, 0, (SCREEN_W-ld->w)/2, (SCREEN_H-ld->h)/2, ld->w, ld->h);
		for (int xx=0; xx<160; xx+=8)
		{
			int yy=xx*5/8;
			vsync();
			blit(bm, screen, 160-xx, 0, 0, 0, xx, 100);
			blit(bm, screen, 160, 100-yy, 160, 0, 160, yy);
			blit(bm, screen, 160, 100, 320-xx,100, xx, 100);
			blit(bm, screen, 0, 100, 0, 200-yy, 160, yy);
		}
		blit(bm, screen, 0, 0, 0, 0, 320, 200);
		rest(deltime);
	}
	destroy_bitmap(bm);
	unload_datafile(d);
	fade_out(1);
}
