#include <allegro.h>
#include <stdio.h>
#include "pyotr.h"
#include "datafile.h"
#include "map.h"
#include "hbag.h"
#include "input.h"
#include "actions.h"
#include "level.h"
#include "bstrm.h"

extern DATAFILE* adata;
extern FONT* small_font;

#define DX 4
#define DY 3
static int rix[]={
	DAT_P_R_1,
	DAT_P_R_2,
	DAT_P_R_3,
	DAT_P_R_6,
	DAT_P_R_1,
	DAT_P_R_4,
	DAT_P_R_5,
	DAT_P_R_7};
static int lix[]={
	DAT_P_L_1,
	DAT_P_L_2,
	DAT_P_L_3,
	DAT_P_L_6,
	DAT_P_L_1,
	DAT_P_L_4,
	DAT_P_L_5,
	DAT_P_L_7};
static int uix[]={
	DAT_PYOTR1U_BMP,
	DAT_PYOTR1U_BMP,
	DAT_PYOTR2U_BMP,
	DAT_PYOTR2U_BMP,
	DAT_PYOTR1U_BMP,
	DAT_PYOTR1U_BMP,
	DAT_PYOTR2U_BMP,
	DAT_PYOTR2U_BMP,
};
static int dix[]={
	DAT_PYOTR1D_BMP,
	DAT_PYOTR1D_BMP,
	DAT_PYOTR2D_BMP,
	DAT_PYOTR2D_BMP,
	DAT_PYOTR1D_BMP,
	DAT_PYOTR1D_BMP,
	DAT_PYOTR2D_BMP,
	DAT_PYOTR2D_BMP,
};


Pyotr::Pyotr(Map& m, int ix, int iy) : MovingObj(m)
{
	move_to(ix, iy);
	
	for (int i=0; i<P_FRAMES; ++i)
	{
		f_r[i]=rle_dat(adata[rix[i]]);
		f_l[i]=rle_dat(adata[lix[i]]);
		f_u[i]=rle_dat(adata[uix[i]]);
		f_d[i]=rle_dat(adata[dix[i]]);
	}
	step=0;
	facing=2;
	choose_image();
}

int Pyotr::move()
{
	int dx=0, dy=0;
	if (Control->r()) dx=DX;
	if (Control->l()) dx=-DX;
	if (Control->u()) dy=-DY;
	if (Control->d()) dy=DY;
	if (map.tile(dx+x, dy+y)) 
	{
		return 0;
	}

	if (dx<0) 
	{
		facing=4;
		step--;
		if (step<0) step=P_FRAMES-1;
	}
	else if (dx>0)
	{
		facing=2;
		step++;
		if (step>=P_FRAMES) step=0;
	}
	else if (dy>0)
	{
	 	facing=3;
	 	step++;
		if (step>=P_FRAMES) step=0;
	}
	else if (dy<0)
	{
		facing=1;
		step--;
		if (step<0) step=P_FRAMES-1;
	} else
		return 0;
	
	move_to(x+dx, y+dy);
	choose_image();
	return 1;
}

void Pyotr::choose_image()
{
	RLE_SPRITE** q;
	switch(facing)
	{
		case 1:
			q=f_u;
			break;
		case 2:
			q=f_r;
			break;
		case 3:
			q=f_d;
			break;
		case 4:
		default:
			q=f_l;
			break;
	}
	img=q[step];
}

char* Pyotr::name()
{
	return "Pyotr";
}

AAction* Pyotr::actions()
{
	static AAction pa[]={AA_CHECK, AA_END_LIST};
	return pa;
}

int Pyotr::do_action(AAction a, AParam p, AParam )
{
	MovableObj* mo;
	HBag& b=HBag::inst();
	switch(a)
	{
		case AA_CHECK:
			b<<">Check Pyotr\nPyotr is at ("
				<< x << "," << y <<")\n";
			return AA_MSG;
		case _AA_GETOBJ:
			b<<"OK\n";
			mo = (MovableObj*) p.obj;
			inv_items.add(mo);
			mo->move_nowhere();
			return AA_CHANGED_INV;
		case _AA_DROPOBJ:
			b<<"OK\n";
			mo = (MovableObj*) p.obj;
			inv_items.remove(mo);
			mo->move_to(*this);
			return AA_CHANGED_INV;
		default:
			return AA_NOTHING;
	}
}
			
void Pyotr::persist(BStream& b)
{
	if (b.writing())
	{
		b<<get_x()<<get_y();
		for (int i=0; i<inv_items.count(); ++i)
			b<<inv_items[i]->persistent_name();
		b<<"<EOL>";
		
	}
	else
	{
		int x,y;
		b>>x>>y;
		move_to(x,y);
		inv_items.clear();
		while (1)
		{
			char n[64];
			b>>n;
			AObject* o=Level::current->find_obj(n);
			if (o)
				inv_items.add(o);
			else
				break;
		}
	}
}

#ifdef HAS_EDITOR
static char msg[40];
static DIALOG p_dlg[]={
{d_box_proc, 100, 60, 100, 100, 255, 0, 0, 0, 0, 0, NULL,NULL, NULL},
{d_text_proc, 101, 61, 98, 20, 255, 0, 0, 0, 0, 0, msg, NULL, NULL},
{d_button_proc, 130, 140, 40, 20, 255, 0, 0, D_EXIT, 0, 0, "OK", NULL, NULL},
{NULL}
};

int Pyotr::edit()
{
	sprintf(msg, "%s(%d,%d)", name(), get_x(), get_y());
	popup_dialog(p_dlg, -1);
	return 0;
}
#endif
