#include <string.h>
#include "aobject.h"
#include "precursr.h"
#include "bstrm.h"
#include "level.h"
#include "fixtures.h"

extern RLE_SPRITE* rle(char*);

class psimple : public Precursor
{
	public:
	psimple() : inst(0) {}
	~psimple() {if (inst) delete inst;}
	AObject* create();
	int thumbnail(BITMAP*);
	protected:
	virtual void real_create(RLE_SPRITE*)=0;
	void persist(BStream&);
	char img_name[64];
	AObject* inst;
};

class PreSolid : public psimple
{
	public:
	PreSolid() {}
	~PreSolid() {}
	void real_create(RLE_SPRITE*);
	char* persistent_name() const {return "Solid";}
};
class PreClear : public psimple
{
	public:
	PreClear() {}
	~PreClear() {}
	void real_create(RLE_SPRITE*);
	char* persistent_name() const {return "Clear";}
};

class PreZoneMarker: public Precursor
{
	public:
	PreZoneMarker();
	void persist(BStream&);
	AObject* create();
	char* persistent_name() const {return "ZoneMarker";}
	// a visible 'spot' for editing
	// the actual ZoneMarker object is invisible
	int thumbnail(BITMAP*);
	private:
	char img_name[64];
};

class PreDoor: public Precursor
{
	public:
	PreDoor(int type) : t(type) {img_name[0]='\0';}
	AObject* create();
	void persist(BStream&);
	char* persistent_name() const {return (char*) (t ? "LockingDoor" : "Door");}
	int thumbnail(BITMAP*);
	private:
	const int t;
	char img_name[64];
};
class PreWell : public psimple
{
	public:
	PreWell() {}
	void real_create(RLE_SPRITE*);
	char* persistent_name() const {return "Well";}
};
class PreGramophone: public psimple
{
	public:
	PreGramophone() {}
	void real_create(RLE_SPRITE*);
	char* persistent_name() const  {return "Gramophone";}
};

class PreSign : public psimple
{
	public:
	PreSign() {}
	void real_create(RLE_SPRITE*);
	char* persistent_name() const {return "Sign";}
};

class PreWarp: public Precursor
{
	public:
	PreWarp() {img_name[0]='\0';}
	AObject* create() {return new Warp;}
	void persist(BStream&);
	char* persistent_name() const {return "Warp";}
	private:
	char img_name[64];
};

Precursor::Precursor()	
{  }
Precursor::~Precursor()	
{  }

Precursor* Precursor::get(char* n)
{
	if (strcmp(n, "Solid")==0) return new PreSolid;
	if (strcmp(n, "Clear")==0) return new PreClear;
	if (strcmp(n, "Well")==0) return new PreWell;
	if (strcmp(n, "Sign")==0) return new PreSign;
	if (strcmp(n, "Door")==0) return new PreDoor(0);
	if (strcmp(n, "Warp")==0) return new PreWarp;
	if (strcmp(n, "LockingDoor")==0) return new PreDoor(1);
	if (strcmp(n, "ZoneMarker")==0) return new PreZoneMarker;	
	if (strcmp(n, "Gramophone")==0) return new PreGramophone;
	return 0;
}

void psimple::persist(BStream& b)
{
	if (b.reading())
	{
		b>>img_name;
	}
	else
	{
		b<<persistent_name()<<img_name;
	}
}


void create_thumb(char* im_name, BITMAP* bm)
{
	RLE_SPRITE* im=rle(im_name);
	BITMAP* tmp=create_bitmap(im->w, im->h);
	clear(tmp);
	draw_rle_sprite(tmp, im, 0, 0);
	stretch_blit(tmp, bm, 0, 0, tmp->w, tmp->h,  
		0, 0, bm->w, bm->h);
	destroy_bitmap(tmp);
}

int psimple::thumbnail(BITMAP* bm)
{
	if (img_name[0]!='\0')
	{
		create_thumb(img_name, bm);
		return 1;
	}
	else
		return 0;
}

AObject* psimple::create()
{
	if (inst==0)
	{
		real_create(rle(img_name));
	}
	return inst;
}

void PreClear::real_create(RLE_SPRITE* i)
{
	inst=new BackgroundObj(i);
}
void PreSolid::real_create(RLE_SPRITE* i)
{
	inst=new StaticObj(i);
}
AObject* PreDoor::create()
{
	return t ? new LockingDoor : new Door;
}

void PreDoor::persist(BStream& b)
{
	// read/write image name even though we don't use it.
	if (b.reading())
	{
		b>>img_name;
	}
	else
	{
		b<<img_name;
	}
}
int PreDoor::thumbnail(BITMAP* bm)
{
	if (img_name[0]!='\0')
	{
		create_thumb(img_name, bm);
		return 1;
	}
	else
		return 0;
}

void PreWell::real_create(RLE_SPRITE*)
{
	inst=new Well;
}
void PreSign::real_create(RLE_SPRITE*)
{
	inst=new Sign;
}
void PreGramophone::real_create(RLE_SPRITE*)
{
	inst=new Gramophone;
}
void PreWarp::persist(BStream& b)
{
	if (b.writing())
	{
		b<< img_name;
	}
	else
	{
		b>>img_name;
	}
}

PreZoneMarker::PreZoneMarker()
{
	img_name[0]='\0';
}

void PreZoneMarker::persist(BStream& b)
{
	if (b.writing())
	{
		b<<img_name;
	}
	else
	{
		b>>img_name;
	}
}

AObject* PreZoneMarker::create()
{
	return new ZoneMarker;
}

int PreZoneMarker::thumbnail(BITMAP* bm)
{
	clear(bm);
	rect(bm, 0,0,bm->w-1,bm->h-1, makecol(255,0,255));
	return 1;
}


