// playmain.cc
#include <allegro.h>
#include <stdio.h>
#include "atlantis.h"
#include "map.h"
#include "hbag.h"
#include "input.h"
#include "level.h"
#include "actions.h"
#include "bstrm.h"
#include "bfstrm.h"
#include "precursr.h"
#include "pager.h"

volatile int ticks=0;
volatile int seconds=0;
int frames=0;
Pager pager;
extern DATAFILE* adata;


void s_hand()
{
	seconds++;
}
END_OF_FUNCTION(s_hand);
void t_hand()
{
	ticks++;
}
END_OF_FUNCTION(t_hand);

Level::Level() : m(16, 10)
{
	player=0;
	for (int i=0; i<256; ++i)
	{
		tcache[i]=0;
	}
	datfile=0;
	mdata=0;
	mdata_size=0;
}

Level::~Level()
{
	for (int i=0; i<mdata_size; ++i)
		mdata[i]->dispose();
	delete[] mdata;
	for (int i=0; i<256; ++i)
		if (tcache[i]) delete tcache[i];
	for (int i=0; i<everything.count(); ++i)
		delete everything[i];
	if (datfile) unload_datafile(datfile); 
}
void Level::put_everything()
{
	for (int i=0; i<everything.count(); ++i)
		m.put(everything[i]);
}

int Level::play()
{
	RGB* pal=PALETTE(find_data("WinPal")->dat);
	set_palette(pal);
	clear(screen);
	LOCK_FUNCTION(t_hand);
	LOCK_FUNCTION(s_hand);
	LOCK_VARIABLE(ticks);
	LOCK_VARIABLE(seconds);
	HBag bag(*player);
	m.draw();
	int real_rate=0;
	int rate=get_config_int("atlantis", "rate", 15);
	int showrate=get_config_int("atlantis", "showrate", 0);
	if (rate>0)
	{
		install_int_ex(t_hand, BPS_TO_TIMER(rate));
	}
	install_int_ex(s_hand, BPS_TO_TIMER(1));
	int go=1;
	int in_f=0;
	BITMAP* subs=m.surface();
	while(go)
	{
		frames++;
		Control->poll();
		for (int i=0; i<everything.count(); ++i)
		{
			m.unput(everything[i]);
			if (everything[i]->move())
			{
				m.zone_action(everything[i]);
			}
		}
		int big_move=m.ensure_focus(player)>1;
		put_everything();
		m.update();
		if (showrate)
		{
			text_mode(0);
			if ((seconds&15)==15)
			{
				real_rate=frames/seconds;
			}
			textprintf(subs, font, 
				0, 0, 255, "%d", 
				real_rate);
		}
		pager.display(subs, seconds);
		while (rate>0 && ticks<0)
		{
		}
		ticks--;
		if (big_move)
		{
			fade_out(4);
			blit(subs, screen, 0, 0, 0, 0, subs->w, subs->h);
			fade_in(pal, 4);
		}
		else
		{
			blit(subs, screen, 0, 0, 0, 0, subs->w, subs->h);
		}
		if (Control->a())
		{
			int os=seconds;
			bag.show();
			ticks=0;
			seconds=os;
		}
		if (Control->f())
		{
			if (!in_f)
				player->f();
			in_f=1;
		}
		else
			in_f=0;
		
		if (Control->e())
		{
			switch(ingame_options())
			{
				case OptionExit:
					go=0;
					break;
				case OptionSave:
				{
					BOFStream b("save_me.bin");
					b<<persistent_name();
					persist(b);
				}
					break;
#ifdef HAS_EDITOR
				case OptionEdit: // tweak
					edit();
					break;
#endif
				default:
					break;
			}
			ticks=0;
		}
	} 
	remove_int(t_hand);
	remove_int(s_hand);
	return 0;
}
int Level::create_bg_map(BITMAP* bm)
{
	bg_bitmap=bm;
	return 0;
}

int Level::create_fg_map(BITMAP* bm)
{
	fg_bitmap=bm;
	mdata=new (AObject*)[mdata_size=bm->w*bm->h];
	for (int i=0; i<bm->w; ++i)
		for (int j=0; j<bm->h; ++j)
		{
			Precursor* o=tcache[_getpixel(bm, i, j)];
			if (o==0)
			{
				char mb[100];
				sprintf(mb, "Invalid tile %d at (%d,%d)", 
					getpixel(bm,i,j), i, j);
				app_close(mb);
			}
			mdata[i+j*bm->w]=o->create();
		}
	m.set_map(mdata, bm->w, bm->h);
	int ts=get_config_int("atlantis", "tiles", 20);
	m.set_surface(screen, ts, ts);
	return 0;
}
void Level::persist(BStream& s)
{
	TRACE("Level %s: persistent %s \n", name(), s.reading() ? "read":"write");
	if (s.reading())
	{
		while(1)
		{
			char nn[32];
			s>>nn;
			// find named object - any non-valid name 
			// terminates list
			AObject* o=find_obj(nn);
			// then read in its data
			if (o)
				o->persist(s);
			else
			{
				TRACE("Finished (%s)\n", nn);
				break;
			}
		}
	}
	else
	{
		for (int i=0; i<everything.count(); ++i)
		{
			AObject& o=*everything[i];
			s<<o.persistent_name();
			o.persist(s);
		}
		s<<"<EOL>";
	}
	// (re)store map stuff
	for (int i=0; i<mdata_size; ++i)
		mdata[i]->persist(s);
}

AObject* Level::find_obj(const char* k)
{
	for (int i=0; i<everything.count(); ++i)
	{
		if (strcmp(everything[i]->persistent_name(), k)==0)
			return everything[i];
	}
	return 0;
}

Level* Level::current=0;

int Level::load_data(char* n)
{
	datfile=load_datafile(n);
	return 0;
}

DATAFILE* Level::find_data(char* n)
{
	DATAFILE* d=datfile;
	while (d && d->type!=DAT_END)
	{
		const char *s=get_datafile_property(d, DAT_ID('N','A','M','E'));
		if (strcmp(s,n)==0)
			return d;
		else
			++d;
	}
	// Not found so look in 'global' datafile
	d=adata;
	while (d && d->type!=DAT_END)
	{
		const char *s=get_datafile_property(d, DAT_ID('N','A','M','E'));
		if (strcmp(s,n)==0)
			return d;
		else
			++d;
	}
	char mb[100];
	// Not found - bomb out
	sprintf(mb, "Data object \"%s\" not found", n);
	app_close(mb);
	return 0;
}

RLE_SPRITE* rle(char* s)
{
	return (RLE_SPRITE*) Level::current->find_data(s)->dat;
}
RLE_SPRITE* rle(const char* z)
{
	return rle((char*) z);
}

int MovingObj::f()
{
	AObject* env[9];
	map.get_surround(x,y,env);
	AParam p1;
	p1.obj=this;
	// any response from the object we're standing on?
	int a=env[4]->do_action(AA_DEFAULT, p1);
	if (a!=AA_NOTHING) 
		return a;
	// otherwise what are we facing?
	AObject* p[3];
	switch(facing)
	{
		case 1: //up
			p[0]=env[1];
			p[1]=env[0];
			p[2]=env[2];
			break;
		case 2: // right
			p[0]=env[5];
			p[1]=env[2];
			p[2]=env[8];
			break;
		case 3:// down
			p[0]=env[7];
			p[1]=env[8];
			p[2]=env[6];
			break;
		case 4: //left
			p[0]=env[3];
			p[1]=env[0];
			p[2]=env[6];
			break;
		default: // dunno?
			p[0]=p[1]=p[2]=0;
	}
	if (p[0] && ((a=p[0]->do_action(AA_DEFAULT, p1)) !=AA_NOTHING))
		return a;
	if (p[1] && ((a=p[1]->do_action(AA_DEFAULT, p1)) !=AA_NOTHING))
		return a;
	if (p[2] && ((a=p[2]->do_action(AA_DEFAULT, p1)) !=AA_NOTHING))
		return a;
	return AA_NOTHING;
}

