#include <allegro.h>
#include "pager.h"
#include "hbag.h"

Pager::Pager()
{
	head=tail=current=0;
	buff=0;
}

int Pager::message(int c, char* s, int delta)
{
	// add to queue
	msg* n=new msg;
	n->next=0;
	if (head)
	{
		tail->next=n;
		tail=tail->next;
	}
	else
		head=tail=n;
	// if string too long then aaaaargh!
	strcpy(tail->s, s);
	tail->off_time=delta;
	tail->c=c;
	fh=text_height(font);
	return 1;
}
int Pager::message(char* s, int delta)
{
	return message(makecol(0,0,0), s, delta);
}
void Pager::display(BITMAP* s, int now)
{
	if (current)
	{
		if (buff)
			blit(buff, s, 0, 0, 0, s->h-buff->h, buff->w, buff->h);
		if (current->off_time<now)
		{
			// time for a new one
			queue_next(now);
		}
	}
	else
	{
		queue_next(now);
	}
}

int Pager::queue_next(int now)
{
	if (current) delete current;
	if (head)
	{
		current=head;
		head=head->next;
		current->off_time+=now;
		int text_w=text_length(font, current->s)+5;
		if (buff==0 || buff->w<text_w)
		{
			if (buff) destroy_bitmap(buff);
			buff=create_bitmap(text_w, fh+3);
		}
		clear_to_color(buff, makecol(255,255,255));
		text_mode(-1);
		int blk=makecol(0,0,0);
		textout(buff, font, current->s,
			1, 1, current->c);
		HBag::inst() << "- " << current->s << "\n";
		return 1;
	}
	else
	{
		current=0;
		return 0;
	}
}

void Pager::clear()
{
	while(queue_next(0))
	{ }
}

