#include <allegro.h>
#include "map.h"
#include "aobject.h"
#include "actions.h"

EdgeO::EdgeO()
{
	BITMAP* t=create_bitmap(16,16);
	img=get_rle_sprite(t);
	destroy_bitmap(t);
}
EdgeO::~EdgeO()
{
	destroy_rle_sprite(img);
}

AObject* Map::cell(int x, int y) const
{
	if (x<0 || y<0 || x>=data_w || y>=data_h)
		return &edge;
	else
		return tiles[x+data_w*y];
}
int Map::tile(int x, int y) const
{
	return cell(x/tile_w, y/tile_h)->opaque();
}
int Map::zone_action(MovableObj* m)
{
	static AAction a={_AA_ZONE, 0};
	AParam p; p.obj=m;
	return cell(m->get_x()/tile_w, m->get_y()/tile_h)->do_action(a, p);
}
Map::Map(int tw, int th) 
{
	tiles=0;
	target=0;
	tile_w=tw;
	tile_h=th;
}
void Map::set_map(AObject** d, int dw, int dh)
{
	data_w=dw;
	data_h=dh;
	tiles=d;
}

void Map::set_surface(BITMAP*, int nw, int nh)
{
	if (tiles==0)
		return;
	if (target)
		destroy_bitmap(target);
	target=create_bitmap(tile_w*nw, tile_h*nh);
	num_w=nw;
	num_h=nh;
	org_x=org_y=0;
}

Map::~Map()
{	
}

int Map::clip(int x1, int y1, int x2, int y2)
{
	if (x1<0) 
	{
		x1=0;
	}
	if (x2>=target->w)
	{
		x2=target->w-1;
	}
	if (y1<0) 
	{
		y1=0;
	}
	if (y2>=target->h)
	{
		y2=target->h-1;
	}
	set_clip(target, x1, y1, x2, y2);	
	return (x2>x1) && (y2>y1);
}
void Map::draw_tile(int x, int y, AObject* bn)
{
	x+=(tile_w-bn->get_w())/2;
	y+=tile_h-bn->get_h();
	bn->draw(target, x, y);
}

void Map::draw()
{
	clip(0, 0, target->w-1, target->h-1);
	clear(target);
	const int di=org_x/tile_w;
	const int dj=org_y/tile_h;
	for (int j=dj; j<num_h+dj; ++j)
		for (int i=di; i<num_w+di; ++i)
			draw_tile(i*tile_w-org_x, j*tile_h-org_y, cell(i,j));
}

void Map::d_over(int x, int y, int w, int h)
{
	const int i1=x/tile_w;
	const int i2=(x+w+tile_w-1)/tile_w;
	const int j1=(y+h+tile_h-1)/tile_h;
	const int j2=(org_y+tile_h-1)/tile_h+num_h;
	for (int j=j1; j<j2; ++j)
	{
		for (int i=i1; i<i2; ++i)
		{
			draw_tile(i*tile_w-org_x, j*tile_h-org_y, cell(i,j));
		}
	}
}

void Map::d_under(int x, int y, int w, int h)
{
	const int i1=x/tile_w;
	const int i2=(x+w+tile_w-1)/tile_w;
	const int j1=y/tile_h;
	const int j2=(y+h+tile_h-1)/tile_h;
	for (int j=j1; j<j2; ++j)
	{
		for (int i=i1; i<i2; ++i)
		{
			draw_tile(i*tile_w-org_x, j*tile_h-org_y, cell(i,j));
		}
	}
}

void Map::put(MovableObj* m)
{
	int w=m->get_w(), h=m->get_h();
	int x=m->get_x()-w/2, y=m->get_y()-h;
	int sx=x-org_x;
	int sy=y-org_y;
	if (clip(sx, sy, sx+w-1, sy+h-1))
	{
		m->draw(target, sx, sy);
		d_over(x, y, w, h);
	}
}
void Map::unput(MovableObj* m)
{
	int w=m->get_w(), h=m->get_h();
	int x=m->get_x()-w/2, y=m->get_y()-h;
	int sx=x-org_x;
	int sy=y-org_y;
	if (clip(sx, sy, sx+w-1, sy+h-1))
	{
		clear(target);
		d_under(x, y, w, h);
		d_over(x, y, w, h);
	}
}

int Map::ensure_focus(MovableObj* m)
{
	int x=m->get_x(), y=m->get_y();
	int s_w=tile_w*num_w;
	int s_h=tile_h*num_h;
	int old_x=org_x, old_y=org_y;
	if (x<org_x+s_w/4)
	{
		org_x-=s_w/2;
		if (org_x<0) org_x=0;
	} else if (x>org_x+s_w*3/4)
	{
		org_x+=s_w/2;
		if (org_x > data_w*tile_w-s_w)
			org_x=data_w*tile_w-s_w;
	}
	if (y<org_y+s_h/4)
	{
		org_y-=s_h/2;
		if (org_y<0) org_y=0;
	} else if (y>org_y+s_h*3/4)
	{
		org_y+=s_h/2;
		if (org_y > data_h*tile_h-s_h)
			org_y=data_h*tile_h-s_h;
	}
	if ((org_y!=old_y) || (org_x!=old_x))
	{
		draw();
		return 1;
	}
	else
		return 0;
}

void Map::update()
{
	// to do: dirty rectangle stuff.
	set_clip(target, 0,0, target->w, target->h);
}

void Map::get_surround(int x, int y, AObject* a[])
{
	x/=tile_w;
	y/=tile_h;
	a[0]=cell(x-1,y-1);
	a[1]=cell(x, y-1);
	a[2]=cell(x+1, y-1);
	a[3]=cell(x-1, y);
	a[4]=cell(x, y);
	a[5]=cell(x+1, y);
	a[6]=cell(x-1, y+1);
	a[7]=cell(x, y+1);
	a[8]=cell(x+1, y+1);
}



