//map.h
#ifndef __MAP_H__
#define __MAP_H__
#include "aobject.h"
class DATAFILE;

class EdgeO: public AObject
{
	public:
	EdgeO();
	~EdgeO();
	char* name() {return "Edge";}
	int opaque() {return TT_SOLID;}
	AAction* actions() {return 0;}
};
	
class Map
{
	public:
	Map(int tw, int th);
	~Map();
	void set_map(AObject**, int cw, int ch);
	void set_surface(BITMAP*, int nw, int nh);
	void set_background(BITMAP* map, BITMAP* tiles);
	void draw();
	void put(MovableObj*);
	void unput(MovableObj*);
	int ensure_focus(MovableObj*);
	void update();
	void set_origin(int, int);
	BITMAP* save();
	int tile(int x, int y) const;
	int zone_action(MovableObj*);
	void get_surround(int x, int y, AObject*[]);
	BITMAP* surface() const {return target;}
	// convert pixel coords to map coords
	int p2m_x(int x) const {return (x+tile_w/2)/tile_w;}
	int p2m_y(int y) const {return (tile_h+y)/tile_h;}
	#ifdef HAS_EDITOR
	// convert screen pixel coords to map tile coords
	int s2m_x(int x) const {return (x+org_x+tile_w/2)/tile_w;}
	int s2m_y(int y) const {return (y+org_y)/tile_h;}
	// convert screen to pixel
	int s2p_x(int x) const {return x+org_x;}
	int s2p_y(int y) const {return y+org_y;}
	int ensure_focus(int x, int y);
	#endif
	private:
	void draw_background();
	AObject* cell(int x, int y) const;
	int tile_w, tile_h, num_w, num_h;
	int data_w, data_h;
	int org_x, org_y;
	BITMAP* target;
	AObject** tiles;
	BITMAP* back_layer;
	BITMAP* back_tiles;
	BITMAP* back_map;
	EdgeO* edge;
	MovableObj* mo_list[30];
	int mo_i;
};
	
#endif
