#include <allegro.h>
#include <stdlib.h>
#include "map.h"
#include "aobject.h"
#include "actions.h"

char* crap(AObject* o)
{
	static char* nul="<NULL>";
	return o ? o->name() : nul;
}


EdgeO::EdgeO()
{
	BITMAP* t=create_bitmap(16,16);
	img=get_rle_sprite(t);
	destroy_bitmap(t);
}
EdgeO::~EdgeO()
{
	destroy_rle_sprite(img);
}

AObject* Map::cell(int x, int y) const
{
	if (x<0 || y<0 || x>=data_w || y>=data_h)
		return edge;
	else
		return tiles[x+data_w*y];
}
int Map::tile(int x, int y) const
{
	return cell(p2m_x(x), p2m_y(y))->opaque() & TT_SOLID;
}
int Map::zone_action(MovableObj* m)
{
	AParam p; p.obj=m;
	int x=m->get_x();
	int y=m->get_y();
	return cell(p2m_x(x), p2m_y(y))->do_action(_AA_ZONE, p);
}

Map::Map(int tw, int th) 
{
	tiles=0;
	target=back_layer=back_map=back_tiles=0;
	tile_w=tw;
	tile_h=th;
	edge=new EdgeO;
	mo_i=0;
}
void Map::set_map(AObject** d, int dw, int dh)
{
	data_w=dw;
	data_h=dh;
	tiles=d;
}

void Map::set_surface(BITMAP*, int nw, int nh)
{
	if (tiles==0)
		return;
	if (target)
		destroy_bitmap(target);
	target=create_bitmap(tile_w*nw, tile_h*nh);
	num_w=nw;
	num_h=nh;
	org_x=org_y=0;
}

void Map::set_background(BITMAP* map, BITMAP* tiles)
{
	if (map==0 || tiles==0 || target==0) return; 
	if (back_layer)
		destroy_bitmap(back_layer);
	back_layer=create_bitmap(target->w, target->h);
	clear(back_layer);
	back_map=map;
	back_tiles=tiles;
}

inline void del(BITMAP* b)
{
	if (b) destroy_bitmap(b);
}

Map::~Map()
{
	del(target);
	del(back_layer);
	delete(edge);
}

void Map::draw()
{
	draw_background();
	update();
}
void Map::draw_background()
{
	if (back_layer)
	{
		const int di=org_x/tile_w;
		const int dj=org_y/tile_h;
		int y= -(org_y%tile_h);
		const int ix= -(tile_w/2+(org_x%tile_w));
		for (int j=dj; j<=num_h+dj; ++j)
		{
			int x=ix;
			for (int i=di; i<=num_w+di; ++i)
			{
				int c=getpixel(back_map, i, j);
				if (c<0) c=0;
				int sx=(c%16)*tile_w;
				int sy=(c/16)*tile_h;
				blit(back_tiles, back_layer, sx,sy,
					x,y,tile_w, tile_h);
				x+=tile_w;
			}
			y+=tile_h;
		}
	}
}

struct Rect
{
	int x,y,w,h;
} r_list[30];
int r_i=0;

void Map::put(MovableObj* m)
{	
	// is it on screen?
	int x=m->get_x()-org_x;
	int y=m->get_y()-org_y;
	if (x>=0 && x<target->w && y>=0 && y<target->h)
	{
		// yes so add to list
		if (mo_i<30)
			mo_list[mo_i++]=m;
	}
}
void Map::unput(MovableObj* )
{
}

/*int Map::ensure_focus(MovableObj* m)
{
	int x=m->get_x(), y=m->get_y();
	int s_w=tile_w*num_w;
	int s_h=tile_h*num_h;
	int old_x=org_x, old_y=org_y;
	if (x<org_x+s_w/4)
	{
		org_x=x-s_w*3/4;
		if (org_x<0) org_x=0;
	} else if (x>org_x+s_w*3/4)
	{
		org_x=x-s_w/4;
		if (org_x > data_w*tile_w-s_w)
			org_x=data_w*tile_w-s_w;
	}
	if (y<org_y+s_h/4)
	{
		org_y=y-s_h*3/4;
		if (org_y<0) org_y=0;
	} else if (y>org_y+s_h*3/4)
	{
		org_y=y-s_h/4;
		if (org_y > data_h*tile_h-s_h)
			org_y=data_h*tile_h-s_h;
	}
	if ((org_y!=old_y) || (org_x!=old_x))
	{
		draw_background();
		int dx=old_x-org_x;
		int dy=old_y-org_y;
		int fade=(dx<-s_w || dx>s_w || dy<-s_h || dy>s_h);
		return fade ? 2 : 1;
	}
	else
		return 0;
}*/

int Map::ensure_focus(MovableObj* m)
{
	int x=m->get_x(), y=m->get_y();
	int s_w=tile_w*num_w;
	int s_h=tile_h*num_h;
	int old_x=org_x, old_y=org_y;
	org_x=x-s_w/2;
	org_y=y-s_h/2;
	if (org_x<0) org_x=0;
	if (org_x > data_w*tile_w-s_w)
		org_x=data_w*tile_w-s_w;
	if (org_y<0) org_y=0;
	if (org_y > data_h*tile_h-s_h)
		org_y=data_h*tile_h-s_h;
	if ((org_y!=old_y) || (org_x!=old_x))
	{
		draw_background();
		int dx=old_x-org_x;
		int dy=old_y-org_y;
		int fade=(dx<-s_w || dx>s_w || dy<-s_h || dy>s_h);
		return fade ? 2 : 1;
	}
	else
		return 0;
}

#ifdef HAS_EDITOR
int Map::ensure_focus(int x,int y)
{
	int s_w=tile_w*num_w;
	int s_h=tile_h*num_h;
	int old_x=org_x, old_y=org_y;
	org_x=x-s_w/2;
	org_y=y-s_h/2;
	if (org_x<0) org_x=0;
	if (org_x > data_w*tile_w-s_w)
		org_x=data_w*tile_w-s_w;
	if (org_y<0) org_y=0;
	if (org_y > data_h*tile_h-s_h)
		org_y=data_h*tile_h-s_h;
	if ((org_y!=old_y) || (org_x!=old_x))
	{
		draw_background();
		return 1;
	}
	else
		return 0;
}
#endif

int mo_cmp_func(const void* a, const void* b)
{
	return (*(const MovableObj**) a)->get_y()-(*(const MovableObj**)b)->get_y();
}

// screen_x=x-w/2-x_org;
// screen_y=y-h-y_org+tile_h;
// x=screen_x+w/2+x_org;
// y=screen_y+h+y_org-tile_h;

void Map::update()
{
	if (back_layer)
		blit(back_layer,target,0,0,0,0,target->w,target->h);
	else
		clear(target);
	// depth sort the images
	qsort(mo_list, mo_i, sizeof(MovableObj*), mo_cmp_func);
	// 
	MovableObj** p=mo_list;
	int ct=mo_i;
	int i1=org_x/tile_w;
	int j1=org_y/tile_h;
	int i2=i1+num_w;
	int j2=j1+num_h;
	if (i1<0) i1=0;
	if (j1<0) j1=0;
	if (i2>data_w) i2=data_w;
	if (j2>data_h) j2=data_h;
	int y=(j1+1)*tile_h-org_y;
	for (int j=j1; j<j2; ++j)
	{
		int x=i1*tile_w-org_x;
		AObject** row=&tiles[j*data_w];
		// draw a row
		for (int i=i1; i<=i2; ++i)
		{
			AObject& o=*row[i];
			if (&o==NULL) return;
			o.draw(target, x-o.get_w()/2, y-o.get_h());
			x+=tile_w;
		}
		y+=tile_h;
		// draw all images on this row
		while ((ct>0) && ((*p)->get_y()<j*tile_h))
		{
			MovableObj&m=**p;
			int w=m.get_w(), h=m.get_h();
			int x=m.get_x()-w/2, y=m.get_y()-h+tile_h;
			int sx=x-org_x;
			int sy=y-org_y;
			m.draw(target, sx, sy);
			++p;
			--ct;
		}
	}
	mo_i=0;
}

void Map::get_surround(int x, int y, AObject* a[])
{
	x=p2m_x(x);
	y=p2m_y(y);
	a[0]=cell(x-1,y-1);
	a[1]=cell(x, y-1);
	a[2]=cell(x+1, y-1);
	a[3]=cell(x-1, y);
	a[4]=cell(x, y);
	a[5]=cell(x+1, y);
	a[6]=cell(x-1, y+1);
	a[7]=cell(x, y+1);
	a[8]=cell(x+1, y+1);
}



