#include "atlantis.h"
#include "all_lev.h"
#include "bfstrm.h"
#include "levsel.h"

void slide_show(char*);

LevelStatus LevelStates[NumLevels];

Level* CreateLevel(LevelID);
Level* CreateLevel(ps_rep);

static void restore_game()
{
	BIFStream b("save_me.bin");
	char ln[64];
	b>>ln;
	TRACE("Restore from %s\n", ln);
	Level::current=CreateLevel(LevelID(ln));
	if (Level::current)
	{
		Level::current->prepare();
		Level::current->persist(b);
		Level::current->play();
	}
}

void play_game()
{
	LevelID ll=SelectLevel(LevelStates);
	if (ll==0)
		return;
	Level::current=CreateLevel(ll);
	if (Level::current)
	{
		Level::current->prepare();
		Level::current->play();
	}
}

#ifdef HAS_EDITOR
static void edit_game()
{
	LevelID ll=SelectLevelForEdit();
	if (ll==0)
		return;
	Level::current=CreateLevel(ll);
	if (Level::current==0)
	{
		app_close("Error creating level");
	}
	Level& g=*Level::current;
	g.prepare_from_file();
	g.edit();
	g.save_edits();
}
static void test_game()
{
	LevelID ll=SelectLevelForEdit();
	Level::current=CreateLevel(ll);
	if (Level::current==0)
	{
		app_close("Error creating level");
	}
	Level::current->prepare_from_file();
	Level::current->play();
}
#else
// should never get called
static void edit_game()
{ }
static void test_game()
{ }
#endif
	
int main()
{
	app_init();
	InitLevelStatus(LevelStates);
	for(;;)
	{
		TRACE("titles\n");
		show_titles();
		switch(game_options())
		{
			case OptionExit:
				show_end_titles();
				app_close();
				return 0;
			case OptionPlay:
				play_game();
				break;
			case OptionStory:
				slide_show("story.dat");
				break;
			case OptionRestore:
				restore_game();
				break;
			case OptionConfig:
				config_options();
				break;
			case OptionEdit:
				edit_game();
				break;
			case OptionTest:
				test_game();
			default:
				break;
		}
	}
} END_OF_MAIN();

#define CL(i, x) if (strcmp(id, i)==0) return new x

Level* CreateLevel(LevelID id)
{
	if (id==0) return 0;
	CL("Aquarius", Aquarius);
	CL("Gemini", Gemini);
	CL("Leo", Leo);
	CL("Scorpio", Scorpio);
	CL("Libra", Libra);
	return 0;
}


