#include <allegro.h>
#include "levsel.h"
#include "ticker.h"
#include "input.h"
#include "location.h"
#include "choose.h"


// input: array of 'status' (banned etc.)
// output: index number
// version for game and for edit
// edit ver ignores banned, and is simpler.

class TriBmp
{
	public:
	TriBmp(int base_id);
	int flyin();
	int flyout();
	void reset();
	static void load();
	static void unload();
	static BITMAP* osb;
	static RLE_SPRITE* banned;
	protected:
	BITMAP* img[3];
	int l(int x) const {return lut[x];}
	int pos;
	static DATAFILE* dfile;
	static int lut[];
};

static struct
{
	int pic;
	char* name;
} zones[12]=
{
	{ARIES1_BMP, "Aries"}, //suburbia
	{TAURUS1_BMP, "Taurus"}, // mystery
	{GEMINI1_BMP, "Gemini"}, //park
	{CANCER1_BMP, "Cancer"}, //jungle
	{LEO1_BMP, "Leo"}, //docks
	{VIRGO1_BMP, "Virgo"}, //underground facility
	{LIBRA1_BMP, "Libra"}, // drowned world
	{SCORPIO1_BMP, "Scorpio"}, //desert tombs
	{SAGITTA1_BMP, "Sagittarius"}, //cryo-store
	{CAPRICO1_BMP, "Capricorn"}, //office factory
	{AQUARIU1_BMP, "Aquarius"}, //mystery 
	{PISCES1_BMP, "Pisces"}, // campus
};

LevelID SelectLevel(LevelStatus status[])
{
	int i;
	TriBmp::load();
	TriBmp* pt[12];
	Chooser ch(screen, 0, 0, 80, 200);
	ch.add(*new StaticTextItem("Select:",1));
	for (int i=0; i<12; ++i)
	{
		ch.add(*new TextItem(i, zones[i].name));
		pt[i]=new TriBmp(zones[i].pic);
	}
	int cur, sel;
	clear(screen);
	ch.process(0);
	cur=sel=ch.current().id();
	do
	{
		clear(TriBmp::osb);
		i=pt[cur]->flyin();
		wait_tick();
		blit(TriBmp::osb, screen, 80, 0, 80, 0, 240, 200);
	} while (i);
	int q=0;
	int done=0;
	while (!done)
	{
		if (cur!=sel && q<=0)
		{
				int i;
				do
				{
					clear(TriBmp::osb);
					i=pt[sel]->flyin() | pt[cur]->flyout();
					wait_tick();
					blit(TriBmp::osb, screen, 80, 0, 80, 0, 240, 200);
				} while (i);
				pt[cur]->reset();
				cur=sel;
		}
		else
		{
			Control->poll();
			if (q>0) 
			{
				q--;
			}
			if (Control->u())
			{
				ch.process(-1);
				q=10;
				sel=ch.current().id();
			}
			if (Control->d())
			{
				ch.process(1);
				q=10;
				sel=ch.current().id();
			}
			if (Control->f())
			{
				if (status[cur] == LevOK)
					done=1;
				else
					draw_rle_sprite(screen, TriBmp::banned, 120, 60);
			}
		}
		if (Control->e())
		{
			done=-1;
		}
	}
	do
	{
		clear(TriBmp::osb);
		i=pt[cur]->flyout();
		wait_tick();
		blit(TriBmp::osb, screen, 80, 0, 80, 0, 240, 200);
	} while (i);
	
	// empty the chooser.
	for (int i=0; i<ch.count(); ++i)
		delete& ch[i];
	
	TriBmp::unload();
	return done>0 ? LevelID(zones[cur].name) : LevelID(0);
}

int TriBmp::lut[]={0, 1, 3, 6, 10, 15, 21, 
	28, 36, 45, 55, 66, 78, 91, 
	105, 130, 146, 163, 181, 200,
	220, 241, 241 };
#define POS_MAX int(sizeof(TriBmp::lut)/sizeof(int)-1)

TriBmp::TriBmp(int b)
{
	img[0]=(BITMAP*) dfile[b+0].dat;
	img[1]=(BITMAP*) dfile[b+1].dat;
	img[2]=(BITMAP*) dfile[b+2].dat;
	pos=POS_MAX;
}

DATAFILE* TriBmp::dfile=0;
BITMAP* TriBmp::osb=0;
RLE_SPRITE* TriBmp::banned=0;

int TriBmp::flyin()
{
	blit(img[0], osb, 0, 0, 80-l(pos), 0, 128, 80);
	blit(img[2], osb, 0, 0, 80+l(pos), 120, 128, 80);
	blit(img[1], osb, 0, 0, 190,    60+l(pos), 128, 80);
	if (pos>0)
	{
		pos--;
		return 1;
	}
	else
		return 0;
}
int TriBmp::flyout()
{
	if (pos<POS_MAX)
	{
		blit(img[0], osb, 0, 0, 80+l(pos), 0, 128, 80);
		blit(img[2], osb, 0, 0, 80-l(pos), 120, 128, 80);
		blit(img[1], osb, 0, 0, 190,    60-l(pos), 128, 80);
		pos++;
		return 1;
	}
	else
		return 0;
}

void TriBmp::load()
{
	if (osb==0)
	{
		dfile=load_datafile("location.dat");
		osb=create_bitmap(320, 200);
		banned=(RLE_SPRITE*) dfile[Banned].dat;
		set_palette(PALETTE(dfile[ZZPalette].dat));
		start_tick(20);
	}
}

void TriBmp::unload()
{
	if (osb)
	{
		unload_datafile(dfile);
		dfile=0;
		destroy_bitmap(osb);
		osb=0;
		stop_tick();
	}
}

void TriBmp::reset()
{
	BITMAP* tmp;
	tmp=img[0];
	img[0]=img[1];
	img[1]=img[2];
	img[2]=tmp;
	pos=POS_MAX;
}
static int id_x(LevelID l)
{
	for (int i=0; i<NumLevels; ++i)
		if (LevelID(zones[i].name)==l)
			return i;
	return -1;
}

void InitLevelStatus(LevelStatus s[])
{
	for (int i=0; i<NumLevels; ++i)
	{
		s[i]=LevBanned;
	}
	// change this - these are the only levs I've done
	s[2]=s[4]=s[10]=s[7]=LevOK;
}
int MarkLevelComplete(LevelID l, LevelStatus s[])
// may make other levels accessible...
{
	int i=id_x(l);
	if (i>=0 && i<NumLevels)
	{
		s[i]=LevComplete;
		return 1;
	}
	else
		return 0;
}
LevelID SelectLevelForEdit()
{
	Chooser ch(screen, 0, 0, 80, 200);
	ch.add(*new StaticTextItem("Edit:",1));
	for (int i=0; i<12; ++i)
	{
		ch.add(*new TextItem(i, zones[i].name));
	}
	int ans=ch.choose();

	// empty the chooser.
	for (int i=0; i<ch.count(); ++i)
		delete& ch[i];

	return ans<0 ? LevelID(0) : LevelID(zones[ans].name);
}
