#ifndef __LEVEL_H__
#define __LEVEL_H__
// Level.h
#include "map.h"
class Precursor;
class BStream;

class Level
{
	public:
	Level();
	virtual int prepare()=0;
	virtual ~Level();
	int play();
	static Level* current;
	DATAFILE* find_data(char*);
	void persist(BStream&);
	virtual char* name()=0;
	virtual ps_rep persistent_name() {return ps_rep(name());}
	AObject* find_obj(const char*);
	#ifdef HAS_EDITOR
	int changed;
	virtual int prepare_from_file()=0;
	virtual int save_edits()=0;
	virtual int edit();
	int set_fg(int x, int y, int v);
	int set_bg(int x, int y, int v);
	int ed_fg(int x, int y);
	BITMAP* create_fg_img(int index);
	BITMAP* tile_bm() const {return tile_bitmap;}
	#endif
	Map& map() {return m;}
	void put_everything(); // draw all objects
	MList everything;
	protected:
	int create_fg_map(BITMAP*);
	int create_bg_map(BITMAP*);
	int load_data(char*);
	//
	MovingObj* player;
	Map m;
	int mdata_size;
	AObject** mdata;
	Precursor* tcache[256];
	DATAFILE* datfile;
	BITMAP* bg_bitmap;
	BITMAP* fg_bitmap;
	BITMAP* tile_bitmap;
};

#endif
