#ifdef HAS_EDITOR
#include <allegro.h>
#include "level.h"
#include "precursr.h"
#include "bookmark.h"
enum
{
	EDMODE_BG, EDMODE_FG, EDMODE_OBJ, EDMODE_PAL
};

extern FONT* smallfont;

BITMAP* BitmapFromString(const char* s)
{
	BITMAP* n=create_bitmap(8,8);
	const int ma=bitmap_mask_color(n);
	const int bl=makecol(0,0,0);
	const int wh=makecol(255,255,255);
	for (int y=0; y<8; ++y)
		for (int x=0; x<8; ++x)
		{
			int c;
			switch(*s++)
			{
				case 'X':
					c=wh;
					break;
				case '.':
					c=bl;
					break;
				default:
					c=ma;
					break;
			}
			putpixel(n, x, y, c);
		}
	return n;
}
static BITMAP* fg_pointer=0;
static BITMAP* bg_pointer=0;
static BITMAP* ob_pointer=0;
static char fg_pst[]=
"_.X..X._"
"..X..X.."
"XXX__XXX"
"..____.."
"..____.."
"XXX__XXX"
"..X..X.."
"_.X..X._";
static char bg_pst[]=
"__.X.___"
"__.X.___"
"...X..._"
"XXX_XXX_"
"...X..._"
"__.X.___"
"__.X.___"
"________";
static char ob_pst[]=
"_.XXXX._"
".X.__.X."
"X.____.X"
"X__X___X"
"X______X"
"X.____.X"
".X.__.X."
"_.XXXX._";



int Level::set_bg(int mx, int my, int np)
{
	int op=getpixel(bg_bitmap,mx,my);
	if (op!=np)
	{
		putpixel(bg_bitmap, mx, my, np);
		return 1;
	}
	else
	{
		return 0;
	}
}
int Level::set_fg(int mx, int my, int np)
{
	// Set, if the new object exists and
	// it is different from the old.
	
	int op=getpixel(fg_bitmap, mx, my);
	if (op!=np && tcache[np])
	{
		putpixel(fg_bitmap, mx,my, np);
		AObject* &o=mdata[mx+fg_bitmap->w*my];
		o->dispose();
		o=tcache[np]->create();
		return 1;
	}
	return 0;
}
int Level::ed_fg(int mx, int my)
{
	AObject* o=mdata[mx+fg_bitmap->w*my];
	return o->edit();
}
BITMAP* Level::create_fg_img(int)
{
	BITMAP* ans=create_bitmap(256,256);
	clear(ans);
	BITMAP* wkf=create_bitmap(16,16);
	for (int i=0; i<256; ++i)
	{
		if (tcache[i])
		{
			if (!tcache[i]->thumbnail(wkf))
			{
				// do the hard way
				AObject* o=tcache[i]->create();
				BITMAP* wk=create_bitmap(o->get_w(),o->get_h());
				clear(wk);
				o->draw(wk, 0, 0);
				stretch_blit(wk, ans, 
					0, 0, wk->w, wk->h,
					(i%16)*16, (i/16)*16, 16, 16);
				o->dispose();
				destroy_bitmap(wk);
			}
			else
			{
				blit(wkf, ans, 0, 0, (i%16)*16, (i/16)*16, 16, 16);
			}
		}
	}
	destroy_bitmap(wkf);
	return ans;
}
static int overlay_proc(int, DIALOG*, int);
static int ed_mode;
static int m_proc_em();
static int m_proc_end();
static int pal_proc(int, DIALOG*, int);
static int d_more_proc(int, DIALOG*, int);
static int slider_callback(void*, int);
static int m_proc_goxy();
static int m_proc_gobj();
static int m_proc_hide();
static int m_proc_bring();
static char* olist_func(int, int*);

static MENU level_menu[]={
// Text			Proc	Child	Flags	dp
{"&Save",		m_proc_end,	NULL,	0,		NULL},
{"&Quit",		m_proc_end,	NULL,	0,		NULL},
{NULL}
};
static MENU move_menu[]={
{"To &Object",	m_proc_gobj,NULL,	0,		NULL},
{"To &XY",		m_proc_goxy,NULL,	0,		NULL},
{"&Hide...", 	m_proc_hide,NULL, 	0, 		NULL},
{"&Bring...",  m_proc_bring,NULL, 	0, 		NULL},
{NULL},
};
static MENU edit_menu[]={
{"  &Foreground",	m_proc_em,	NULL,	0,		NULL},
{"  &Background",	m_proc_em,	NULL,	0,		NULL},
{"  &Object",		m_proc_em,	NULL,	0,		NULL},
{NULL},
};
static MENU main_menu[]={
{"&Level",		NULL,	level_menu,	0,		NULL},
{"&Move",		NULL,	move_menu,	0,		NULL},
{"&Edit",		NULL,	edit_menu,	0,		NULL},
{NULL},
};
static char* q_more="More...";
static DIALOG main_dlg[]={
//proc			x	y	w		h		fg	bg	key	flg	d1	d2	dp			dp2		dp3
{d_menu_proc, 	0, 	0, 	0, 		0, 		0, 	0, 	0, 	0, 	0, 	0, 	main_menu, 	NULL, 	NULL},
{overlay_proc,	0,	20,	256,	160,	0,	0, 	0, 	0,	16,	10,	NULL,	NULL,	NULL},
{pal_proc,	272, 10, 20, 	20,		255,0,	'1',0,	0,	0,	NULL,	NULL,	NULL},	
{pal_proc,	272, 42, 20, 	20,		255,0,	'2',0,	0,	0,	NULL,	NULL,	NULL},	
{pal_proc,	272, 74, 20, 	20,		255,0,	'3',0,	0,	0,	NULL,	NULL,	NULL},	
{pal_proc,	272, 106, 20, 	20,		255,0,	'4',0,	0,	0,	NULL,	NULL,	NULL},	
{pal_proc,	272, 138, 20, 	20,		255,0,	'5',0,	0,	0,	NULL,	NULL,	NULL},	
{d_more_proc,	272, 170, 48,	16,		255,0,	'0',0,	0,	0,	q_more,NULL, NULL},
{d_slider_proc, 0,	 180, 256, 	10,		255,0,	0,	0,255,0,NULL, slider_callback, NULL},
{d_slider_proc, 256, 20, 	8, 	160,	255,0,	0,	0,255,0,NULL, slider_callback, NULL},
{NULL}
};
static char t_wx[10], t_wy[10];
static char* q_ok="OK", *q_goxy="Goto X,Y", *q_x="X:", *q_y="Y";

static DIALOG goxy_dlg[]={
	{d_box_proc, 80, 80, 100, 80, 255, 0, 0, 0, 0, 0, NULL, NULL, NULL},
	{d_button_proc, 110, 140, 40, 20, 255, 0, 0, D_EXIT, 0, 0, q_ok, NULL, NULL},
	{d_ctext_proc, 130,81, 98, 20, 0, 255, 0, 0, 0, 0, q_goxy, NULL, NULL},
	{d_edit_proc, 100, 100, 80, 10, 255, 0, 0, 0, 9, 0, t_wx, NULL, NULL},
	{d_edit_proc, 100, 120, 80, 10, 255, 0, 0, 0, 9, 0, t_wy, NULL, NULL},
	{d_text_proc, 81, 100, 20, 10, 255, 0, 0, 0, 0, 0, q_x, NULL, NULL},
	{d_text_proc, 81, 120, 20, 10, 255, 0, 0, 0, 0, 0, q_y, NULL, NULL},
	{NULL}
};
static DIALOG gobj_dlg[]={
	{d_box_proc, 80, 40, 100, 120, 255, 0, 0, 0, 0, 0, NULL, NULL, NULL},
	{d_button_proc, 110, 140, 40, 20, 255, 0, 0, D_EXIT, 0, 0, q_ok, NULL, NULL},
	{d_list_proc, 81, 41, 98, 100, 255, 0, 0, D_EXIT, 0, 0, olist_func, NULL, NULL},
	{NULL}
};

static int px,py,pb;
static int do_click(DIALOG*);
static int active_pal;
static int did_ever_edit;
BITMAP* fg_thumbnails=0;

class TPal
{
	public:
	TPal(int size=5);
	~TPal();
	int sel(int);
	int replace(int);
	int operator[](int) const;
	private:
	const int size;
	void mark();
	int* pal;
	int* use;
};
static TPal recent_bg, recent_fg;

void do_bg_icon(int index)
{
	BITMAP* dest=(BITMAP*) main_dlg[2+index].dp;
	BITMAP* src=Level::current->tile_bm();
	int sx=16*(recent_bg[index]%16);
	int sy=16*(recent_bg[index]/16);
	clear(dest);
	blit(src, dest, sx, sy, 0, 3, 16, 10);
	SEND_MESSAGE(&main_dlg[2+index], MSG_DRAW, 0);
}
void create_fg_thumbnails()
{
	if (fg_thumbnails==0)
	{
		fg_thumbnails=Level::current->create_fg_img(0);
	}
}
void destroy_fg_thumbnails()
{
	if (fg_thumbnails)
	{
		destroy_bitmap(fg_thumbnails);
		fg_thumbnails=0;
	}
}

void do_fg_icon(int index)
{
	BITMAP* dest=(BITMAP*) main_dlg[2+index].dp;
	int sx=16*(recent_fg[index]%16);
	int sy=16*(recent_fg[index]/16);
	blit(fg_thumbnails, dest, sx, sy, 0, 0, 16, 16);
	SEND_MESSAGE(&main_dlg[2+index], MSG_DRAW, 0);
}
MList* pev;
#define BOOK_COUNT 8
static Bookmark *bookmarks=0;

int Level::edit()
{
	pev=&everything;
	did_ever_edit=0;
	active_pal=0;
	// wait until all keys released
	while (keypressed())
	{
		readkey();
	}
	
	//
	install_mouse();
	set_palette(PALETTE(find_data("WinPal")->dat));
	clear_to_color(screen,makecol(128,160,160));
	main_dlg[8].d1=bg_bitmap->w*16; 
	main_dlg[9].d1=bg_bitmap->h*10;
	main_dlg[9].d2=main_dlg[9].d1-1;
	for (int i=2; i<7; ++i)
	{
		BITMAP* q=create_bitmap(16,16);
		clear(q);
		main_dlg[i].dp=q;
	}
	// add bookmarks to the list
	if (bookmarks==0) bookmarks=new Bookmark[BOOK_COUNT];
	for (int i=0; i<BOOK_COUNT; ++i)
		everything.add(&bookmarks[i]);
		
	// select background mode
	active_menu=&edit_menu[1];
	m_proc_em();
	create_fg_thumbnails();
	// do yer actual editing
	do_dialog(main_dlg,-1);	
	// clean up
	destroy_fg_thumbnails();
	for (int i=2; i<7; ++i)
		destroy_bitmap((BITMAP*) main_dlg[i].dp);
	clear(screen);
	remove_mouse();
	// remove bookmarks
	for (int i=0; i<BOOK_COUNT; ++i)
		everything.remove(&bookmarks[i]);
	pev=0;
	return changed=did_ever_edit;
}
static int pal_proc(int msg, DIALOG* d, int c)
{
	int ans=(msg==MSG_DRAW) ? d_icon_proc(msg,d,c) : d_radio_proc(msg,d,c);
	if (d->flags&D_SELECTED)
	{
		active_pal=d-&main_dlg[2];
	}
	return ans;
}
static int get_mouse_pos(DIALOG* d)
{
	px=(gui_mouse_x()-d->x)*320/d->w;
	py=(gui_mouse_y()-d->y)*200/d->h;
	pb=gui_mouse_b();
	return (px>=0 && px<320 && py>=0 && py<200);
}
static int overlay_proc(int msg, DIALOG* d, int )
{
	Level& lev=*Level::current;
	switch(msg)
	{
		case MSG_WANTFOCUS:
			return D_WANTFOCUS;
		case MSG_CLICK:
			get_mouse_pos(d);
			return do_click(d) ? D_REDRAWME : D_O_K;
		case MSG_DRAW:
			lev.put_everything();
			lev.map().draw();
			stretch_blit(lev.map().surface(), screen,
				0, 0, 320, 200, d->x, d->y, d->w, d->h);
			break;
	}
	return D_O_K;
}
static int m_proc_em()
{
	if (bg_pointer==0)
	{
		bg_pointer=BitmapFromString(bg_pst);
		fg_pointer=BitmapFromString(fg_pst);
		ob_pointer=BitmapFromString(ob_pst);
	}
	edit_menu[0].flags=0;
	edit_menu[1].flags=0;
	edit_menu[2].flags=0;
	active_menu->flags=D_SELECTED;
	if (active_menu==&edit_menu[0]) 
	{
		// foreground
		ed_mode=EDMODE_FG;
		for (int i=0; i<5; ++i)
		{
			do_fg_icon(i);
		}
		set_mouse_sprite(fg_pointer);
		set_mouse_sprite_focus(3,3);
	}
	if (active_menu==&edit_menu[1]) 
	{
		// background
		ed_mode=EDMODE_BG;
		for (int i=0; i<5; ++i)
		{
			do_bg_icon(i);
		}
		set_mouse_sprite(bg_pointer);
		set_mouse_sprite_focus(3,3);
	}
	if (active_menu==&edit_menu[2]) 
	{
		ed_mode=EDMODE_OBJ;
		for (int i=2; i<7; ++i)
			clear((BITMAP*) main_dlg[i].dp);
		set_mouse_sprite(ob_pointer);
		set_mouse_sprite_focus(3,3);
	}
	return broadcast_dialog_message(MSG_DRAW,0);
};
static int ed_obj(DIALOG* d, int x, int y, int b)
{
	Map&m=Level::current->map();
	int xx=m.s2p_x(x);
	int yy=m.s2p_y(y);
	text_mode(0);
	textprintf(screen, smallfont, 160, 100, 255, "(%d,%d)", xx,yy);
	MovableObj* nearest=0;
	int dist=0;
	// find the nearest obj that is fairly near.
	for (int i=0; i<pev->count(); ++i)
	{
		MovableObj& o=*((*pev)[i]);
		int dx=o.get_x()-xx;
		int dy=o.get_y()-yy;
		if (dx>-10 && dy>-10 && dx<10 && dy<10)
		{
			int od=dx*dx+dy*dy;
			if ((nearest==0) || (od<dist))
			{
				nearest=&o;
				dist=od;
			}
		}
	}
	if (nearest==0)
	{
		//nothing near
		return 0;
	}
	if (b&2)
	{
		return nearest->edit();
	}
	else
	{
		// drag and drop
		do
		{
			if (get_mouse_pos(d)==0)
			{
				// dragged off screen
				return 0;
			}
			// yes it leaves trails...
			nearest->draw(screen, gui_mouse_x(), gui_mouse_y());
		} while (pb&1);
		nearest->move_to(m.s2p_x(px),m.s2p_y(py));
		return 1;
	}
}
static int do_click(DIALOG* d)
{
	Map&m=Level::current->map();
	int mx=m.s2m_x(px);
	int my=m.s2m_y(py);
	int v;
	int ch=0;
	switch(ed_mode)
	{
		case EDMODE_BG: // bg
			v=recent_bg.sel(active_pal);
			ch= Level::current->set_bg(mx, my, v);
			break;
		case EDMODE_FG: //fg
			if (pb&1)
			{
				v=recent_fg.sel(active_pal);
				ch= Level::current->set_fg(mx, my, v);
			}
			else
			{
				ch=Level::current->ed_fg(mx, my);
			}	
			break;
		case EDMODE_OBJ:
			ch=ed_obj(d, px,py,pb);
			break;
		default: 
		break;
	}
	did_ever_edit|=ch;
	return ch;
}
AObject* choose_object()
{
	if (pev)
	{
		int &index=gobj_dlg[2].d1;
		index=0;
		popup_dialog(gobj_dlg, -1);
		return (*pev)[index];
	}
	else
		return 0;
}

static int m_proc_hide()
{
	MovableObj* o=(MovableObj*) choose_object();
	o->move_to(-1, 0);
	return D_REDRAW; 
}
static int m_proc_bring()
{
	MovableObj* o=(MovableObj*) choose_object();
	int x=main_dlg[8].d2;
	int y=main_dlg[9].d1-main_dlg[9].d2-1;
	// move to roughly the middle
	o->move_to(x, y);
	return D_REDRAW; 
}
static int m_proc_gobj()
{
	MovableObj* o=(MovableObj*) choose_object();
	if (o->is_nowhere())
	{
		alert(o->name(), "Object is hidden", "Use 'Bring' to get it back", "OK", NULL, 0, 0);
		return D_O_K;
	}
	// set sliders
	int x=o->get_x();
	int y=o->get_y();
	main_dlg[8].d2=x;
	main_dlg[9].d2=main_dlg[9].d1-y-1;
	// This positions more accurately than 
	// .ensure_focus(o);
	Level::current->map().ensure_focus(x,y);
	return D_REDRAW; 
}
static int m_proc_end()
{
	if (active_menu==&level_menu[0])
	{
		// save and exit
	}
	else
	{
		if (did_ever_edit && 
			alert(Level::current->name(), "Exit without saving?", "", 
				"Yes", "No", 'Y', 'N')!=1)
		{
			return D_O_K;
		}
		else
		{	
			did_ever_edit=0;
			return D_CLOSE;
		}
	}
	return D_CLOSE;
}

static int d_ch_proc(int, DIALOG*, int);

DIALOG bg_more[]={
{d_ch_proc, 136, 100, 120, 100, 255, 0, 0, 0, 0, 0, NULL, NULL, NULL},
{NULL}
};
	
int d_more_proc(int msg, DIALOG* d, int c)
{
	int ans=d_button_proc(msg, d, c);
	int sel;
	if (d->flags & D_SELECTED)
	{
		d->flags &= (~D_SELECTED);
		switch (ed_mode)
		{
			case EDMODE_BG:
				bg_more[0].dp=Level::current->tile_bm();
				bg_more[0].d1=recent_bg[active_pal];
				popup_dialog(bg_more, -1);
				sel=recent_bg.replace(bg_more[0].d1);
				do_bg_icon(sel);
				SEND_MESSAGE(&main_dlg[2+sel], MSG_CLICK, 0);
			break;
			case EDMODE_FG:
				bg_more[0].dp=fg_thumbnails;
				bg_more[0].d1=recent_fg[active_pal];
				popup_dialog(bg_more, -1);
				sel=recent_fg.replace(bg_more[0].d1);
				do_fg_icon(sel);
				SEND_MESSAGE(&main_dlg[2+sel], MSG_CLICK, 0);
			break;
		}
	}
	return ans;
}

int d_ch_proc(int msg, DIALOG* d, int )
{
	BITMAP* b=(BITMAP*) d->dp;
	int old_sel, new_sel, sx, sy;
	int isx, isy;
	old_sel=d->d1;
	switch(msg)
	{
		case MSG_DRAW:
			sx=16*(old_sel%16);
			sy=16*(old_sel/16);
			isx=sx*d->w/256-8;
			isy=sy*d->h/256-8;
			if (isx<0) isx=0;
			if (isx>=(d->w-32)) isx=d->w-32;
			if (isy<0) isy=0;
			if (isy>=(d->h-32)) isy=d->h-32;
			isx+=d->x;
			isy+=d->y;
			scare_mouse();
			stretch_blit(b, screen, 0, 0, 256, 256, d->x, d->y, d->w, d->h);
			stretch_blit(b, screen, sx, sy, 16, 16, isx, isy, 32, 32);
			rect(screen, isx, isy, isx+31, isy+31, d->fg);
			unscare_mouse();
			break;
		case MSG_CLICK:
			sx=sy=-1;
			while(gui_mouse_b())
			{
				sx=(gui_mouse_x()-d->x)*16/d->w;
				sy=(gui_mouse_y()-d->y)*16/d->h;
				if (sx>=0 && sx<16 && sy>=0 && sy<16)
				{
					new_sel=sx+16*sy;
					if (new_sel!=old_sel)
					{
						d->d1=old_sel=new_sel;
						SEND_MESSAGE(d, MSG_DRAW,0);
					}
				}
				broadcast_dialog_message(MSG_IDLE,0);
			}
			if (sx>=0 && sx<16 && sy>=0 && sy<16)
				return D_CLOSE;
			break;
			
	}
	return D_O_K;
}

TPal::TPal(int s) : size(s)
{
	use=new int[size];
	pal=new int[size];
	for (int i=0; i<s; ++i)
	{
		use[i]=0;
		pal[i]=i;
	}
}
TPal::~TPal()
{
	delete[] use;
	delete[] pal;
}

void TPal::mark()
{
	for (int i=0; i<size; ++i)
		++use[i];
}
int TPal::sel(int index)
{
	if(index<0) index=0;
	if(index>=size) index=size-1;
	mark();
	use[index]=0;
	return pal[index];
}
int TPal::operator[](int index) const
{
	if(index<0) index=0;
	if(index>=size) index=size-1;
	return pal[index];
}
int TPal::replace(int newval)
{
	int lv=use[0];
	int li=0;
	mark();
	for (int i=0; i<size; ++i)
	{
		if (lv<use[i])
		{
			lv=use[li=i];
		}
		if (newval==pal[i])
		{
			use[i]=0;
			return i;
		}
	}
	pal[li]=newval;
	use[li]=0;
	return li;
}	
int slider_callback(void*, int)
{
	int x=main_dlg[8].d2;
	int y=main_dlg[9].d1-main_dlg[9].d2-1;
	Level::current->map().ensure_focus(x,y);
	return D_REDRAW;
}

int m_proc_goxy()
{
	popup_dialog(goxy_dlg, -1);
	int x=atoi(t_wx);
	int y=atoi(t_wy);
	main_dlg[8].d2=x;
	main_dlg[9].d2=main_dlg[9].d1-y-1;
	// This positions more accurately than 
	// .ensure_focus(o);
	Level::current->map().ensure_focus(x,y);

	return D_REDRAW;
}

static char* olist_func(int index, int* num)
{
	AList& l=*pev;
	if (index>=0)
	{
		return l[index]->name();
	}
	else
	{
		*num=l.count();
		return 0;
	}
}
#endif

