// items.h

#ifndef __ITEMS_H__
#define __ITEMS_H__
#include "aobject.h"
class BStream;

class StdItem: public MovableObj
{
	public:
	StdItem();
	int do_action(AAction, AParam, AParam);
	void persist(BStream&);
	protected:
	int aa_query_name(char*);
	virtual char* description();
	virtual char* properties();
};
class Key : public StdItem
{
	public:
	Key();
	char* name() {return "Key";}
	AAction* actions() {return a_list;}
	int do_action(AAction, AParam, AParam);
	protected:
	char* properties();
	private:
	static AAction a_list[];
};
class Biotran: public StdItem
{
	public:
	Biotran();
	char* name() {return "Bio Transducer";}
	AAction* actions() {return a_list;}
	int move();
	protected:
	char* description();
	private:
	int cm;
	RLE_SPRITE* imgs[3];
	static AAction a_list[];
};

class SmartCard : public StdItem
{
	public:
	SmartCard();
	char* name() {return "Smart card";}
	AAction* actions() {return a_list;}
	int do_action (AAction, AParam, AParam);
	private:
	static AAction a_list[];
};

class Casket: public StdItem
{
	public:
	Casket();
	char* name() {return "Casket";}
	AAction* actions() {return a_list;}
	int do_action(AAction, AParam, AParam);
	private:
	AObject* contents;
	static AAction a_list[];
};

class Spade: public StdItem
{
	public:
	Spade();
	char* name() {return "Spade";}
	AAction* actions() {return a_list;}
	int do_action(AAction, AParam, AParam);
	char* description();
	private:
	static AAction a_list[];
};
class Scanner: public StdItem
{
	public:
	Scanner();
	char* name() {return "Scanner";}
	AAction* actions() {return a_list;}
	int do_action(AAction, AParam, AParam);
	private:
	static AAction a_list[];
};
class Seed: public StdItem
{
	public:
	Seed();
	char* persistent_name() {return "Seed";}
	char* name();
	AAction* actions() {return a_list;}
	int do_action(AAction, AParam, AParam);
	int move();
	void persist(BStream&);
	private:
	RLE_SPRITE *g[6];
	int growth;
	int timer;
	const int grow_time;
	static AAction a_list[];
};
class Oilcan : public StdItem
{
	public:
	Oilcan();
	char* name() {return "Oilcan";}
	AAction* actions() {return a_list;}
	int do_action(AAction, AParam, AParam);
	protected:
	char* description();
	private:
	static AAction a_list[];
};
class Horn : public StdItem
{
	public:
	Horn();
	char* name() {return "Horn";}
	AAction* actions() {return a_list;}
	int do_action(AAction, AParam, AParam);
	protected:
	char* description();
	private:
	static AAction a_list[];
};
class FishingRod : public StdItem
{
	public:
	FishingRod();
	char* name() {return "Fishing rod";}
	AAction* actions() {return a_list;}
	int do_action(AAction, AParam, AParam);
	void persist(BStream&);
	protected:
	char* description();
	MovableObj* attach;
	private:
	static AAction a_list[];
};
class Plantpot: public StdItem
{
	public:
	Plantpot();
	char* name() {return "Plant pot";}
	AAction* actions() {return a_list;}
	int do_action(AAction, AParam, AParam);
	protected:
	char* description();
	private:
	int updown;
	static AAction a_list[];
};
class Magnet: public StdItem
{
	public:
	Magnet();
	char* name() {return "Magnet";}
	AAction* actions() {return a_list;}
	int do_action(AAction, AParam, AParam);
	protected:
	char* description();
	private:
	static AAction a_list[];
};
class Fish: public StdItem
{
	public:
	Fish();
	char* name() {return "Fish";}
	AAction* actions() {return a_list;}
	int do_action(AAction, AParam, AParam);
	protected:
	char* description();
	private:
	static AAction a_list[];
};

#endif

