// items.cc

#include <stdio.h>
#include <string.h>
#include "items.h"
#include "hbag.h"
#include "actions.h"
#include "bstrm.h"
#include "level.h"
extern RLE_SPRITE* rle(char*);

static int freddie=20;
StdItem::StdItem()
{
	move_to(freddie, freddie);
	freddie+=10;
}
void StdItem::persist(BStream& b)
{
	TRACE("Item %s: persistent %s\n", name(), b.reading() ? "read":"write");
	if (b.reading())
	{
		b>>x>>y;
	}
	else
	{
		b<<x<<y;
	}
}
Key::Key()
{
	img=rle("Key");
	x=y=100;
}

AAction Key::a_list[]={AA_GET, AA_PUT, AA_USE, AA_EXAMINE, AA_END_LIST};
/////////////////////////////////////////////////////
Seed::Seed() : grow_time(get_config_int("atlantis", "seed_grow", 1000))
{
	img=g[0]=rle("Seed");
	g[1]=rle("Plant0");
	g[2]=rle("Plant1");
	g[3]=rle("Plant2");
	g[4]=rle("Plant3");
	g[5]=rle("Plant4");
	growth=timer=0;
	x=y=100;
}
void Seed::persist(BStream& b)
{
	StdItem::persist(b);
	if (b.reading())
	{
		b>>growth>>timer;
		img=g[growth];
	}
	else
	{
		b<<growth<<timer;
	}
}

char* Seed::name()
{
	return (char*) ((growth==0) ? "Seed" : "Plant");
}

AAction Seed::a_list[]={AA_GET, AA_PUT, AA_EXAMINE, AA_PLANT, AA_END_LIST};
int Seed::do_action(AAction a, AParam p1, AParam p2)
{
	HBag& b=HBag::inst();
	switch(a)
	{
		case AA_EXAMINE:
			if (growth==0)
				b<<">Examine seed\nA small, round, shiny seed\n";
			else
				b<<">Examine plant\nA growing plant\n";
			return AA_MSG;
		case AA_PLANT:
			b<<">Plant seed\n";
			if (growth==0)
			{
				if (get_x()>0)
				{
					b<<"OK\n";
					growth=1;
					timer=grow_time;
					img=g[1];
				}
				else
					b<<"Drop it first!\n";
			}
			else
			{
				b<<"It's already growing\n";
			}
			return AA_MSG;
		case AA_GET:
			if (growth>0)
			{
				b<<">Get plant\nIt's put down some roots\n";
				return AA_MSG;
			}
			else
				return StdItem::do_action(a,p1,p2);
		default:
			return StdItem::do_action(a, p1, p2);
	}
}
int Seed::move()
{
	if (growth>0 && growth<5)
	{
		if (--timer<0)
		{
			img=g[++growth];
			timer=grow_time;
			return 1;
		}
	}
	return 0;
}
/////////////////////////////////////////////////////
Scanner::Scanner()
{
	img=rle("Scanner");
	x=y=100;
}

AAction Scanner::a_list[]={AA_GET, AA_PUT, AA_EXAMINE, AA_END_LIST};
int Scanner::do_action(AAction a, AParam p1, AParam p2)
{
	HBag& b=HBag::inst();
	switch(a)
	{
		case AA_EXAMINE:
			b<< ">Examine scanner\n"
			<<"It's used for locating something\n";
			return AA_MSG;
		default:
			return StdItem::do_action(a, p1, p2);
	}
}
Horn::Horn()
{
	img=rle("Horn");
	x=y=120;
}

AAction Horn::a_list[]={AA_GET, AA_PUT, AA_EXAMINE, AA_END_LIST};
int Horn::do_action(AAction a, AParam p1, AParam p2)
{
//	HBag& b=HBag::inst();
	switch(a)
	{
		default:
			return StdItem::do_action(a, p1, p2);
	}
}
char* Horn::description()
{
	return "It's a trumpet-shaped horn from an old gramophone";
}

FishingRod::FishingRod()
{
	img=rle("FishingRod");
	attach=0;
}

void FishingRod::persist(BStream& b)
{
	StdItem::persist(b);
	if (b.reading())	
	{
		if (b.version()>=1)
		{
			TRACE("%s ver 1", name());
			int vv;
			b>>vv;
			if (vv)
			{
				char n[64];
				b>>n;
				attach=(MovableObj*)Level::current->find_obj(n);
			}
			else
				attach=0;
		}
		else
			attach=0;
	}
	else
	{
		if (attach)
		{
			b<<1<<attach->persistent_name();
		}
		else
			b<<0;
	}
}
AAction FishingRod::a_list[]={AA_GET, AA_PUT, AA_EXAMINE, AA_ATTACH, AA_CAST, AA_END_LIST};
int FishingRod::do_action(AAction a, AParam p1, AParam p2)
{
	HBag& b=HBag::inst();
	switch(a)
	{
		case AA_CAST:
			if (is_nowhere()) 
			{
			//forward onto the owner (pyotr)
				return p1.obj->do_action(a, p1, p2);
			}
			else
			{
				b<<">cast rod\nPick it up, first!\n";
				return AA_MSG;
			}
		case AA_ATTACH:
		{
			// attach what?
			AObject* what=b.choose("Attach what?");
			if (what==0) return AA_NOTHING; // cancelled
			b<<">Attach "<<what->name()<<" to "<<this->name()<<"\n";
			// what kind of thing was it
			AParam ms; ms.msg="object?";
			if ((what==this) || (what->do_action(_AA_QUERY_NAME, ms)!=AA_YES))
			{
				// not a valid thing to attach
				b<<"You can't really attach the "<<what->name()<<"\n";
				return AA_MSG;
			}
			if (attach)
			{
				// drop what was attached
//				b<<"Dropping the "<<attach->name()<<"\n";
				attach->move_to(*(MovableObj*)p1.obj);
			}
			attach=(MovableObj*) what;
			attach->move_nowhere();
			b<<"OK\n";
			return AA_CHANGED_INV;
		}
		default:
			return StdItem::do_action(a, p1, p2);
	}
}
char* FishingRod::description()
{
	static char buf[256];
	if (attach)
	{
		sprintf(buf, "A rod with a %s attached", attach->name());
		return buf;
	}
	else
		return "A useless fishing rod";
}

Plantpot::Plantpot()
{
	img=rle("PlantPotUp");
	x=y=100;
	updown=1;
}

AAction Plantpot::a_list[]={AA_GET, AA_PUT, AA_EXAMINE, AA_END_LIST};
int Plantpot::do_action(AAction a, AParam p1, AParam p2)
{
//	HBag& b=HBag::inst();
	switch(a)
	{
		default:
			return StdItem::do_action(a, p1, p2);
	}
}
char* Plantpot::description()
{
	return "A heavy, terracotta plant pot";
}

Oilcan::Oilcan()
{
	img=rle("Oilcan");
	x=y=100;
}

AAction Oilcan::a_list[]={AA_GET, AA_PUT, AA_EXAMINE, AA_END_LIST};
int Oilcan::do_action(AAction a, AParam p1, AParam p2)
{
	//HBag& b=HBag::inst();
	switch(a)
	{
		default:
			return StdItem::do_action(a, p1, p2);
	}
}
char* Oilcan::description()
{
	return "It's a blue, metal can with oil in it\n";
}

Magnet::Magnet()
{
	img=rle("Magnet");
	x=y=100;
}

AAction Magnet::a_list[]={AA_GET, AA_PUT, AA_EXAMINE, AA_END_LIST};
int Magnet::do_action(AAction a, AParam p1, AParam p2)
{
	//HBag& b=HBag::inst();
	switch(a)
	{
		default:
			return StdItem::do_action(a, p1, p2);
	}
}
char* Magnet::description()
{
	return "A small horseshoe magnet";
}
Fish::Fish()
{
	img=rle("Fish");
	x=y=100;
}

AAction Fish::a_list[]={AA_GET, AA_PUT, AA_EXAMINE, AA_END_LIST};
int Fish::do_action(AAction a, AParam p1, AParam p2)
{
	//HBag& b=HBag::inst();
	switch(a)
	{
		default:
			return StdItem::do_action(a, p1, p2);
	}
}
char* Fish::description()
{
	return "It's a wet fish.";
}

Spade::Spade()
{
	img=rle("Spade");
	x=y=100;
}

AAction Spade::a_list[]={AA_GET, AA_PUT, AA_DIG, AA_EXAMINE, AA_END_LIST};
char* Spade::description()
{
	return "A well-used garden spade";
}
int Spade::do_action(AAction a, AParam p1, AParam p2)
{
	HBag& b=HBag::inst();
	switch(a)
	{
		case AA_DIG:
			b<<">Dig\nNothing happens\n";
			return AA_MSG;
		default:
			return StdItem::do_action(a, p1, p2);
	}
}

int StdItem::do_action(const AAction a, AParam p1, AParam)
{
	HBag& b=HBag::inst();
	switch(a)
	{
	case AA_EXAMINE:
		b << ">Examine "<< name() << "\n"
			<< description() << "\n";
		return AA_MSG;
	case AA_GET:
		{
		b << ">Get " << name() << "\n";
		AParam p2; p2.obj=this;
		return p1.obj->do_action(_AA_GETOBJ, p2);
		}
	case AA_PUT:
		{
		b<< ">Drop "<< name() << "\n";
		AParam p2; p2.obj=this;
		return p1.obj->do_action(_AA_DROPOBJ, p2);
		}
	case _AA_QUERY_NAME:
		return aa_query_name(p1.msg);
	default:
		return AA_NOTHING;
	}
}

int Key::do_action(AAction a, AParam p1, AParam p2)
{
	HBag& b=HBag::inst();
	switch(a)
	{
		case AA_EXAMINE:
			b<< ">Examine key\n"
			<<"A small, golden key, with a number '1' engraved upon it.\n";
			return AA_MSG;
		case AA_USE:
			b<<"Use key\nNothing to use on\n";
			return AA_MSG;
		default:
			return StdItem::do_action(a, p1, p2);
	}
}
char* Key::properties()
{
	return "gold-key?\0";
}
SmartCard::SmartCard()
{
	img=rle("SmartCard");
	x=y=100;
}

AAction SmartCard::a_list[]={AA_GET, AA_PUT, AA_INSERT, 
	AA_EXAMINE, AA_END_LIST};

int SmartCard::do_action(AAction a, AParam p1, AParam p2)
{
	HBag& b=HBag::inst();
	switch(a)
	{
		case AA_EXAMINE:
			b<<"Examine smart card\n"
			<< "A plastic card, with a small, built-in memory chip.\n";
			return AA_MSG;
		case AA_INSERT:
			b<< ">Insert smart card\nNothing to insert it into\n";
			return AA_MSG;
		default:
			return StdItem::do_action(a, p1, p2);
	}
}


Casket::Casket()
{
	img=rle("Casket");
	x=y=100; 
	contents=0;
}

AAction Casket::a_list[]={AA_GET, AA_PUT, AA_EXAMINE, AA_SMASH, AA_END_LIST};
int Casket::do_action(AAction a, AParam p1, AParam p2)
{
	HBag& b=HBag::inst();
	switch(a)
	{
		case AA_EXAMINE:
			b << ">Examine casket\nIt's a small, locked box. ";
			if (contents)
				b<< "There's something inside!\n";
			else
				b<<"\n";
			return AA_MSG;
		case AA_UNLOCK:
		{
			AObject* m=b.choose("Unlock with...");
			if (m)
			{
				b<< ">Unlock casket with "<<m->name() 
					<< "\nIt doesn't fit\n";
				return AA_MSG;
			}
			else
				return AA_NOTHING;
		}
		case AA_SMASH: 
			b << ">Smash casket\nYou're not strong enough.\n";
			return AA_MSG;
		case _AA_GETOBJ:
			if (contents)
			{
				return AA_NOT_OK;
			}
			else
			{
				contents=p1.obj;
				return AA_OK;			
			}
		default:
			return StdItem::do_action(a, p1, p2);
	}
}

char* StdItem::properties()
{
	return "";
}
int StdItem::aa_query_name(char* n)
{
	char *t=properties();
	while(*t!='\0')
	{
		if (strcmp(t,n)==0)
			return AA_YES;
		while(*t++ !='\0')
		{ }
	}
	if (strcmp(n, "object?")==0)
		return AA_YES;
	if (strcmp(n, name())==0)
		return AA_YES;
	return AA_NO;
}
char* StdItem::description()
{
	return "Nothing much to see";
}

Biotran::Biotran()
{
	img=imgs[0]=rle("Biotran1");
	imgs[1]=rle("Biotran2");
	imgs[2]=rle("Biotran3");
	cm=1;
};

int Biotran::move()
{
	cm=(1+cm)%3;
	img=imgs[cm];
	return 1;
}
	
char* Biotran::description()
{
	return "Here is the missing Bio-transducer";
}

AAction Biotran::a_list[]={AA_GET, AA_PUT, AA_EXAMINE, AA_END_LIST};

