#ifndef __INPUT_H__
#define __INPUT_H__

class InputMethod
{
	public:
	virtual void poll()=0;
	virtual void install()=0;
	enum {Left=1, Right=2, Up=4, Down=8, Fire=16, Alt=32, Esc=64};
	int value() const {return v;}
	int l() const {return v & Left;}
	int r() const {return v & Right;}
	int u() const {return v & Up;}
	int d() const {return v & Down;}
	int f() const {return v & Fire;}
	int e() const {return v & Esc;}
	int a() const {return v & Alt;}
	int wait();
	void release() {do {poll();} while(v);}
	protected:
	int v;
};
void selectKeyboard();
void selectJoystick();
extern InputMethod* Control;

#endif
