#include <allegro.h>
#include "input.h"
InputMethod* Control=0;

class Keyboard : public InputMethod
{
	public:
	Keyboard() : inst(0) {}
	void poll();
	void install();
	private:
	int inst;
} kk;
class Joystick : public InputMethod
{
	public:
	Joystick() : inst(0) {}
	void poll();
	void install();
	private:
	int inst;
} jj;

void selectJoystick()
{
	Control=&jj;
	jj.install();
}
void selectKeyboard()
{
	Control=&kk;
	kk.install();
}
int InputMethod::wait()
{
	do
	{
		rest(10);
		poll();
	} while (v==0);
	int tmp=v;
	do
	{
		rest(10);
		poll();
	} while (v!=0);
	return v=tmp;
}
void Keyboard::poll() 
{
	v=0;
	if (key[KEY_LEFT]) v|=Left;
	if (key[KEY_RIGHT]) v|=Right;
	if (key[KEY_UP]) v|=Up;
	if (key[KEY_DOWN]) v|=Down;
	if (key[KEY_LCONTROL]) v|=Fire;
	if (key[KEY_ALT]) v|=Alt ;
	if (key[KEY_ESC]) v|=Esc;
}

void Keyboard::install()
{
	if (!inst)
		install_keyboard();
	inst=1;
	
}

void Joystick::poll() 
{
	v=0;
	poll_joystick();
	poll_joystick(); // grrr
	if (joy[0].stick[0].axis[0].d1) v|=Left;
	if (joy[0].stick[0].axis[0].d2) v|=Right;
	if (joy[0].stick[0].axis[1].d1) v|=Up;
	if (joy[0].stick[0].axis[1].d2) v|=Down;
	if (joy[0].button[0].b) v|=Fire;
	if (joy[0].button[1].b) v|=Alt ;
	if (key[KEY_ESC]) v|=Esc;
}

void Joystick::install()
{
	if (!inst)
	{
		install_keyboard();
		install_joystick(JOY_TYPE_AUTODETECT);
		inst=1;
	}
}

