// hbag.h

#ifndef __HBAG_H__
#define __HBAG_H__
#include "aobject.h"
#include "choose.h"
class Map;
class BITMAP;
class MovableObj;
class MovingObj;

class Popup
{
	public:
	Popup(int w, int h);
	~Popup();
	void save_bg(BITMAP*);
	void restore_bg(BITMAP*);
	BITMAP* surface() {return surf;}
	private:
	const int w;
	const int h;
	int x,y;
	BITMAP* store;
	BITMAP* surf;
};
class Term
{
	public:
	Term(int x, int y, int w, int h);
	Term();
	~Term();
	void set_size(int x, int y, int w, int h);
	void update(BITMAP*);
	void addString(const char*);
	int set_colour(int fg, int bg);
	void cls();
	private:
	void finish_line();
	int x0, y0, h, w;
	char* buffer;
	BITMAP* backing;
	int cw, ch;
	int fg_clr, bg_clr;
};
enum ChooseFromTypes
// which objects the user can select from
{
	CF_Acc, // accessible items (inventory and 'here')
	CF_Ever, // anything that's ever appeared in the LHS of an HBag
	CF_All, // all objects in this level (prob. not use this much)
	CF_AccAll // as CF_Acc but all types
};

class HBag : protected Popup
{
	public:
	HBag(MovingObj&);
	~HBag();
	static HBag& inst() {return *the_bag;}
	// Show the HBag, list of objects and actions etc
	// Call in response to user pressing 'alt'
	int show();
	// find the most likely object and do its default action
	// call in response to user pressing 'fire'
	int do_default();
	// These functions to be used by object actions
	HBag& operator<<(const char*);
	HBag& operator<<(int);
	AObject& who() const {return p;}
	AObject* choose(const char* prompt, ChooseFromTypes = CF_Acc);
	//
	private:
	static HBag* the_bag;
	AObject* c_obj();
	// Search map for stuff.
	int search();
	Term term;
	Chooser* lhs;
	HChooser* rhs;
	void draw_frame();
	void build_verbs(AObject* o, int pos_type);
	void unbuild_verbs();
	int pan_y, item_h, item_c, pan_h;
	int draw_verb(int);
	int move_verb(int);
	MovingObj& p;
	AList here;
	AList& carried;
	AObject* held;
};

#endif
