// hbag.cc
#include <allegro.h>
#include <string.h>
#include "aobject.h"
#include "map.h"
#include "hbag.h"
#include "input.h"
#include "actions.h"
#include "level.h"

#define BOX_W 310
#define BOX_H 160
struct NamedAction
{
	AAction id;
	char* msg;
};

class AOItem : public Choice
{
	public:
	AOItem(AObject*);
	void draw(BITMAP*, int, int);
	int can_select() {return 1;}
	AObject* obj() {return o;}
	private:
	AObject* o;
};
class AAItem : public Choice
{
	public:
	AAItem(AAction);
	void draw(BITMAP*, int, int);
	int can_select() {return 1;}
	AAction action() {return o.id;}
	private:
	NamedAction o;
};
	
extern FONT* smallfont;

Term& operator<<(Term& t, char* s)
{
	t.addString(s);
	return t;
}
Term& operator<<(Term& t, int i)
{
	static char buf[33];
	t.addString(itoa(i,buf,10));
	return t;
}

static int al_trace_hand(const char* msg)
{
	HBag& b=HBag::inst();
	if (&b)
		b << "!" << msg;
	return 0;
}

HBag::HBag(MovingObj& mo) : Popup(BOX_W, BOX_H), 
	p(mo), carried((AList&) mo.inventory())
{
	held=0;
	const int fh=text_height(font);
	// Set something about the sizes
	pan_y=fh+4;
	item_h=fh;
	pan_h=BOX_H-pan_y;
	item_c=pan_h/item_h;
	lhs=rhs=0;
	term.set_size(BOX_W/3+2, pan_y, BOX_W*2/3-4, pan_h-item_h);
	the_bag=this;
#ifdef DEBUGMODE
	static int dh=1;
	if (dh)
	{
//		register_trace_handler(al_trace_hand);
		dh=0;
	}
#endif
}
HBag* HBag::the_bag=0;
void empty(Chooser& q)
{
	for (int i=0; i<q.count(); ++i)
		delete& q[i];
	q.remove_all();
}
void empty(HChooser& q)
{
	for (int i=0; i<q.count(); ++i)
		delete& q[i];
	q.remove_all();
}
class ASet: public AList 
{
	public:
	ASet() {}
	void add(AObject* o);
	void add(const AList&);
} did_ever_meet;
	
HBag::~HBag()
{
	if (lhs) 
	{
		empty(*lhs);
		delete lhs;
	}
	if (rhs) 
	{
		empty (*rhs);
		delete rhs;
	}
	did_ever_meet.clear();
}
HBag& HBag::operator<<(const char* s)
{
	term.addString(s);
	return *this;
}
HBag& HBag::operator<<(int i)
{
	static char buf[33];
	term.addString(itoa(i,buf,10));
	return *this;
}

AObject* HBag::choose(const char* p, ChooseFromTypes cf)
{
	Popup pp(150,100);
	pp.save_bg(screen);
	Chooser chi(pp.surface());
	chi.add(*new StaticTextItem((char*)p));
	switch(cf)
	{
		case CF_Acc:
			for (int i=0; i<here.count(); ++i)
	 			chi.add(*new AOItem(here[i]));
			for (int i=0; i<carried.count(); ++i)
			 	chi.add(*new AOItem(carried[i])); 
			break;
		case CF_Ever:
			for (int i=0; i<did_ever_meet.count(); ++i)
		 		chi.add(*new AOItem(did_ever_meet[i]));
	 		break;
		case CF_All:
		{
			MList& Everything=Level::current->everything;
			for (int i=0; i<Everything.count(); ++i)
				chi.add(*new AOItem(Everything[i]));
		}
			break;
		case CF_AccAll:
		{
			MList& Everything=Level::current->everything;
			AParam isitem;
			isitem.msg="item?";
			for (int i=0; i<Everything.count(); ++i)
			{
				AObject* o=Everything[i];
				if (o->do_action(_AA_QUERY_NAME,isitem)==AA_YES)
					chi.add(*new AOItem(o));
			}
		}
			break;
	}
	 	
	AObject* ans;
	if (chi.choose()!=-1)
	{
		ans=((AOItem&) chi.current()).obj();
	}
	else
	{
		ans=0;
	}
	pp.restore_bg(screen);
	for (int i=0; i<chi.count(); ++i)
	{
		delete& chi[i];
	}
	return ans;
}

int HBag::show()
{
	save_bg(screen);
	draw_frame();
	Control->release();
	search();
	term.update(surface());
	int go=1;
	lhs->process(0);
	build_verbs(c_obj(), 0);
	rhs->process(0);
	AObject* old=0;
	while (go)
	{
		Control->poll();
		if (old!=c_obj())
		{
			old=c_obj();
			unbuild_verbs();
			build_verbs(old,0);
			rhs->process(0);
		}
		if (Control->u())
		{
			lhs->process(-1);
		}
		if (Control->d())
		{
			lhs->process(1);
		}
		if (Control->l())
		{	
			rhs->process(-1);
		}
		if (Control->r())
		{
			rhs->process(1);
		}
		if (Control->a()||Control->e())
		{
			Control->release();
			go=0;
		}
		if (Control->f())
		{
			AParam p1;
			p1.obj=&p;
			AAction a=((AAItem&) rhs->current()).action();
			int ret=c_obj()->do_action(a, p1);
			if (ret==AA_CHANGED_INV)
			{
				search();
				lhs->process(0);
				build_verbs(c_obj(), 0);
				rhs->process(0);
			}
			term.update(surface());
			Control->release();
		}
	}
	restore_bg(screen);
	return 0;
}
AObject* HBag::c_obj()
{
	Choice& c=lhs->current();
	return c.can_select() ? ((AOItem&) c).obj() : 0;
}

void HBag::build_verbs(AObject* o, int)
{
	if (o==0)
	{
		return;
	}
	AAction* c_verbs=o->actions();
	if (c_verbs)
	{
		for (int vc=0; c_verbs[vc]!=AA_END_LIST; ++vc)
		{
			rhs->add(*new AAItem(c_verbs[vc]));
		}
	}
}
void HBag::unbuild_verbs()
{
	empty(*rhs);
}

int HBag::search()
{
	AObject* ee[9];
	Map& m=p.mymap();
	MList& a=Level::current->everything;
	m.get_surround(p.get_x(), p.get_y(), ee);
	here.clear();
	if (lhs==0) 
	{
		lhs=new Chooser(surface(), 1, pan_y, BOX_W/3-5, pan_h);
		rhs=new HChooser(surface(), 2+BOX_W/3, BOX_H-item_h, 
			BOX_W*2/3-5, item_h);
		TRACE("Create rhs at %d,%d %dx%d\n", 2+BOX_W/2, BOX_H-item_h, 
			BOX_W/2-5, item_h);
	}
	else
	{	
		empty(*lhs);
		empty(*rhs);
	}
	lhs->add(*new StaticTextItem("Here:"));
	for (int i=0; i<9; ++i)
	{
		if (ee[i]->actions()!=0)
			here.add(ee[i]);
	}
	for (int i=0; i<a.count(); ++i)
	{
		if (p.near(*a[i]))
		{
			here.add(a[i]);
		}
	}
	for (int i=0; i<here.count(); ++i)
	{
		lhs->add(*new AOItem(here[i]));
	}
	lhs->add(*new StaticTextItem("Carried:"));
	for (int i=0; i<carried.count(); ++i)
		lhs->add(*new AOItem(carried[i]));
	did_ever_meet.add(here);
	did_ever_meet.add(carried);
	return lhs->count();
}

void HBag::draw_frame()
{
	BITMAP* s=surface();
	const int fh=text_height(font);
//	const int ltgrey=makecol(192,192,192);
	const int white=makecol(255,255,255);
	const int dkgrey=makecol(128,128,128);
	const int blue=makecol(0, 0, 255);
	text_mode(-1);
	textout_centre(s, font, "ATLANTIS", BOX_W/2, 1, blue);
	hline(s, 0, fh+1, BOX_W, white);
	hline(s, 0, fh+3, BOX_W, dkgrey);
	vline(s, BOX_W/2-1, fh+3, BOX_H, white);
	vline(s, BOX_W/2+1, fh+3, BOX_H, dkgrey);
}

Popup::Popup(int nw, int nh) : w(nw), h(nh)
{
	store=0;
}

void Popup::save_bg(BITMAP* s)
{
	if (store==0)
	{
		store=create_bitmap(w+2, h+2);
		x=160-w/2;
		y=100-h/2;
		surf=create_sub_bitmap(s, x+1, y+1, w, h);
	}
	blit(s, store, x, y, 0, 0, w+2, h+2);
	rectfill(s, x, y, x+w, y+h, makecol(192, 192, 192));
	rect(s, x, y, x+1+w, y+1+h, makecol(255,255,255));
}

void Popup::restore_bg(BITMAP* s)
{
	blit(store, s, 0, 0, x, y, w+2, h+2);
}
Popup::~Popup()
{
	if (store)
	{
		destroy_bitmap(store);
		destroy_bitmap(surf);
	}
}

Term::Term(int x, int y, int wid, int hgt)
{
	set_size(x, y, wid, hgt);
}

Term::Term()
{
	buffer=0;
	backing=0;
}

void Term::set_size(int x, int y, int wid, int hgt)
{
	x0=x;
	y0=y;
	w=wid;
	h=hgt;
	ch=text_height(smallfont);
	cw=wid/text_length(smallfont, "!")+1;
	buffer=new char[cw];
	backing=create_bitmap(w, h);
	fg_clr=makecol(0 ,255,0);
	bg_clr=makecol(0, 0, 0);
	clear_to_color(backing, bg_clr);
	buffer[0]='\0';
}

Term::~Term()
{
	if (buffer) delete[] buffer;
	if (backing) destroy_bitmap(backing);
}

void Term::update(BITMAP* s)
{
	if (backing)
		blit(backing, s, 0,0, x0, y0, w, h);
}
void Term::addString(const char*s)
{
	char c;
	while ((c=*s++)!=0)
	{
		if (c=='\n')
		{
			finish_line();
		}
		else
		{
			static char m[]="0";
			m[0]=c;
			if (text_length(smallfont, m)+text_length(smallfont, buffer)>=w)
				finish_line();
			strcat(buffer, m);
		}
	}
}
void Term::finish_line()
{
	if (buffer && backing)
	{
		int clr;
		switch(buffer[0])
		{
			case '>':
				clr=makecol(0,0xff,0);
				break;
			case '!':
				clr=makecol(0x00, 0xff,0xff); 
				break;
			default: 
				clr=makecol(0,0xc0,0);
				break;
		}
		blit(backing, backing, 0, ch, 0, 0, w, h);
		rectfill(backing, 0, h-ch, w, h, bg_clr);
		textout(backing, smallfont, buffer, 0, h-ch, clr);
		buffer[0]='\0';
	}
}
void Term::cls()
{
	if (buffer && backing)
	{
		buffer[0]='\0';
		clear_to_color(backing, bg_clr);
	}
}

int Term::set_colour(int f, int b)
{
	fg_clr=f;
	bg_clr=b;
	return 0;
}

AOItem::AOItem(AObject* a) : Choice(0)
{
	o=a;
	h=text_height(font);
}

void AOItem::draw(BITMAP* s, int x, int y)
{
	const char* n=o ? o->name() : "???";
	textout(s, font, n, x, y, makecol(0,0,0));
}

AAItem::AAItem(AAction z) : Choice(int(z))
{
	o.id=z;
	o.msg=action_name(z);
	h=text_height(font);
}

void AAItem::draw(BITMAP* s, int x, int y)
{
	textout(s, font, o.msg, x, y, makecol(0,0,0));
}

void ASet::add(AObject* o)
{
	for (int i=0; i<count(); ++i)
	{
		if ((*this)[i]==o)
			return;
	}
	AList::add(o);
}

void ASet::add(const AList& a)
{
	for (int i=0; i<a.count(); ++i)
	{
		add(a[i]);
	}
}

