// Gemini.cc
#include <string.h>
#include "gemini.h"
#include "cast.h"
#include "actions.h"
#include "bstrm.h"
#include "items.h"
#include "precursr.h"


Gemini::Gemini() 
{

}

Gemini::~Gemini()
{

}
int Gemini::common_prep()
{
	TRACE("Common Prep\n");
	load_data(datafile_name());
	BIStream in((char*) find_data("TileData")->dat);
	// Create the palette
	while(1)
	{
		int index;
		char tile_type[64];
		in>>index;
		if (index>=0 && index<256)
		{	
			in >> tile_type;
			Precursor* p=Precursor::get(tile_type);
			if (p)
			{
				tcache[index]=p;
				p->persist(in);
			}
		}
		else
			break;
	}
	// Create cast+objects
	player=new Pyotr(m);
	everything.add(player);
	// Create all objects
	everything.add(new Septimus(m));
	everything.add(new Mummy(m));
	everything.add(new Rebecca(m));
	everything.add(new Granville(m));
	everything.add(new Jack(m));
	everything.add(new ProgBot(m));
	everything.add(new Sallis(m));
	everything.add(new Key);
	everything.add(new Casket);
	everything.add(new SmartCard);
	everything.add(new Scanner);
	everything.add(new Spade);
	everything.add(new Seed);
	everything.add(new Plantpot);
	everything.add(new Magnet);
	everything.add(new FishingRod);
	everything.add(new Oilcan);
	everything.add(new Biotran);
	everything.add(new Fish);
	everything.add(new Horn);
	return 0;
}

int Gemini::prepare()
{
	common_prep();
	TRACE("Prepare\n");
	// do init
	create_fg_map((BITMAP*) find_data("Map")->dat);
	BIStream inp((char*) find_data("ObjData")->dat);
	persist(inp);
	// Set up background layer
	BITMAP* mp=(BITMAP*) find_data("BackMap")->dat;
	create_bg_map(mp);
	tile_bitmap=(BITMAP*) find_data("BackTiles")->dat;
	if (get_config_int("Atlantis", "back_layer", 1))
	{
		m.set_background(mp, tile_bitmap);
	}
	return 0;
}

#ifdef HAS_EDITOR
#include "bfstrm.h"
static char b_map[]="gemini/bckmap.bmp";
static char b_tiles[]="gemini/bcklyr.bmp";
static char o_data[]="gemini/objdat.bin";
static char f_map[]="gemini/map.bmp";

int Gemini::prepare_from_file()
{
	common_prep();
	TRACE("Prepare from file\n");
	create_fg_map(load_bitmap(f_map,fmp));
	create_bg_map(load_bitmap(b_map,mpp));
	tile_bitmap=load_bitmap(b_tiles,tlp);
	m.set_background(bg_bitmap, tile_bitmap);
	// read an uncompressed file
	BIFStream b(o_data, false);
	persist(b);
	changed=0;
	return 0;
}

int Gemini::save_edits()
{
	if (changed)
	{
		save_bitmap(b_map, bg_bitmap, mpp);
		save_bitmap(b_tiles, tile_bitmap, tlp);
		save_bitmap(f_map, fg_bitmap, fmp);
		// not sure about this - you wont't be able
		// to repeatedly call edit/save_edits without 
		// calling prepare_from_file
		destroy_bitmap(fg_bitmap);
		destroy_bitmap(bg_bitmap);
		destroy_bitmap(tile_bitmap);
		// write out to an uncompressed file
		BOFStream b(o_data, false);
		persist(b);
		changed=0;
		return 1;
	}
	else
		return 0;
}
#endif

