// Gemini.cc
#include <string.h>
#include "gemini.h"
#include "cast.h"
#include "actions.h"
#include "bstrm.h"
#include "items.h"
#include "precursr.h"


Gemini::Gemini() 
{

}

Gemini::~Gemini()
{

}
int Gemini::common_prep()
{
	load_data("gemini.dat");
	BIStream in((char*) find_data("TileData")->dat);
	// Create the palette
	while(1)
	{
		int index;
		char tile_type[64];
		in>>index;
		if (index>=0 && index<256)
		{	
			in >> tile_type;
			Precursor* p=Precursor::get(tile_type);
			if (p)
			{
				tcache[index]=p;
				p->persist(in);
			}
		}
		else
			break;
	}
	// Create cast+objects
	player=new Pyotr(m);
	everything.add(player);
	// Create all objects
	everything.add(new Septimus(m));
	everything.add(new Mummy(m));
	everything.add(new Rebecca(m));
	everything.add(new Granville(m));
	everything.add(new Jack(m));
	everything.add(new ProgBot(m));
	everything.add(new Sallis(m));
	everything.add(new Key);
	everything.add(new Casket);
	everything.add(new SmartCard);
	everything.add(new Scanner);
	everything.add(new Spade);
	everything.add(new Seed);
	everything.add(new Plantpot);
	everything.add(new Magnet);
	everything.add(new FishingRod);
	everything.add(new Oilcan);
	everything.add(new Biotran);
	everything.add(new Fish);
	return 0;
}

int Gemini::prepare()
{
	common_prep();
	// do init
	create_fg_map((BITMAP*) find_data("Map")->dat);
	BIStream inp((char*) find_data("ObjData")->dat);
	char dummy[64];
	// read in the level name which is always 'gemini'
	inp>>dummy;
	persist(inp);
	// Set up background layer
	BITMAP* mp=(BITMAP*) find_data("BackMap")->dat;
	create_bg_map(mp);
	tile_bitmap=(BITMAP*) find_data("BackTiles")->dat;
	if (get_config_int("Atlantis", "back_layer", 1))
	{
		m.set_background(mp, tile_bitmap);
	}
	return 0;
}

#ifdef HAS_EDITOR
#include "bfstrm.h"
char b_map[]="g_bckmap.bmp";
char b_tiles[]="g_bcklyr.bmp";
char o_data[]="g_objdat.bin";
char f_map[]="gemini.bmp";

int Gemini::prepare_from_file()
{
	common_prep();
	create_fg_map(load_bitmap(f_map,fmp));
	create_bg_map(load_bitmap(b_map,mpp));
	tile_bitmap=load_bitmap(b_tiles,tlp);
	m.set_background(bg_bitmap, tile_bitmap);
	BIFStream b(o_data);
	char dummy[64];
	// read in the level name which is always 'gemini'
	b>>dummy;
	persist(b);
	changed=0;
	return 0;
}

int Gemini::save_edits()
{
	if (changed)
	{
		save_bitmap(b_map, bg_bitmap, mpp);
		save_bitmap(b_tiles, tile_bitmap, tlp);
		save_bitmap(f_map, fg_bitmap, fmp);
		// not sure about this - you wont't be able
		// to repeatedly call edit/save_edits without 
		// calling prepare_from_file
		destroy_bitmap(fg_bitmap);
		destroy_bitmap(bg_bitmap);
		destroy_bitmap(tile_bitmap);
		BOFStream b(o_data);
		persist(b);
		changed=0;
		return 1;
	}
	else
		return 0;
}
#endif

