// game_opt.cc
#include <allegro.h>
#include "atlantis.h"
#include "choose.h"
#include "input.h"

#ifdef HAS_EDITOR
Options game_options()
{
	TRACE("Options\n");
	switch(SimpleChoose("Atlantis", "Play\0Restore\0Edit\0Test\0Story\0Configure\0Exit\0"))
	{
		case 0:
			return OptionPlay;
		case 1:
			return OptionRestore;
		case 2:
			return OptionEdit;
		case 3:
			return OptionTest;
		case 4:
			return OptionStory;
		case 5:
			return OptionConfig;
		default:
			return OptionExit;
	}
}
Options ingame_options()
{
	switch(SimpleChoose("Game", "Continue\0Save\0Tweak\0.Help\0End\0"))
	{
		case 0:
			return OptionPlay;
		case 1:
			return OptionSave;
		case 2:
			return OptionEdit;
		default:
			return OptionExit;
	}
}
#else
Options game_options()
{
	switch(SimpleChoose("Atlantis", "Play\0Restore\0Story\0Configure\0Exit\0"))
	{
		case 0:
			return OptionPlay;
		case 1:
			return OptionRestore;
		case 2:
			return OptionStory;
		case 3:
			return OptionConfig;
		default:
			return OptionExit;
	}
}
Options ingame_options()
{
	switch(SimpleChoose("Game", "Continue\0Save\0.Help\0End\0"))
	{
		case 0:
			return OptionPlay;
		case 1:
			return OptionSave;
		default:
			return OptionExit;
	}
}

#endif
	

Options config_options()
{
	switch(SimpleChoose("Config", "Joystick\0Keyboard\0Cancel\0"))
	{
		case 0:
			selectJoystick();
			break;
		case 1:
			selectKeyboard();
			break;
		default:
			return OptionExit;
	}
	return OptionPlay;
}

			
