#ifndef __FIXTURES_H__
#define __FIXTURES_H__

class Sign: public StaticObj
{
	public:
	Sign();
	AAction* actions() {return a_list;}
	int do_action(AAction, AParam, AParam);
	char* name() {return "Sign";}
	DECL_EDIT
	private:
	static AAction a_list[];
};

class Door: public AObject
{
	public:
	Door(int = northsouth);
	AAction* actions();
	int do_action(AAction, AParam, AParam);
	int opaque();
	void persist(BStream&);
	char* name() {return "Door";}
	void dispose() {delete this;}
	DECL_EDIT
	enum DoorState {closed=0x2, locked=0x4, 
		lockable=0x100, eastwest=0x200, northsouth=0x400};
	protected:
	int state;
	int is_closed() const {return state&closed;}
	int is_locked() const {return state&locked;}
	int can_lock() const {return state&lockable;}
	int set_state(int);
	int add_state(int x) {return set_state(state|x);}
	int remove_state(int x) {return set_state(state & (~x));}
	int flip_state(int x) {return set_state(state^x);}
	AObject* key;
	RLE_SPRITE* iopen, *iclosed;
	private:
	static AAction a_list[];
};
class LockingDoor: public Door
{
	public:
	LockingDoor(int =northsouth);
	AAction* actions() {return a_list;}
	int do_action(AAction, AParam, AParam);
	protected:
	virtual char* keyname() const {return "gold-key?";}
	private:
	int is_key(AObject*);
	static AAction a_list[];
};
class Gramophone: public StaticObj
{
	public:
	Gramophone();
	AAction* actions() {return a_list;}
	int do_action(AAction, AParam, AParam);
	char* name() {return "Gramophone";}
	void persist(BStream&);
	private:
	int has_horn;
	RLE_SPRITE* with, *without;
	static AAction a_list[];
};
	
class Well: public StaticObj
{
	public:
	Well();
	AAction* actions() {return a_list;}
	int do_action(AAction, AParam, AParam);
	char* name() {return "Well";}
	private:
	static AAction a_list[];
};
class Warp: public BackgroundObj
{
	public:
	Warp();
	int do_action(AAction, AParam, AParam);
	char* name() {return "Warp";}
	void dispose() {delete this;}
	DECL_EDIT
	void persist(BStream&);
	private:
	int wx, wy;
};
class ZoneMarker: public BackgroundObj
{
	public:
	ZoneMarker();
	int do_action(AAction, AParam, AParam);
	char* name() {return "ZoneMarker";}
	void dispose() {delete this;}
	DECL_EDIT
	void persist(BStream&);
	private:
	int shown;
	char message[40];
};
#endif
