// fixtures.cc
#include <allegro.h>
#include "hbag.h"
#include "actions.h"
#include "bstrm.h"
#include "fixtures.h"
#include "pager.h"
#include "level.h"
extern Pager pager;

extern RLE_SPRITE* rle(char*);

Sign::Sign() : StaticObj(0)
{ 
	img=rle("Sign_R");
}
#ifdef HAS_EDITOR
int Sign::edit()
{	
	alert(name(), "Please don't", "do this again", "OK", NULL, 0, 0);
	return 0;
}
#endif
int Sign::do_action(AAction a, AParam , AParam )
{
	HBag& b=HBag::inst();
	switch(a)
	{
		case AA_EXAMINE:
			b<<">Examine sign\nIt says \"Welcome to Atlantis\"\n";
			return AA_MSG;
		default:
			return AA_NOTHING;
	}
}
AAction Sign::a_list[]={AA_EXAMINE, AA_END_LIST};

Door::Door(int s)
{
	key=0;
	iopen=rle("Door_Open");
	iclosed=rle("Door_Closed");
	set_state(s);
}

void Door::persist(BStream& b)
{
	if (b.reading())
	{
		int q;
		char kn[30];
		b>>q>>kn;
		set_state(q);
		key=Level::current->find_obj(kn);
	}
	else
	{
		b<<state<<(key ? key->name() : "(no key)");
	}
}
		
#ifdef HAS_EDITOR
AObject* choose_object();

int d_choosekey_proc(int, DIALOG*, int);
static char c_key_name[32];
static AObject* c_key=0;
static DIALOG door_dlg[]={
	{d_box_proc, 80, 80, 160, 80, 255, 0, 0, 0, 0, 0, NULL, NULL, NULL},
	{d_button_proc, 110, 140, 40, 20, 255, 0, 0, D_EXIT, 0, 0, (void*)"OK", NULL, NULL},
	{d_ctext_proc, 130,81, 98, 20, 0, 255, 0, 0, 0, 0, NULL, NULL, NULL},
	{d_check_proc, 81, 100, 100, 10, 255, 0, 0, 0, 0, 0, (void*)"&Shut", NULL, NULL},
	{d_check_proc, 81, 120, 100, 10, 255, 0, 0, 0, 0, 0, (void*)"&Lock", NULL, NULL},
	{d_text_proc, 141, 100, 40, 20, 0, 255, 0, 0, 0, 0, c_key_name, NULL, NULL}, 
	{d_choosekey_proc, 141, 120, 40, 20, 255, 0, 0, 0, 0, 0, (void*)"Key...", NULL, NULL},
	{NULL}
};
int Door::edit()
{
	c_key=key;
	strcpy(c_key_name, c_key ? c_key->name() : "(none)");
	door_dlg[2].dp=name();
	door_dlg[3].flags= is_closed() ?  D_SELECTED : 0;
	door_dlg[4].flags=can_lock() ? ((is_locked()) ? D_SELECTED : 0) 
		: D_DISABLED ;
	popup_dialog(door_dlg, -1);
	int old_state=state;
	int new_state=state & ~(locked|closed);
	if (!(door_dlg[4].flags & D_DISABLED) 
		&& door_dlg[4].flags & D_SELECTED)
	{
		new_state|=locked;
	}
	if (door_dlg[3].flags & D_SELECTED)
	{
		new_state|=closed;
	}
	set_state(new_state);
	key=c_key;
	c_key=0;
	return new_state!=old_state;
}

int d_choosekey_proc(int msg, DIALOG* d, int c)
{
	int ans=d_button_proc(msg, d, c);
	if (d->flags & D_SELECTED)
	{
		d->flags &= ~D_SELECTED;
		c_key=choose_object();
		strcpy(c_key_name, c_key ? c_key->name() : "(none)");
		broadcast_dialog_message(D_REDRAW, 0);
	}
	return ans;
}
#endif		
int Door::set_state(int ns)
{
	if (ns & closed)
	{
		img=iclosed;
	}
	else
	{
		img=iopen;
	}
	return state=ns;
}

int Door::do_action(AAction a, AParam , AParam )
{
	HBag& b=HBag::inst();
	switch(a)
	{
		case AA_DEFAULT: // default: open/close door
			if (is_locked())
			{
				pager.message("It's locked");
				return AA_NOT_OK;
			}
			else
			{
				flip_state(closed);
				return AA_OK;
			}
		case AA_EXAMINE:
		{
			const char* st=(is_locked()) ? "locked" : (is_closed() ? "closed" : "open");
			b<<">Examine door\n" 
				<<"The door is " << st << "\n";
			return AA_MSG;
		}
		case AA_OPEN:
			b << ">Open door\n";
			if (!is_closed())
			{
				b<<"The door is already open\n";
			}
			else if (is_locked())
			{
				b<<"The door is locked\n";
			}
			else
			{
				b<<"OK\n";
				remove_state(closed);
			}
			return AA_MSG;
		case AA_CLOSE:
			b << ">Close door\n";
			if (is_closed())
			{
				b<<"The door is already closed\n";
			}
			else
			{
				b<<"OK\n";
				add_state(closed);
			}
			return AA_MSG;
		default:
			return AA_NOTHING;
	}
}
	
AAction* Door::actions()
{
	return a_list;
}

AAction Door::a_list[]={AA_OPEN, AA_CLOSE, AA_EXAMINE, AA_END_LIST};

int Door::opaque() 
{
	return is_closed() ? TT_SOLID : TT_CLEAR;
}

AAction LockingDoor::a_list[]={AA_OPEN, AA_CLOSE,AA_EXAMINE,AA_LOCK, 
	AA_UNLOCK,AA_END_LIST};

LockingDoor::LockingDoor(int s) : Door(s|lockable)
{
}	
int LockingDoor::do_action(AAction a, AParam p1, AParam p2)
{
	HBag& b=HBag::inst();
	switch(a)
	{
		case AA_UNLOCK:
		if (is_locked())
		{
			AObject* k=b.choose("Unlock with...");
			if (k)
			{
				b<<">Unlock door with "<<k->name()<<"\n";
				if (k==key)
				{
					b<<"OK\n";
					remove_state(locked);
				}
				else
				{
					b<<"It doesn't fit\n";
				}
				return AA_MSG;
			}
			else
			{
				return AA_NOTHING;
			}
		}
		else
		{
			b << ">Unlock door\nThe door is already unlocked\n";
		}
		return AA_MSG;
		case AA_LOCK:
		if (!is_locked())
		{
			AObject* k=b.choose("Lock with...");
			if (k)
			{
				b<<">Lock door with "<<k->name()<<"\n";
				if (k==key)
				{
					b<<"OK\n";
					add_state(locked);
				}
				else
				{
					b<<"It doesn't fit\n";
				}
				return AA_MSG;
			}
			else
			{
				return AA_NOTHING;
			}
		}
		else
		{
			b<< ">Lock door\nThe door is already locked\n";
		}
		return AA_MSG;
		default:
			return Door::do_action(a, p1, p2);
	}
}	

Gramophone::Gramophone(): StaticObj(0)
{ 
	img=with=rle("Gramophone1");
	without=rle("Gramophone2");
	has_horn=1;
}

AAction Gramophone::a_list[]={AA_EXAMINE, AA_GET, AA_END_LIST};

int Gramophone::do_action(AAction a, AParam p1, AParam )
{
	HBag& b=HBag::inst();
	switch(a)
	{
		case AA_EXAMINE:
			b<<">Examine gramophone\nAn antique wind-up gramophone\n";
			return AA_MSG;
		case AA_GET:
			b<<">Get Gramophone\n";
			if (has_horn)
			{
				AParam p;
				p.obj=Level::current->find_obj("Horn");
				b<<"The horn comes off in your hand.\n";
				has_horn=0;
				img=without;
				return p1.obj->do_action(_AA_GETOBJ, p);
			}
			else
			{
				b<<"It's too fragile to pick up.\n";
				return AA_MSG;
			}
		default:
			return AA_NOTHING;
	}
}
void Gramophone::persist(BStream& b)
{
	if (b.writing())
	{
		b << has_horn;
	}
	else
	{
		b >> has_horn;
		img= has_horn ? with : without;
	}
}

Well::Well() : StaticObj(0)
{ 
	img=rle("Well");
}

AAction Well::a_list[]={AA_EXAMINE, AA_WISH, AA_END_LIST};

int Well::do_action(AAction a, AParam , AParam )
{
	HBag& b=HBag::inst();
	switch(a)
	{
		case AA_EXAMINE:
			b<<">Examine well\nIt's a wishing well\n";
			return AA_MSG;
		case AA_WISH:
			{
			AObject* w=b.choose("Wish with...");
			if (w)
			{
				b<<">Wish with "<<w->name()<<"\nNothing happens\n";
				return AA_MSG;
			}
			else
				return AA_NOTHING;
			}
		default:
			return AA_NOTHING;
	}
}

Warp::Warp() : BackgroundObj(0)
{
	img=rle("WarpImg");
	wx=wy=1000;
}
void Warp::persist(BStream& b)
{
	if (b.reading())
	{
		b>>wx>>wy;
	}
	else
	{
		b<<wx<<wy;
	}
}

int Warp::do_action(AAction a, AParam p, AParam)
{
	switch(a)
	{
		case _AA_ZONE:
			((MovableObj*) p.obj)->move_to(wx,wy);
			pager.message(makecol(255, 0, 0), "Baooo!");
			return AA_NO;
		default:
			return AA_NOTHING;
	}
}

#ifdef HAS_EDITOR
static char t_wx[10], t_wy[10];
static DIALOG warp_dlg[]={
	{d_box_proc, 80, 80, 100, 80, 255, 0, 0, 0, 0, 0, NULL, NULL, NULL},
	{d_button_proc, 110, 140, 40, 20, 255, 0, 0, D_EXIT, 0, 0, (void*)"OK", NULL, NULL},
	{d_ctext_proc, 130,81, 98, 20, 0, 255, 0, 0, 0, 0, NULL, NULL, NULL},
	{d_edit_proc, 100, 100, 80, 10, 255, 0, 0, 0, 9, 0, t_wx, NULL, NULL},
	{d_edit_proc, 100, 120, 80, 10, 255, 0, 0, 0, 9, 0, t_wy, NULL, NULL},
	{d_text_proc, 81, 100, 20, 10, 255, 0, 0, 0, 0, 0, (void*)"X:", NULL, NULL},
	{d_text_proc, 81, 120, 20, 10, 255, 0, 0, 0, 0, 0, (void*)"Y:", NULL, NULL},
	{NULL}
};
int Warp::edit()
{
	warp_dlg[2].dp=name();
	itoa(wx, t_wx, 10);
	itoa(wy, t_wy, 10);
	int owx=wx, owy=wy;
	popup_dialog(warp_dlg, -1);
	wx=atoi(t_wx);
	wy=atoi(t_wy);
	return (wx!=owx) || (wy!=owy);
}
#endif		

#ifdef HAS_EDITOR
#define ZM_NAME "NotBlank"
#else
#define ZM_NAME "Blank"
#endif

ZoneMarker::ZoneMarker() : BackgroundObj(rle(ZM_NAME))
{
	message[0]='\0';
	shown=0;
}
void ZoneMarker::persist(BStream& b)
{
	//deliberately don't save 'shown'
	if (b.reading())
	{
		b>>message;
	}
	else
	{
		b<<message;
	}
}
int ZoneMarker::do_action(AAction a, AParam, AParam)
{
	if (a==_AA_ZONE && (shown==0))
	{
		shown=1;
		pager.message(message);	
		return AA_MSG;
	}
	return AA_NOTHING;
}

#ifdef HAS_EDITOR
static char zm_msg[40];
static DIALOG zm_dlg[]={
	{d_box_proc, 80, 80, 100, 85, 255, 0, 0, 0, 0, 0, NULL, NULL, NULL},
	{d_button_proc, 110, 140, 40, 20, 255, 0, 0, D_EXIT, 0, 0, (void*)"OK", NULL, NULL},
	{d_ctext_proc, 130,81, 98, 20, 0, 255, 0, 0, 0, 0, NULL, NULL, NULL},
	{d_edit_proc, 81, 114, 90, 10, 255, 0, 0, 0, 39, 0, zm_msg, NULL, NULL},
	{d_text_proc, 81, 100, 90, 10, 255, 0, 0, 0, 0, 0, (void*)"Message:", NULL, NULL},
	{NULL}
};
int ZoneMarker::edit()
{
	zm_dlg[2].dp=name();
	strcpy(zm_msg, message);
	popup_dialog(zm_dlg, -1);
	if (strcmp(zm_msg, message))
	{
		strcpy(message, zm_msg);
		return 1;
	}
	else
	{
		return 0;
	}
}
#endif		

