// choose.h

class Choice
{
	public:
	Choice(int id);
	virtual ~Choice() {}
	virtual void draw(BITMAP* s, int x, int y)=0;
	int id() const {return ident;}
	virtual int can_select() =0;
	int height() const {return h;}
	protected:
	int h;
	private:
	int ident;
};

class TextItem : public Choice
{
	public:
	TextItem(int i, char*);
	void draw(BITMAP* s, int x, int y);
	int can_select() {return 1;}
	protected:
	char* txt;
};

class StaticTextItem : public TextItem
{
	public:
	StaticTextItem(char*, int bold=0);
	void draw(BITMAP*s, int x, int y);
	int can_select() {return 0;}
	protected:
	int bold;
};

class Chooser
{
	public:
	Chooser(BITMAP* bm);
	Chooser(BITMAP* bm, int x, int y, int w, int h);
	virtual ~Chooser();
	void add(Choice&);
	void remove_all();
	void process(int k);
	int choose();
	Choice& current();
	int count() const {return ct;}
	Choice& operator[](int i);
	protected:
	virtual void draw();
	virtual int y_of(int index);
	void mdelay();
	BITMAP* sc;
	BITMAP* target;
	int owns_bm;
	Choice** items;
	int ct, maxc, maxh;
	int index, top, yi;
};
class HChooser : public Chooser
{
	public:
	HChooser(BITMAP* bm);
	HChooser(BITMAP* bm, int x, int y, int w, int h);
	int choose();
	protected:
	virtual void draw();
	virtual int y_of(int i);
};

int SimpleChoose(char* title, char* options);
