#include <allegro.h>
#include "choose.h"
#include "input.h"

Chooser::Chooser(BITMAP* b) : target(b)
{
	index=-1;
	yi=0;
	top=0;
	ct=0;
	maxh=0;
	maxc=10;
	owns_bm=0;
	items=new Choice*[maxc];
	sc=create_bitmap(b->w, b->h);
}
Chooser::Chooser(BITMAP* b, int x, int y, int w, int h) 
{
	index=-1;
	yi=0;
	top=0;
	ct=0;
	maxh=0;
	maxc=10;
	owns_bm=1;
	target=create_sub_bitmap(b, x, y, w, h);
	sc=create_bitmap(w, h);
	items=new Choice*[maxc];
}
Chooser::~Chooser()
{
	delete[] items;
	if (owns_bm) destroy_bitmap(target);
	destroy_bitmap(sc);
}
Choice& Chooser::operator[](int i)
{
	if (i<0) i=0;
	if (i>=ct) i=ct-1;
	return *items[i];
}
int Chooser::y_of(int i)
{
	if (i<0 || i>ct)
		return 0;
	int y=0;
	while (i--)
	{
		y+=items[i]->height();
	}
	return y;
}
void Chooser::add(Choice& c)
{
	if (ct>=maxc)
	{
		// realloc if necessary
		Choice** ii=new Choice*[maxc*=2];
		for (int i=0; i<ct; ++i)
			ii[i]=items[i];
		delete[] items;
		items=ii;
	}
	// add to the list
	if (index<0 && c.can_select())
	{
		index=ct;
		yi=y_of(ct);
	}
	items[ct++]=&c;
	maxh=y_of(ct);
	if (maxh>sc->h)
		maxh=sc->h;
}
void Chooser::remove_all()
{
	ct=0;
	index=0;
	maxh=0;
}
Choice& Chooser::current()
{
	// this could return an invalid object if 
	// there's nothing or nothing selectable 
	// in the chooser
	return *items[index];
}
void Chooser::mdelay()
{
	rest(25);
}

void Chooser::process(int k)
{
	// move selection up (k<0) or down (k>0)
	if (k<0)
	{
		int ytarg=yi;
		int itarg=index;
		for (int i=0; i<index; ++i)
		{
			if (items[i]->can_select())
			{
				ytarg=y_of(i);
				itarg=i;
			}
		}
		while (yi>ytarg)
		{
			mdelay();
			yi--;
			if (yi<top)
				top--;
			draw();
		}
		index=itarg;
	}
	else if (k>0)
	{
		int ytarg=yi;
		int itarg=index;
		for (int i=ct-1; i>index; --i)
		{
			if (items[i]->can_select())
			{
				ytarg=y_of(i);
				itarg=i;
			}
		}
		while (yi<ytarg)
		{
			mdelay();
			yi++;
			if (yi>top+sc->h)
				top++;
			draw();
		}
		index=itarg;
	}		
	else
	{
		// select the first item and draw.
		for (int i=0; i<ct; ++i)
		{
			if (items[i]->can_select())
			{
				index=i;
				yi=y_of(i);
				break;
			}
		}
		draw();
	}
}

void Chooser::draw()
{
	text_mode(-1);
	int yy=-top;
	clear_to_color(sc, makecol(192,192,192));
	rectfill(sc, 0, yy+yi, sc->w, yy+yi+items[0]->height()-1, makecol(128,128,255));
	for (int i=0; i<ct; ++i)
	{
		items[i]->draw(sc, 0, yy);
		yy+=items[i]->height();
	}
	blit(sc, target, 0, 0, 0, 0, sc->w, sc->h);
}

int Chooser::choose()
{
	yi=top=0;
	process(0);
	// Wait for all keys released
	Control->release();
	while(1)
	{
		Control->poll();
		if (Control->u()) {process(-1);}
		if (Control->d()) {process(1);}
		if (Control->e()) return -1;
		if (Control->f())
		{
			Control->release();
		 	if (items[index]->can_select()) 
			{
				return items[index]->id();
			}
		}
	}
}

Choice::Choice(int ii)
{
	ident=ii;
}

TextItem::TextItem(int i, char* s) : Choice(i)
{
	txt=s;
	h=text_height(font);
}

void TextItem::draw(BITMAP* s, int x, int y)
{
	textout(s, font, txt, x, y,  makecol(0,0,0));
}

StaticTextItem::StaticTextItem(char* s, int b) : TextItem(-1, s)
{
	bold=b;
}
void StaticTextItem::draw(BITMAP* s, int x, int y)
{
	textout(s, font, txt, x, y,  makecol(0,0,255));
	if (bold)
	{
		textout(s, font, txt, x+1, y,  makecol(0,0,255));
	}
}
class UnselectableTextItem : public StaticTextItem
{
	public:
	UnselectableTextItem(char* s) : StaticTextItem(s) {}
	void draw(BITMAP*, int x, int y);
};
void UnselectableTextItem::draw(BITMAP* s, int x, int y)
{
	textout(s, font, txt, x, y,  makecol(128,128,128));
}

HChooser::HChooser(BITMAP* bm) : Chooser(bm)
{
}
HChooser::HChooser(BITMAP* bm, int x, int y, int w, int h) 
	: Chooser(bm, x, y, w, h)
{
}

void HChooser::draw()
{
//	rectfill(sc, 0, 0, sc->w-1, sc->h-1, makecol(192,192,192));
	clear_to_color(sc, makecol(192,192,192));
	for (int i=0; i<ct; ++i)
		items[i]->draw(sc, 0, y_of(i)-yi);
	blit(sc, target, 0,0,0,0,target->w, target->h);
}
int HChooser::y_of(int i)
{
	return Chooser::y_of(i);
}

int SimpleChoose(char* title, char* options)
{
	BITMAP* ss=create_bitmap(100,120);
	blit(screen, ss, 60,60,0,0,100,120);
	text_mode(-1);
/*	Chooser ch(screen, 60, 60+hdr.height(), 100, 120-hdr.height());
	rectfill(screen, 60, 60, 159, 60+hdr.height(), makecol(128,192,192));
	StaticTextItem hdr(title, 1);
	hdr.draw(screen, 60, 60);*/
	Chooser ch(screen, 60, 60, 100, 120);	
	ch.add(*new StaticTextItem(title, 1));
	int i=0;
	while (*options)
	{
		// make menu options starting '.' unselectable
		// ie. un-implemented options
		Choice* n=(options[0]=='.') ?
			new UnselectableTextItem(options+1)
			: new TextItem(i, options);
		ch.add(*n);
		++i;
		while (*options++)
		{ }
	}
	TRACE("chooser\n");
	int ans=ch.choose();		
	for (int i=0; i<ch.count(); ++i)
		delete& ch[i];
	ch.remove_all();
	Control->release();
	blit(ss, screen, 0,0,60,60,100,120);
	destroy_bitmap(ss);
	return ans;
}
	
	

