#ifndef __CAST_H__
#define __CAST_H__

// cast.h

#include "aobject.h"

class Map;
class BStream;

class StdCast: public MovingObj
{
	public:
	typedef char* twin[2];
	StdCast(Map&);
	virtual ~StdCast();
	AAction* actions();
	void persist(BStream&);
	int do_action(AAction, AParam, AParam);
	protected:
	void i_init(const int[], int fr);
	void i_init(const char*[], int fr);
	void i_init(char*);
	int take_step(int dx, int dy);
	RLE_SPRITE** f_r;
	RLE_SPRITE** f_u;
	RLE_SPRITE** f_d;
	RLE_SPRITE** f_l;
	// increments in pixels
	int step_x, step_y, step_xy_x, step_xy_y;
	int aa_query_name(char* t);
	int aa_ask(HBag&);
	private:
	virtual twin* knowledge();
	virtual char* properties();
	void choose_image();
	// Steps
	int s_r, s_l, s_u, s_d;
	// count of images
	int c_r, c_l, c_u, c_d;
	static twin know_tab[];
	public:
	DECL_EDIT
	int edit_inventory(); // for editor only
};

class Mummy: public StdCast
{
	public:
	Mummy(Map&);
	AAction* actions();
	int do_action(AAction, AParam, AParam);
	char* name() {return "Mummy";}
	int move();
	private:
	char* properties();
	static const char* frames[];
	int dir, decide;
};
class Pyotr : public StdCast
{
	public:
	Pyotr(Map&);
	AAction* actions();
	int do_action(AAction, AParam, AParam);
	char* name() {return "Pyotr";}
	int move();
	void persist(BStream&);
	private:
	static const char* frames[];
	int fishing;
	RLE_SPRITE* fishing_image;
	public:
	DECL_EDIT
};

class Sallis: public StdCast
{
	public:
	Sallis(Map&);
	AAction* actions();
	int do_action(AAction, AParam, AParam);
	char* name() {return "Sallis";}
	int move();
	void persist(BStream&);
	private:
	char* properties();
	int dir, decide;
	RLE_SPRITE* fishing_img;
	int fishing;
};

class Rebecca: public StdCast
{
	public:
	Rebecca(Map&);
	AAction* actions();
	int do_action(AAction, AParam, AParam);
	char* name() {return "Rebecca";}
	int move();
	private:
	char* properties();
	static const char* frames[];
	int dir, decide;
};
class Septimus: public StdCast
{
	public:
	Septimus(Map&);
	AAction* actions();
	int do_action(AAction, AParam, AParam);
	char* name();
	int move();
	private:
	twin* knowledge() {return know_table;}
	char* properties();
	int dir;
	int decide;
	static const char* frames[];
	static twin know_table[];
};
class ProgBot: public StdCast
{
	public:
	ProgBot(Map&);
	AAction* actions() {return alist;}
	int do_action(AAction, AParam, AParam);
	char* name() {return "ProgBot";}
	int move();
	private:
	int queue_move(int dirn);
	int dir;
	int step_count;
	static const char* frames[];
	static AAction alist[];
};
class Granville: public StdCast
{
	public:
	Granville(Map& m);
	int move();
	AAction* actions() {return alist;}
	int do_action(AAction, AParam, AParam);
	char* name() {return "Granville";}
	private:
	char* properties();
	twin* knowledge();
	int dir;
	int qq;
	static const char* frames[];
	static twin know[];
	static twin dontknow[];
	static AAction alist[];
	int loud(AObject*);
};
class Jack: public StdCast
{
	public:
	Jack(Map& m);
	int move();
	int do_action(AAction, AParam, AParam);
	char* name() {return "Jack";}
	private:
	char* properties();
	int dir;
	static const char* frames[];
};
	
#endif
