#include <stdio.h>
#include <allegro.h>
#include "cast.h"
#include "map.h"
#include "hbag.h"
#include "actions.h"
#include "bstrm.h"
#include "level.h"
#include "input.h"
#include "pager.h"
extern Pager pager;

extern RLE_SPRITE* rle(const char*);


Pyotr::Pyotr(Map& m) : StdCast(m)
{
	fishing=0;
	fishing_image=rle("PyotrFishing");
	i_init("PYOTR_BIN");
}

int Pyotr::move()
{
	// handle fishing thing
	if (fishing>0)
	{
		if (--fishing==0)
			pager.message("Caught something!");
	}
	int dx=0, dy=0;
	if (Control->r()) dx=step_x;
	if (Control->l()) dx=-step_x;
	if (Control->u()) dy=-step_y;
	if (Control->d()) dy=step_y;
	if (dx||dy) 
	{
		fishing=0;
	}
	if (map.tile(dx+x, y)) 
	{
		dx=0;
	}
	if (map.tile(dx+x, dy+y)) 
	{
		dy=0;
	}
	return take_step(dx,dy);	
}

AAction* Pyotr::actions()
{
	static AAction pa[]={AA_CHECK, AA_END_LIST};
	return pa;
}

int Pyotr::do_action(AAction a, AParam p, AParam q)
{
	MovableObj* mo;
	HBag& b=HBag::inst();
	switch(a)
	{
		case AA_CHECK:
			b<<">Check Pyotr\nPyotr is at ("
				<< x << "," << y <<")\n";
			return AA_MSG;
		case AA_CAST:
			b<<">Cast rod\nFishing is such a fun hobby!\n";
			fishing=100;
			img=fishing_image;
			return AA_MSG;
		case _AA_GETOBJ:
			b<<"OK\n";
			mo = (MovableObj*) p.obj;
			inv_items.add(mo);
			mo->move_nowhere();
			return AA_CHANGED_INV;
		case _AA_DROPOBJ:
			b<<"OK\n";
			mo = (MovableObj*) p.obj;
			inv_items.remove(mo);
			mo->move_to(*this);
			return AA_CHANGED_INV;
		default:
			return StdCast::do_action(a,p,q);
	}
}
			
void Pyotr::persist(BStream& b)
{
	StdCast::persist(b);
}

#ifdef HAS_EDITOR
static char msg[40];
static StdCast* psc;
static int d_inv_proc(int msg, DIALOG* d, int c)
{
	int ans=d_button_proc(msg, d, c);
	if (d->flags & D_SELECTED)
	{
		d->flags &= ~D_SELECTED;
		psc->edit_inventory();
	}
	return ans;
}
static DIALOG p_dlg[]={
{d_box_proc, 100, 60, 100, 100, 255, 0, 0, 0, 0, 0, NULL,NULL, NULL},
{d_text_proc, 101, 61, 98, 20, 255, 0, 0, 0, 0, 0, msg, NULL, NULL},
{d_button_proc, 130, 140, 40, 20, 255, 0, 0, D_EXIT, 0, 0, (void*)"OK", NULL, NULL},
{d_inv_proc, 130, 120, 40, 20, 255, 0, 0, 0, 0, 0, (void*)"Inv.", NULL, NULL},
{NULL,       0,   0,   0,  0,  0,   0, 0, 0, 0, 0, 0,             0,    0}
};

int Pyotr::edit()
{
	psc=this;
	sprintf(msg, "%s(%d,%d)", name(), get_x(), get_y());
	popup_dialog(p_dlg, -1);
	return 0;
}
#endif

Septimus::Septimus(Map& m) : StdCast(m)
{
	decide=dir=0;
	i_init("SEPTIMUS_BIN");
}

int Septimus::move()
{
	static const int dxtab[]={0, 2, 4, 2, 0, -2, -4, -2};
	static const int dytab[]={-2, -1, 0, 1, 2, 1, 0, -1};
	static int xo=0;
	int dx=dxtab[dir], dy=dytab[dir];
	if (map.tile(dx+x, dy+y) || ((xo++ % 123)==0)) 
	{
		if (decide>16)
		{
			dir=(dir+1) % (sizeof(dxtab)/sizeof(int));
		}
		else
		{
			dir=(dir+sizeof(dxtab)/sizeof(int)-1) % 
				(sizeof(dxtab)/sizeof(int));
		}
		decide=(decide+1)%32;
		return 0;
	}
	return take_step(dx,dy);
}

char* Septimus::name()
{
	return "Septimus";
}

AAction* Septimus::actions()
{
	static AAction zz[]={ AA_GREET, AA_HELP, 
		AA_ASK, AA_GIVE, AA_END_LIST};
	return zz;
}

int Septimus::do_action(AAction act, AParam p1, AParam p2)
{
	HBag& b=HBag::inst();
	switch(act)
	{
		case AA_GREET:
			b<< ">Greet Septimus\n"
				<<((decide & 1) ? "\"Hello\"\n" : "\"Buzz off\"\n");
			return AA_MSG;
		case AA_HELP:
		{
			AObject* magnet=Level::current->find_obj("Magnet");
			b << ">\"Help\"\n";
			if (inv_items.has(magnet))
			{
				AParam p;
				p.obj=magnet;
				b << "\"This magnet might help you.\"\n";
				inv_items.remove(magnet);
				return p1.obj->do_action(_AA_GETOBJ, p);
			}
			else
			{
				b << "\"There's nothing I can suggest.\"\n";
				return AA_MSG;
			}
		}
		default:
			return StdCast::do_action(act, p1, p2);
	}
}

char* Septimus::know_table[][2]={
	{"gold-key?", "It fits in a door somewhere near here."},
	{"Septimus", "I'm your local barber, Septimus."},
	{"Magnet", "I had a drawer full of old stuff somewhere, I just thought it might come in handy."},
	{"Sallis", "He is a grumpy old fellow. He doesn't approve of me."},
	{"Rebecca", "She is simply fabulous. We're lucky to have her."},
	{"Granville", "Poor old Granville is a little forgetful these days."},
	{0, "Oh, I wouldn't know about anything like that."}
};
char* Septimus::properties()
{
	return "male?\0";
}
Mummy::Mummy(Map& m) : StdCast(m)
{
	dir=2;
	decide=0;
	i_init(frames, 4);
}
const char* Mummy::frames[]={
	"MUMMY1U_BMP", "MUMMY1U_BMP", "MUMMY2U_BMP", "MUMMY2U_BMP",
	"MUMMY1R_BMP", "MUMMY1R_BMP", "MUMMY2R_BMP", "MUMMY2R_BMP",
	"MUMMY1D_BMP", "MUMMY1D_BMP", "MUMMY2D_BMP", "MUMMY2D_BMP",
	"MUMMY1L_BMP", "MUMMY1L_BMP", "MUMMY2L_BMP", "MUMMY2L_BMP"
};

int Mummy::move()
{
	static const int dxtab[]={0, 2,  0,  -2};
	static const int dytab[]={-1, 0, 1, 0};
	static int xo=0;
	int dx=dxtab[dir], dy=dytab[dir];
	if (map.tile(dx+x, dy+y) || ((xo++ % 67)==0)) 
	{
		if (decide>16)
		{
			dir=(dir+1) % (sizeof(dxtab)/sizeof(int));
		}
		else
		{
			dir=(dir+sizeof(dxtab)/sizeof(int)-1) % 
				(sizeof(dxtab)/sizeof(int));
		}
		decide=(decide+1)%32;
		return 0;
	}
	return take_step(dx,dy);
}
AAction* Mummy::actions()
{
	static AAction zz[]={ AA_GREET, AA_END_LIST};
	return zz;
}

int Mummy::do_action(AAction act, AParam p1, AParam p2)
{
	HBag& b=HBag::inst();
	switch(act)
	{
		case AA_GREET:
			b<< ">Greet Mummy\n\"Mmmmmmm.....\"\n";
			return AA_MSG;
		default:
			return StdCast::do_action(act,p1,p2);
	}
}
char* Mummy::properties()
{
	return "female?\0";
}
Rebecca::Rebecca(Map& m) : StdCast(m)
{
	dir=2;
	decide=0;
	i_init(frames, 4);
}
const char* Rebecca::frames[]={
	"R_U_1", "R_U_1", "R_U_2", "R_U_2",
	"R_R_1", "R_R_1", "R_R_2", "R_R_2",
	"R_D_1", "R_D_1", "R_D_2", "R_D_2",
	"R_L_1", "R_L_1", "R_L_2", "R_L_2"
};

int Rebecca::move()
{
	static const int dxtab[]={0, 2,  0,  -2};
	static const int dytab[]={-1, 0, 1, 0};
	static int xo=0;
	int dx=dxtab[dir], dy=dytab[dir];
	if (map.tile(dx+x, dy+y) || ((xo++ % 67)==0)) 
	{
		if (decide>16)
		{
			dir=(dir+1) % (sizeof(dxtab)/sizeof(int));
		}
		else
		{
			dir=(dir+sizeof(dxtab)/sizeof(int)-1) % 
				(sizeof(dxtab)/sizeof(int));
		}
		decide=(decide+1)%32;
		return 0;
	}
	return take_step(dx,dy);
}

AAction* Rebecca::actions()
{
	static AAction zz[]={ AA_GREET, AA_ASK, AA_END_LIST};
	return zz;
}

int Rebecca::do_action(AAction act, AParam p1, AParam p2)
{
	HBag& b=HBag::inst();
	switch(act)
	{
		case AA_GREET:
			b<<">Greet Rebecca\n\"How do you do?\"\n";
			return AA_MSG;
		default:
			return StdCast::do_action(act, p1, p2);
	}
}

char* Rebecca::properties()
{
	return "female?\0";
}
Granville::Granville(Map& m) : StdCast(m)
{
	dir=1;
	qq=0;
	i_init("GRANV_BIN");
}
const char* Granville::frames[]=
{
	"GRANV1U_BMP", "GRANV2U_BMP",
	"GRANV1R_BMP", "GRANV2R_BMP",
	"GRANV1D_BMP", "GRANV2D_BMP",
	"GRANV1L_BMP", "GRANV2L_BMP"
};
int Granville::loud(AObject*)
{
	return inventory().has(Level::current->find_obj("Horn"));
}
int Granville::move()
{
	int dx, dy;
	if (++qq<100)
		return 0;
	if (qq>300) qq=0;
	switch(dir)
	{
		case 0:
			dx=0; dy=-step_x;
			break;
		case 1:
			dx=step_x; dy=0;
			break;
		case 2:
			dx=0; dy=step_y;
			break;
		case 3:
			dx=-step_y; dy=0;
			break;
		default:
			dx=dy=0;
			break;
	}
	if (map.tile(x+dx, y+dy))
	{
		dir=(dir+(qq<200 ? 1 : 3))%4;
		return 0;
	}
	else
	{
		return take_step(dx, dy);
	}
}
StdCast::twin* Granville::knowledge()
{
	if (rand()<(RAND_MAX/5))
	{
		return know;
	}
	else
	{
		return dontknow;
	}
}
char* Granville::know[][2]=
{
	{"Septimus", "He will help if you ask."},
	{"Sallis", "There haven't been any fish in that pond for as long as I can remember. Don't tell him, though!"},
	{"Rebecca", "I remember when she was knee high to a grasshopper"},
	{0, "I really don't know anything, Pyotr"}
};
char* Granville::dontknow[][2]=
{
	{0, "Yes. I can't seem to remember."}
};

AAction Granville::alist[] = {AA_GREET, AA_ASK, AA_GIVE,AA_END_LIST};
int Granville::do_action(AAction act, AParam p1, AParam p2)
{
	HBag& b=HBag::inst();
	switch(act)
	{
		case AA_GREET:
			b<<">Greet Granville\n";
			if (loud(p1.obj))
				b <<"\"Hello, young shaver\"\n";
			else
				b << "\"Speak up, I can't hear you.\"\n";
			return AA_MSG;
		default:
			return StdCast::do_action(act, p1, p2);
	}
}
char* Granville::properties()
{
	return "male?\0";
}

Jack::Jack(Map& m) : StdCast(m)
{
	dir=3;
	i_init("JACK_BIN");
}
const char* Jack::frames[]=
{
	"JACK1U_BMP", "JACK2U_BMP",
	"JACK1R_BMP", "JACK2R_BMP",
	"JACK1D_BMP", "JACK2D_BMP",
	"JACK1L_BMP", "JACK2L_BMP"
};

int Jack::move()
{
	int dx, dy;
	switch(dir)
	{
		case 0:
			dx=0; dy=-step_y;
			break;
		case 1:
			dx=step_x; dy=0;
			break;
		case 2:
			dx=0; dy=step_y;
			break;
		case 3:
			dx=-step_x; dy=0;
			break;
		default:
			dx=dy=0;
			break;
	}
	if (map.tile(x+dx, y+dy))
	{
		dir=(dir+1)%4;
		return 0;
	}
	else
	{
		return take_step(dx, dy);
	}
}
int Jack::do_action(AAction act, AParam p1, AParam p2)
{
	HBag& b=HBag::inst();
	switch(act)
	{
		case AA_GREET:
			b<<">Greet Jack\n"
				<< "\"Ga ga\"\n";
			return AA_MSG;
		default:
			return StdCast::do_action(act,p1,p2);
	}
}
char* Jack::properties()
{
	return "baby?\0male?\0";
}
ProgBot::ProgBot(Map&m) : StdCast(m)
{
	i_init(frames,1);
	dir=0;
	step_count=0;
}
int ProgBot::do_action(AAction a, AParam, AParam)
{
	switch (a)
	{
		case AA_NORTH:
			return queue_move(0);
		case AA_SOUTH:
			return queue_move(2);
		case AA_EAST:
			return queue_move(1);
		case AA_WEST:
			return queue_move(3);
		default:
			return AA_NOTHING;
	}
}
int ProgBot::queue_move(int d)
{
	if (step_count>0)
		return AA_NOTHING;
	else
	{
		dir=d;
		step_count=(d==0 || d==2) ? 10 : 16;
		return AA_OK;
	}
}

int ProgBot::move()
{
	int dx, dy;
	switch(dir)
	{
		case 0:
			dx=0; dy=-1;
			break;
		case 1:
			dx=1; dy=0;
			break;
		case 2:
			dx=0; dy=1;
			break;
		case 3:
			dx=-1; dy=0;
			break;
		default:
			dx=dy=0;
			break;
	}
	if (step_count<=0 || map.tile(x+dx, y+dy))
	{
		return 0;
	}
	else
	{
		--step_count;
		return take_step(dx, dy);
	}
}
const char* ProgBot::frames[]={"PROGBOT_BMP", "PROGBOT_BMP", 
	"PROGBOT_BMP","PROGBOT_BMP"};
AAction ProgBot::alist[]={AA_NORTH, AA_SOUTH, AA_EAST, AA_WEST, 
	AA_END_LIST};

Sallis::Sallis(Map& m) : StdCast(m)
{
	dir=2;
	decide=0;
	i_init("Sallis_Bin");
	fishing=1;
	fishing_img=rle("SallisFishing");
}
int Sallis::move()
{
	if (fishing)
	{
		img=fishing_img;
		// inch to the right until you get
		// to the shore, when fishing.
		if (map.tile(x+1, y))
			return 0;
		else
		{
			x++;
			return 1;
		}
	}
	int dx, dy;
	switch(dir)
	{
		case 0:
			dx=0; dy=-step_y;
			break;
		case 1:
			dx=step_x; dy=0;
			break;
		case 2:
			dx=0; dy=step_y;
			break;
		case 3:
			dx=-step_x; dy=0;
			break;
		default:
			dx=dy=0;
			break;
	}
	if (map.tile(x+dx, y+dy))
	{
		int dd=(decide++ & 8) ? 1 : 3;
		dir=(dir+dd)%4;
		return 0;
	}
	else
	{
		return take_step(dx, dy);
	}
}

AAction* Sallis::actions()
{
	static AAction zz[]={ AA_GREET, AA_GIVE, AA_END_LIST};
	return zz;
}

int Sallis::do_action(AAction act, AParam p1, AParam p2)
{
	HBag& b=HBag::inst();
	switch(act)
	{
		case AA_GREET:
			b << ">Greet Sallis\n"
				<< (fishing ? "\"Shhh. I'm fishing.\"\n" : "\"How do?\"\n")
			 	<< "\n";
			return AA_MSG;
		case AA_GIVE:
		{
			int ans=StdCast::do_action(act, p1, p2);
			if (fishing && inv_items.has(Level::current->find_obj("Fish")))
			{
				fishing=0;
				b << "\"I might as well give up. Have this rod - it's "
				"completely useless as far as I can see.\"\n";
				MovableObj& rod=*(MovableObj*)Level::current->find_obj("Fishing rod");
				rod.move_to(*this);
			}
			return ans;
		}
		default:
			return StdCast::do_action(act, p1, p2);
	}
}

char* Sallis::properties()
{
	return "male?\0";
}

void Sallis::persist(BStream& b)
{
	StdCast::persist(b);
	if (b.writing())
		b << fishing;
	else
		b >> fishing;
}


