#ifndef __BSTRM_H__
#define __BSTRM_H__

class BStream
{
	public:
	BStream();
	virtual ~BStream();
	// stream operations
	BStream& operator<<(int);
	BStream& operator<<(const char*);
	BStream& operator>>(int&);
	BStream& operator>>(char*);
	enum BMode {In, Out};
	virtual BMode mode() const =0;
	int writing() const {return mode()==Out;}
	int reading() const {return mode()==In;}
	int version() const {return ver;}
	static int current_version;
	protected:
	virtual int wr(const char*, int);
	virtual int rd(char*, int);
	int ver;
};


class BOStream : public BStream
{
	public:
	BOStream();
	~BOStream();
	BMode mode() const {return BStream::Out;}
	char* buffer() const {return buf;}
	int length() const {return pos;}
	protected:
	int wr(const char*, int);
	private:
	char* buf;
	int size; 
	int pos;
};
class BIStream: public BStream
{
	public:
	//create with this buffer
	BIStream(char* buffer);
	~BIStream();
	BMode mode() const {return BStream::In;}
	protected:
	int rd(char*, int);
	private:
	char* buf;
	int pos;
};
#endif
