#include <allegro.h>
#include "bstrm.h"

BStream::BStream() : ver(current_version) 
{ 
	
}

BStream::~BStream()
{

}

int BStream::current_version=1;
/* version info
0: initial
1: fishing rod has an attachment
*/

int BStream::wr(const char*, int)
{
	abort();
	return 0;
}

int BStream::rd(char*, int)
{
	abort();
	return 0;
}

BStream& BStream::operator<<(const char* s)
{
	wr(s, 1+strlen(s));
	return *this;
}
BStream& BStream::operator>>(char* s)
{
	char c;
	do
	{
		rd(&c, 1);
		*s++=c;
	} while (c!='\0');
	return *this;
}
BStream& BStream::operator<<(int i)
{
	wr((const char*) &i, sizeof(i));
	return *this;
}
BStream& BStream::operator>>(int& i)
{
	rd((char*) &i, sizeof(i));
	return *this;
}
BOStream::BOStream()
{
	size=10;
	buf=new char[size];
	pos=0;
	wr((const char*) &ver, sizeof(ver));
	TRACE("New ostream v.%x\n", ver);
}
BOStream::~BOStream()
{
	delete[] buf;
}

int BOStream::wr(const char* p, int l)
{
	if (pos+l>size)
	{
		char* t=new char[size*2];
		memcpy(t, buf, size);
		size*=2;
		delete[] buf;
		buf=t;
	}
	memcpy(&buf[pos], p, l);
	return pos+=l;
}

BIStream::BIStream(char* b)
{
	pos=0;
	buf=b;
	rd((char*) &ver, sizeof(ver));
	TRACE("New istream (%x) v.%x\n", b, ver);
}
BIStream::~BIStream()
{

}
int BIStream::rd(char* p, int l)
{
	memcpy(p, &buf[pos], l);
	return pos+=l;
}


