// bookmark.cc
#ifdef HAS_EDITOR
#include <stdio.h>
#include "bookmark.h"
extern RLE_SPRITE* rle(const char*);
Bookmark::Bookmark()
{
	img=rle("Bookmark");
	move_nowhere();
	strcpy(description, "[Nowhere]");
}

char* Bookmark::name()
{
	return description;
}
AAction* Bookmark::actions()
{
	static AAction nothing[]={AA_END_LIST};
	return nothing;
}
static char t_wx[20], t_wy[20], t_desc[40];
static char *q_ok="OK", *q_bookmark="Bookmark", *q_x="X:", *q_y="Y:";
static DIALOG bm_dlg[]=
{
	{d_box_proc, 80, 80, 100, 80, 255, 0, 0, 0, 0, 0, NULL, NULL, NULL},
	{d_button_proc, 110, 140, 40, 20, 255, 0, 0, D_EXIT, 0, 0, q_ok, NULL, NULL},
	{d_ctext_proc, 130,81, 98, 20, 0, 255, 0, 0, 0, 0, q_bookmark, NULL, NULL},
	{d_edit_proc, 100, 95, 80, 10, 255, 0, 0, 0, 39, 0, t_desc, NULL, NULL},
	{d_edit_proc, 100, 108, 80, 10, 255, 0, 0, 0, 9, 0, t_wx, NULL, NULL},
	{d_edit_proc, 100, 120, 80, 10, 255, 0, 0, 0, 9, 0, t_wy, NULL, NULL},
	{d_text_proc, 81, 108, 20, 10, 255, 0, 0, 0, 0, 0, q_x, NULL, NULL},
	{d_text_proc, 81, 120, 20, 10, 255, 0, 0, 0, 0, 0, q_y, NULL, NULL},
	{NULL}
};
int Bookmark::edit()
{
	// cut the brackets
	strcpy(t_desc, description+1);
	t_desc[strlen(t_desc)-1]='\0';
	sprintf(t_wx, "%d", get_x());
	sprintf(t_wy, "%d", get_y());
	popup_dialog(bm_dlg, -1);
	char nd[40];
	sprintf(nd,"[%s]", t_desc);
	int nx=atoi(t_wx);
	int ny=atoi(t_wy);
	if (nx!=get_x() || ny!=get_y() || strcmp(description, nd))
	{
		move_to(nx,ny);
		strcpy(description, nd);
		return 1;
	}
	else
	{
		return 0;
	}
}

#endif //has_editor
