#include <allegro.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include "bfstrm.h"

BIFStream::BIFStream(char* fn, bool compress)
{
	f=pack_fopen(fn, compress ? F_READ_PACKED : F_READ);
	rd((char*) &ver, sizeof(ver));
	TRACE("New ifstream (%s) v.%x\n", fn, ver);
}
int BIFStream::rd(char* p, int l)
{
	return pack_fread(p, l, f);
}
BIFStream::~BIFStream()
{
	pack_fclose(f);
}
BOFStream::BOFStream(char* fn, bool compress) 
{
	f=pack_fopen(fn, compress ? F_WRITE_PACKED: F_WRITE);
	wr((const char*) &ver, sizeof(ver));
	TRACE("New ofstream (%s) v.%x\n", fn, ver);
}
int BOFStream::wr(const char* p, int l)
{
	return pack_fwrite(p, l, f);
}
BOFStream::~BOFStream()
{
	pack_fclose(f);
}

