// Aquarius.cc
#include <string.h>
#include "aquarius.h"
#include "cast.h"
#include "actions.h"
#include "bstrm.h"
#include "items.h"
#include "precursr.h"


Aquarius::Aquarius() 
{

}

Aquarius::~Aquarius()
{

}
int Aquarius::common_prep()
{
	load_data(datafile_name());
	BIStream in((char*) find_data("TileData")->dat);
	// Create the palette
	while(1)
	{
		int index;
		char tile_type[64];
		in>>index;
		if (index>=0 && index<256)
		{	
			in >> tile_type;
			Precursor* p=Precursor::get(tile_type);
			if (p)
			{
				tcache[index]=p;
				p->persist(in);
			}
		}
		else
			break;
	}
	// Create cast+objects
	player=new Pyotr(m);
	everything.add(player);
	everything.add(new Jack(m));
	// Create all objects

	return 0;
}

int Aquarius::prepare()
{
	common_prep();
	// do init
	create_fg_map((BITMAP*) find_data("Map")->dat);
	BIStream inp((char*) find_data("ObjData")->dat);
	char dummy[64];
	// read in the level name which is always 'aquarius'
	inp>>dummy;
	persist(inp);
	// Set up background layer
	BITMAP* mp=(BITMAP*) find_data("BackMap")->dat;
	create_bg_map(mp);
	tile_bitmap=(BITMAP*) find_data("BackTiles")->dat;
	if (get_config_int("Atlantis", "back_layer", 1))
	{
		m.set_background(mp, tile_bitmap);
	}
	return 0;
}

#ifdef HAS_EDITOR
#include "bfstrm.h"
static char b_map[]="aquarius/bckmap.bmp";
static char b_tiles[]="aquarius/bcklyr.bmp";
static char o_data[]="aquarius/objdat.bin";
static char f_map[]="aquarius/map.bmp";

int Aquarius::prepare_from_file()
{
	common_prep();
	create_fg_map(load_bitmap(f_map,fmp));
	create_bg_map(load_bitmap(b_map,mpp));
	tile_bitmap=load_bitmap(b_tiles,tlp);
	m.set_background(bg_bitmap, tile_bitmap);
	BIFStream b(o_data);
	char dummy[64];
	// read in the level name which is always 'aquarius'
	b>>dummy;
	persist(b);
	changed=0;
	return 0;
}

int Aquarius::save_edits()
{
	if (changed)
	{
		save_bitmap(b_map, bg_bitmap, mpp);
		save_bitmap(b_tiles, tile_bitmap, tlp);
		save_bitmap(f_map, fg_bitmap, fmp);
		// not sure about this - you wont't be able
		// to repeatedly call edit/save_edits without 
		// calling prepare_from_file
		destroy_bitmap(fg_bitmap);
		destroy_bitmap(bg_bitmap);
		destroy_bitmap(tile_bitmap);
		BOFStream b(o_data);
		persist(b);
		changed=0;
		return 1;
	}
	else
		return 0;
}
#endif

