#include <allegro.h>
DATAFILE* adata;
#include "input.h"

FONT* smallfont;


void app_close(char* s)
{
	set_gfx_mode(GFX_TEXT,0,0,0,0);
	if (s) 
	{
		allegro_message(s);
		exit(1);
	}
}
void* find_data(const char* n)
{
	for (DATAFILE* d=adata; d && d->type!=DAT_END; ++d)
	{
		const char *s=get_datafile_property(d, DAT_ID('N','A','M','E'));
		if (strcmp(s,n)==0)
			return d->dat;
	}
	// Not found - bomb out
	app_close("Init: data objects not found");
	return 0;
}

void app_init()
{
	allegro_init();
	set_gfx_mode(GFX_AUTODETECT, 320, 200, 0, 0);
	adata=load_datafile("atlantis.dat");
	set_palette((PALETTE) find_data("WinPal"));
	font=(FONT*) find_data("AFont");
	smallfont=(FONT*) find_data("SmallFont");
	
	install_timer();
	if (get_config_int("atlantis", "control",0))
		selectJoystick();
	else
		selectKeyboard();
}


