// aobject.h
#ifndef __AOBJECT_H__
#define __AOBJECT_H__

#include <allegro.h>
class Map;
class HBag;
class AObject;
class BStream;

#include "actions.h"

typedef aa_actions AAction;

#include "editor.h"

struct AParam
{
	union {
	int id;
	AObject* obj;
	void* extra;
	char* msg;
	AParam* ptr;
	};
};
#define NOPARAM AParam()

typedef char* ps_rep;
	
RLE_SPRITE* rle_dat(DATAFILE&); 

class AObject
{
	public:
	virtual ~AObject() {}
	int get_w() const {return img->w;}
	int get_h() const {return img->h;}
	void draw(BITMAP* s, int x, int y) const {draw_rle_sprite(s, img, x, y);}
	virtual AAction* actions()=0;
	virtual char* name()=0;
	virtual int opaque()=0;
	virtual int do_action(AAction, AParam, AParam) { return AA_NOTHING;}
	int do_action(AAction a, AParam p) 
		{return do_action(a, p, NOPARAM);}
	int do_action(AAction a) 
		{return do_action(a, NOPARAM, NOPARAM);}
	virtual int isa() const {return 0;}
	virtual ps_rep persistent_name() {return ps_rep(name());}
	virtual void persist(BStream&) {};
	// dispose of this object.
	// for 'shared' objects might not actually
	// delete the object, for unique ones it will.
	virtual void dispose();
	// Editor function if included
	DECL_EDIT
	protected:
	RLE_SPRITE* img;
};

class AList
{
	public:
	AList();
	~AList();
	void add(AObject*);
	void add(const AList&);
	void remove(const AObject*);
	int has(const AObject*) const;
	void clear();
	AObject* operator[](int) const;
	int count() const {return ct;}
	private:
	int ct, mx;
	AObject** data;
};

#define TT_CLEAR 0
#define TT_SOLID 1
#define TT_WATER 3
#define TT_DANGER 4
#define TT_SPECIAL 8

class StaticObj: public AObject
{
	public:
	StaticObj(RLE_SPRITE* b) {img=b;}
	char* name() {return "Static Object";}
	AAction* actions() {return 0;}
	int opaque() {return TT_SOLID;}
};

class BackgroundObj: public AObject
{
	public:
	BackgroundObj(RLE_SPRITE* b) {img=b;}
	char* name() {return "Background Object";}
	AAction* actions() {return 0;}
	int opaque() {return TT_CLEAR;}
};

class MovableObj: public AObject
{
	public:
	MovableObj() {x=y=0; img=0;}
	void move_to(int x, int y);
	void move_nowhere() {move_to(-32767, -32767);}
	void move_to(const MovableObj& m) {move_to(m.x, m.y);}
	int get_x() const {return x;}
	int get_y() const {return y;}
	int is_nowhere() {return x==-32767;}
	virtual int move() {return 0;}
	int opaque() {return TT_SOLID;}
	int near(const MovableObj&) const;
	protected:
	int x, y;
};

class MList: public AList
{
	public:
	MovableObj* operator[](int i) const 
		{return (MovableObj*) AList::operator[](i);}
};
class MovingObj: public MovableObj
{
	public:
	MovingObj(Map&);
	virtual void collide(const MovableObj&) {}
	MList& inventory() {return inv_items;}
	Map& mymap() const {return map;}
	// do the default action on the object we're
	// facing
	int f();
	
	protected:
	int facing;
	Map& map;
	MList inv_items;
};

#endif
