// aobject.cc

#include "aobject.h"
#include "bstrm.h"

RLE_SPRITE* rle_dat(DATAFILE &d)
{
	ASSERT(d.type==DAT_RLE_SPRITE);
	return (RLE_SPRITE*) d.dat;
}

void AObject::dispose()
{
}

void MovableObj::move_to(int nx, int ny)
{
	x=nx;
	y=ny;
}
#define N_R 12
int MovableObj::near(const MovableObj& m) const
{
	int dx=m.x-x;
	int dy=m.y-y;
	return (dx>(-N_R)) && (dy>(-N_R)) && (dx<N_R) && (dy<N_R);
}

MovingObj::MovingObj(Map& m) :map(m)
{
	facing=0;
}
AList::AList()
{
	mx=4;
	data=new AObject*[mx];
	ct=0;
}
AList::~AList()
{
	delete[] data;
}

void AList::add(AObject*o)
{
	if (o==0) return;
	
	if (ct==mx)
	{
		AObject** pn=new AObject*[mx*=2];
		for (int i=0; i<ct; ++i)
			pn[i]=data[i];
		delete[] data;
		data=pn;
	}
	data[ct++]=o;
}
void AList::add(const AList& l)
{
	for (int i=0; i<l.count(); ++i)
		add(l[i]);
}

void AList::remove(const AObject* o)
{
	for (int i=0; i<ct; ++i)
	{
		if (data[i]==o)
		{
			data[i]=data[--ct];
			return;
		}
	}
}

int AList::has(const AObject* ao) const
{
	for (int i=0; i<ct; ++i)
		if (data[i]==ao)
			return 1;
	return 0;
}
		
AObject* AList::operator[](int x) const
{
	return (x>=0 && x<ct) ? data[x] : 0;
}
void AList::clear()
{
	ct=0;
}

#ifdef HAS_EDITOR
int AObject::edit()
{
	alert(name(), "No properties to edit", "", "OK", 0, '\n', 0);
	return 0;
}
#endif

