#include "global.h"
#include "menu.h"

sPicture picBg_Menu;
sPicture picBody_Menu[2];
sPicture picCloud_Menu[4];
sPicture picCredits_Menu;
sPicture picFrog_Menu;
sPicture picHelp_Menu;
sPicture picLogo_Menu;
sPicture picOnePlayer_Menu;
sPicture picOptions_Menu;
sPicture picPage_Menu;
sPicture picQuit_Menu;
sPicture picSelector_Menu;
sPicture picSideRotor_Menu;
sPicture picStart_Menu;
sPicture picTopRotor_Menu;
sPicture picTwoPlayer_Menu;
sPicture picWindshield_Menu;

COption menuChoice[6];
CCopter menuCopter[2];
CCloud menuCloud[40];

int menuTicks = 0;
int curMenuChoice = 2;
int menu_numClouds = 40;
float frogAngle = 0;

void do_keys()
{
	static bool allowOptionChange = false;

	if (!key[KEY_UP] && !key[KEY_DOWN] && !key[KEY_LEFT] && !key[KEY_RIGHT]
		&& !key[KEY_ENTER] && !key[KEY_ESC]) allowOptionChange = true;

	if (allowOptionChange == true)
	{
		if (curScreen == menu)
		{
			if (key[KEY_UP])
			{
				if (curMenuChoice % 2 != 0)
				{
					curMenuChoice --;
				}
				allowOptionChange = false;
			}

			if (key[KEY_DOWN])
			{
				if (curMenuChoice % 2 == 0)
				{
					curMenuChoice ++;
				}
				allowOptionChange = false;
			}

			if (key[KEY_LEFT])
			{
				if (curMenuChoice > 1)
				{
					curMenuChoice -= 2;
				}
				allowOptionChange = false;
			}

			if (key[KEY_RIGHT])
			{
				if (curMenuChoice < 4)
				{
					curMenuChoice += 2;
				}
				allowOptionChange = false;
			}
		}

		if (key[KEY_ENTER])
		{
			switch (curMenuChoice)
			{
				case 0:
					curScreen = options;
					allowOptionChange = false;
					break;
				case 1:
					curScreen = help;
					allowOptionChange = false;
					break;
				case 2:
					curScreen = onePlayer;
					changingModes = true;
					allowOptionChange = false;
					break;
				case 3:
					curScreen = twoPlayer;
					changingModes = true;
					allowOptionChange = false;
					break;
				case 4:
					curScreen = credits;
					allowOptionChange = false;
					break;
				case 5:
					curScreen = quit;
					allowOptionChange = false;
					break;
				default:
					curScreen = menu;
			}
		}

		if (key[KEY_ESC])
		{
			if (curMenuChoice == 5)
				curScreen = quit;
			else
			{
				if (curScreen != menu && curScreen != quit && curScreen != onePlayer && curScreen != twoPlayer)
				{
					curScreen = menu;
				}
				else
				{
					curMenuChoice = 5;
				}
			}

			allowOptionChange = false;
		}

		if (curMenuChoice < 0) curMenuChoice = 5;
		if (curMenuChoice > 5) curMenuChoice = 0;
	}
}

void do_menu_logic()
{
	do_keys();

	for (int i = 0; i < menu_numClouds; i ++)
	{
		// Move clouds
		menuCloud[i].x += menuCloud[i].xSpeed;
		menuCloud[i].y += menuCloud[i].ySpeed;

		// Keep clouds on screen
		if (menuCloud[i].x + menuCloud[i].sprite.width < 0)
		{
			menuCloud[i].x = SCREEN_W;
		}

		if (menuCloud[i].x > SCREEN_W)
		{
			menuCloud[i].x = -menuCloud[i].sprite.width;
		}
	}

	for (int i = 0; i < 2; i ++)
	{
		menuCopter[i].rotorAngle += 1.2;
	}

	frogAngle += .5;

	menuTicks ++;
}

void draw_menu()
{
	static BITMAP *tempMenuBmp = create_bitmap(68, 68);
	static BITMAP *tempMenuBmp2 = create_bitmap(68, 68);
	static BITMAP *tempMenuBmp3 = create_bitmap(136, 136);
	static BITMAP *tempMenuBmp4 = create_bitmap(136, 136);
	static BITMAP *tempMenuBmp5 = create_bitmap(250, 220);
	static BITMAP *tempMenuBmp6 = create_bitmap(250, 220);

	// Draw background
	draw_sprite(buffer, picBg_Menu.file, 0, 0);

	// Draw background clouds
	for (int i = 0; i < menu_numClouds; i ++)
	{
		if (menuCloud[i].z == 1)
		{
			set_trans_blender(128, 128, 128, 190);

			draw_trans_sprite(buffer, menuCloud[i].sprite.file, menuCloud[i].x, menuCloud[i].y);
		}
	}

	// Draw logo
	set_trans_blender(128, 128, 128, 180);

	draw_trans_sprite(buffer, picLogo_Menu.file, (SCREEN_W / 2) - (picLogo_Menu.width / 2),  15);

	switch (curScreen)
	{
		case menu:
			// Draw options
			for (int i = 0; i < 6; i ++)
			{
				draw_trans_sprite(buffer, menuChoice[i].sprite.file,  menuChoice[i].x,  menuChoice[i].y);
			}

			// Draw selector
			draw_sprite(buffer, picSelector_Menu.file,  menuChoice[curMenuChoice].x,  menuChoice[curMenuChoice].y);
			break;
		case options:
			draw_trans_sprite(buffer, picPage_Menu.file, (SCREEN_W / 2) - (picPage_Menu.width / 2), 120);
			textprintf_centre_ex(buffer, font, SCREEN_W / 2, 300, makecol(0, 0, 0), -1,
				"Sorry, no options available...");
			break;
		case help:
			draw_trans_sprite(buffer, picPage_Menu.file, (SCREEN_W / 2) - (picPage_Menu.width / 2), 120);

			textprintf_ex(buffer, font, 85, 150, makecol(0, 180, 0), -1, "Player 1 keys:");
			textprintf_ex(buffer, font, 85, 180, makecol(0, 0, 0), -1, "Right...........Right arrow key");
			textprintf_ex(buffer, font, 85, 200, makecol(0, 0, 0), -1, "Left.............Left arrow key");
			textprintf_ex(buffer, font, 85, 220, makecol(0, 0, 0), -1, "Up................Up arrow key");
			textprintf_ex(buffer, font, 85, 240, makecol(0, 0, 0), -1, "Down.........Down arrow key");
			textprintf_ex(buffer, font, 85, 260, makecol(0, 0, 0), -1, "Shoot.........Enter key");

			textprintf_ex(buffer, font, 85, 350, makecol(180, 0, 0), -1, "Player 2 keys:");
			textprintf_ex(buffer, font, 85, 380, makecol(0, 0, 0), -1, "Right...........A key");
			textprintf_ex(buffer, font, 85, 400, makecol(0, 0, 0), -1, "Left.............D key");
			textprintf_ex(buffer, font, 85, 420, makecol(0, 0, 0), -1, "Up................W key");
			textprintf_ex(buffer, font, 85, 440, makecol(0, 0, 0), -1, "Down.........S key");
			textprintf_ex(buffer, font, 85, 460, makecol(0, 0, 0), -1, "Shoot.........Ctrl key");

			draw_sprite(buffer, menuCopter[0].sprite.file, menuCopter[0].x, menuCopter[0].y);
			draw_sprite(buffer, menuCopter[1].sprite.file, menuCopter[1].x, menuCopter[1].y);

			for (int i = 0; i < 2; i ++)
			{
				// Draw side rotor
				clear_to_color(tempMenuBmp, makecol(255, 0, 255));
				clear_to_color(tempMenuBmp2, makecol(255, 0, 255));

				draw_sprite(tempMenuBmp, (BITMAP*)menu_graphics_data[bmpSideRotor_Menu].dat, 0, 0);
				rotate_sprite(tempMenuBmp2, tempMenuBmp, 0, 0, itofix(menuCopter[i].rotorAngle * 1.5));
				draw_sprite(buffer, tempMenuBmp2, menuCopter[i].x + 118, menuCopter[i].y - 12);

				// Draw top rotor
				clear_to_color(tempMenuBmp3, makecol(255, 0, 255));
				clear_to_color(tempMenuBmp4, makecol(255, 0, 255));

				rotate_sprite(tempMenuBmp3, (BITMAP*)menu_graphics_data[bmpTopRotor_Menu].dat, 0, 0,
					itofix(menuCopter[i].rotorAngle));
				stretch_blit(tempMenuBmp3, tempMenuBmp4, 0, 0, 136, 136, 0, 0, 136, 20);
				draw_sprite(buffer, tempMenuBmp4, menuCopter[i].x - 16, menuCopter[i].y);
			}

			break;
		case credits:
			draw_trans_sprite(buffer, picPage_Menu.file, (SCREEN_W / 2) - (picPage_Menu.width / 2), 120);

			textprintf_ex(buffer, font, 100, 210, makecol(0, 0, 0), -1,
				"Programming......................................");
			textprintf_ex(buffer, font, 367, 210, makecol(0, 0, 0), -1, "Me");

			textprintf_ex(buffer, font, 100, 235, makecol(0, 0, 0), -1,
				"Graphics...............................................");
			textprintf_ex(buffer, font, 367, 235, makecol(0, 0, 0), -1, "Me");

			textprintf_ex(buffer, font, 100, 260, makecol(0, 0, 0), -1,
				"Original Concept.............................");
			textprintf_ex(buffer, font, 367, 260, makecol(0, 0, 0), -1, "Me");

			textprintf_ex(buffer, font, 100, 285, makecol(0, 0, 0), -1,
				"Beta Testing......................................");
			textprintf_ex(buffer, font, 367, 285, makecol(0, 0, 0), -1, "Them");

			textprintf_ex(buffer, font, 100, 310, makecol(0, 0, 0), -1,
				"Alpha Testing.....................................");
			textprintf_ex(buffer, font, 367, 310, makecol(0, 0, 0), -1, "Him");

			textprintf_ex(buffer, font, 100, 335, makecol(0, 0, 0), -1,
				"Product Support..............................");
			textprintf_ex(buffer, font, 367, 335, makecol(0, 0, 0), -1, "You");

			textprintf_ex(buffer, font, 100, 360, makecol(0, 0, 0), -1,
				"Catering................................................");
			textprintf_ex(buffer, font, 367, 360, makecol(0, 0, 0), -1, "Us");

			textprintf_centre_ex(buffer, font, SCREEN_W / 2, 485, makecol(0, 0, 0), -1,
				"Copyright 2007                                                    Remline Software");

			clear_to_color(tempMenuBmp5, makecol(255, 0, 255));
			clear_to_color(tempMenuBmp6, makecol(255, 0, 255));
			draw_sprite(tempMenuBmp5, (BITMAP*)menu_graphics_data[bmpFrog_Menu].dat, 0, 0);
			rotate_sprite(tempMenuBmp6, tempMenuBmp5, 0, 0, itofix(frogAngle * 1.5));
			draw_sprite(buffer, tempMenuBmp6, 470, 190);

			break;
	}

	// Render screen
	blit(buffer, screen, 0, 0, 0, 0, 800, 600);

	// Clear screen
	clear_to_color(buffer, makecol(0, 0, 0));

	release_screen();
}

void init_menu()
{
	curMenuChoice = 0;

	menuChoice[0].x = (SCREEN_W / 2) - (menuChoice[0].sprite.width * 1.6);
	menuChoice[1].x = (SCREEN_W / 2) - (menuChoice[1].sprite.width * 1.6);
	menuChoice[2].x = (SCREEN_W / 2) - (menuChoice[2].sprite.width * .5);
	menuChoice[3].x = (SCREEN_W / 2) - (menuChoice[2].sprite.width * .5);
	menuChoice[4].x = (SCREEN_W / 2) + (menuChoice[4].sprite.width * .6);
	menuChoice[5].x = (SCREEN_W / 2) + (menuChoice[5].sprite.width * .6);

	menuChoice[0].y = (SCREEN_H / 2) - (menuChoice[0].sprite.height * 1.2);
	menuChoice[1].y = (SCREEN_H / 2) + (menuChoice[1].sprite.height * .2);
	menuChoice[2].y = (SCREEN_H / 2) - (menuChoice[2].sprite.height * 1.2);
	menuChoice[3].y = (SCREEN_H / 2) + (menuChoice[3].sprite.height * .2);
	menuChoice[4].y = (SCREEN_H / 2) - (menuChoice[4].sprite.height * 1.2);
	menuChoice[5].y = (SCREEN_H / 2) + (menuChoice[5].sprite.height * .2);

	menuChoice[0].sprite = picOptions_Menu;
	menuChoice[1].sprite = picHelp_Menu;
	menuChoice[2].sprite = picOnePlayer_Menu;
	menuChoice[3].sprite = picTwoPlayer_Menu;
	menuChoice[4].sprite = picCredits_Menu;
	menuChoice[5].sprite = picQuit_Menu;

	// Initialize Help copters
	menuCopter[0].x = 520;
	menuCopter[1].x = 520;
	menuCopter[0].y = 190;
	menuCopter[1].y = 390;

	menuCopter[0].rotorAngle = 0;
	menuCopter[1].rotorAngle = 70;
	menuCopter[0].sprite = picBody_Menu[0];
	menuCopter[1].sprite = picBody_Menu[1];

	// Initialize clouds
	for (int i = 0; i < menu_numClouds; i ++)
	{
		menuCloud[i].x = (rand() % SCREEN_W) - (menuCloud[i].sprite.width / 2);

		if (rand() % 6 > 1)
			menuCloud[i].y = (rand() % (SCREEN_H - (80 * 6)));
		else
			menuCloud[i].y = (rand() % (SCREEN_H - (80 * 4)));

		if (menuCloud[i].y > 100)
			menuCloud[i].z = rand() % 2;
		else
			menuCloud[i].z = 1;

		if (menuCloud[i].y < 180)
			menuCloud[i].sprite = picCloud_Menu[(rand() % 4)];
		else
			menuCloud[i].sprite = picCloud_Menu[(rand() % 2)];

		while (fabs(menuCloud[i].xSpeed) < .1)
		{
			menuCloud[i].xSpeed = float((rand() % 31) - 15) / 35;
		}

		menuCloud[i].ySpeed = 0;
	}

	curMenuChoice = 2;
}

void init_menu_pictures()
{
	menu_graphics_data = load_datafile("Menu Graphics.dat");

	load_picture(&picBg_Menu,			(BITMAP*)menu_graphics_data[bmpBg_Menu].dat);
	load_picture(&picBody_Menu[0],		(BITMAP*)menu_graphics_data[bmpBody1_Menu].dat);
	load_picture(&picBody_Menu[1],		(BITMAP*)menu_graphics_data[bmpBody2_Menu].dat);
	load_picture(&picCloud_Menu[0],		(BITMAP*)menu_graphics_data[bmpCloud1_Menu].dat);
	load_picture(&picCloud_Menu[1],		(BITMAP*)menu_graphics_data[bmpCloud2_Menu].dat);
	load_picture(&picCloud_Menu[2],		(BITMAP*)menu_graphics_data[bmpCloud3_Menu].dat);
	load_picture(&picCloud_Menu[3],		(BITMAP*)menu_graphics_data[bmpCloud4_Menu].dat);
	load_picture(&picCredits_Menu,		(BITMAP*)menu_graphics_data[bmpCredits_Menu].dat);
	load_picture(&picFrog_Menu,			(BITMAP*)menu_graphics_data[bmpFrog_Menu].dat);
	load_picture(&picHelp_Menu,			(BITMAP*)menu_graphics_data[bmpHelp_Menu].dat);
	load_picture(&picLogo_Menu,			(BITMAP*)menu_graphics_data[bmpLogo_Menu].dat);
	load_picture(&picOnePlayer_Menu,	(BITMAP*)menu_graphics_data[bmpOnePlayer_Menu].dat);
	load_picture(&picOptions_Menu,		(BITMAP*)menu_graphics_data[bmpOptions_Menu].dat);
	load_picture(&picPage_Menu,			(BITMAP*)menu_graphics_data[bmpPage_Menu].dat);
	load_picture(&picQuit_Menu,			(BITMAP*)menu_graphics_data[bmpQuit_Menu].dat);
	load_picture(&picSelector_Menu,		(BITMAP*)menu_graphics_data[bmpSelector_Menu].dat);
	load_picture(&picSideRotor_Menu,	(BITMAP*)menu_graphics_data[bmpSideRotor_Menu].dat);
	load_picture(&picStart_Menu,		(BITMAP*)menu_graphics_data[bmpStart_Menu].dat);
	load_picture(&picTopRotor_Menu,		(BITMAP*)menu_graphics_data[bmpTopRotor_Menu].dat);
	load_picture(&picTwoPlayer_Menu,	(BITMAP*)menu_graphics_data[bmpTwoPlayer_Menu].dat);
	load_picture(&picWindshield_Menu,	(BITMAP*)menu_graphics_data[bmpWindshield_Menu].dat);

	DATAFILE* datafile = load_datafile_object("Menu Graphics.dat", "univ14");
	font = (FONT*)datafile->dat;
}