#include "global.h"
#include "main.h"

volatile int speed_counter = 0;

void increment_speed_counter()
{
	speed_counter ++;
}
END_OF_FUNCTION(increment_speed_counter)

int main(int argc, char *argv[])
{
	srand(time(NULL));

	allegro_init();
	install_keyboard();
	install_timer();

	if (install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL) != 0)
	{
		allegro_message("Error initialising sound\n%s\n", allegro_error);
		install_sound(DIGI_NONE, MIDI_NONE, NULL);
	}

	LOCK_VARIABLE(speed_counter);
	LOCK_FUNCTION(increment_speed_counter);

	install_int_ex(increment_speed_counter, BPS_TO_TIMER(60));

	set_color_depth(32);
	set_gfx_mode(GFX_AUTODETECT_WINDOWED, 800, 600, 0, 0);

	buffer = create_bitmap (800, 600);

	init_menu_pictures();
	init_game_pictures();

	init_menu();
	init_menu();
	init_game();
	init_game();

	while (curScreen != quit)
	{
		while (speed_counter > 0)
		{
			if (curScreen == onePlayer || curScreen == twoPlayer)
			{
				if (changingModes == true)
				{
					init_game();

					changingModes = false;
				}

				do_game_logic();
			}
			else
			{
				if (curScreen == menu)
				{
					if (changingModes == true)
					{
						init_menu();
						changingModes = false;
					}
				}

				do_menu_logic();
			}

			speed_counter --;
		}

		rest(1);

		switch (curScreen)
		{
			case menu:
				draw_menu();
				break;
			case onePlayer:
				draw_game();
				break;
			case twoPlayer:
				draw_game();
				break;
			case options:
				draw_menu();
				break;
			case help:
				draw_menu();
				break;
			case credits:
				draw_menu();
				break;
			default:
				draw_menu();
		}
	}

	destroy_bitmap(buffer);

	unload_datafile(menu_graphics_data);
	unload_datafile(graphics_data);
	unload_datafile(sfx_data);

	return 0;
}
END_OF_MAIN()
