#include "global.h"
#include "game.h"

sPicture picAmmoBar1;
sPicture picAmmoBar2;
sPicture picAmmoBarBg;
sPicture picBody1;
sPicture picBody2;
sPicture picBullet;
sPicture picHpBar1;
sPicture picHpBar2;
sPicture picHpBarBg;
sPicture picGround[3];
sPicture picSky[3];
sPicture picCloud[4];
sPicture picRaindrop[2];

CCloud cloud[40];
CPlayer player[2];
CRaindrop raindrop[120];

int gameTicks = 0;
bool paused = false;
int weather = 0;
int numClouds = 40;
int numRaindrops = 120;

void do_ai(int num)
{
	CPlayer &computer = player[num];

	CPlayer enemy;

	if (num == 0)
		enemy = player[1];
	else
		enemy = player[0]; 

	computer.upKey = false;
	computer.downKey = false;
	computer.leftKey = false;
	computer.rightKey = false;
	computer.shootKey = false;

	// Computer shooting
	if ((fabs(float(computer.x - enemy.x)) < (computer.width * 4) &&
		computer.y > enemy.y - 35 && computer.y < enemy.y + 35) ||
		(enemy.y < 20 && computer.y < 14))
	{
		computer.shootKey = true;
	}

	// Computer horizontal movement
	if (computer.x < enemy.x)
	{
		if ((enemy.x - computer.x > (computer.width * .7) + fabs(computer.xSpeed * 60) +
			fabs(enemy.xSpeed * 50) ||
			computer.face == 0 || enemy.xSpeed > 3 || computer.hp - enemy.hp > 20) &&
			(abs(computer.x - enemy.x) > 350 || enemy.y < SCREEN_H - 130) ||
			computer.face != 1)
		{
			computer.rightKey = true;
		}
	}
	else
	{
		if ((computer.x - enemy.x > (computer.width * .7) + fabs(computer.xSpeed * 60) +
			fabs(enemy.xSpeed * 50) ||
			computer.face == 1 || enemy.xSpeed < -3 || computer.hp - enemy.hp > 20) &&
			(abs(computer.x - enemy.x) > 350 || enemy.y < SCREEN_H - 130) ||
			computer.face != 0)
		{
			computer.leftKey = true;
		}
	}

	// Computer up movement
	if (computer.y > enemy.y + (enemy.ySpeed * 2) - 10 || computer.ySpeed > enemy.ySpeed + .1 ||
		enemy.upKey == true)
	{
		if (computer.y > fabs(computer.ySpeed * 40))
		{
			computer.upKey = true;
		}
	}
}

void do_general_keys()
{
	static bool allowPause = true;
	static bool allowReset = true;

	// Detect if keys are released
	if (!key[KEY_P])
	{
		allowPause = true;
	}

	if (!key[KEY_F5] && !key[KEY_F6])
	{
		allowReset = true;
	}

	// Go to main menu
	if (key[KEY_ESC])
	{
		stop_sample((SAMPLE*)sfx_data[wavMotor].dat);
		stop_sample((SAMPLE*)sfx_data[wavCrash].dat);
		stop_sample((SAMPLE*)sfx_data[wavRain].dat);
		stop_sample((SAMPLE*)sfx_data[wavThunder].dat);

		curScreen = menu;
	}

	// Pause game
	if (key[KEY_P])
	{
		if (allowPause == true)
		{
			allowPause = false;

			if (paused == false)
			{
				paused = true;
			}
			else
			{
				paused = false;
			}
		}
	}

	// Reset game
	if (key[KEY_F5])
	{
		if (allowReset == true)
		{
			curScreen = twoPlayer;
			allowReset = false;
			init_game();
		}
	}
	if (key[KEY_F6])
	{
		if (allowReset == true)
		{
			curScreen = onePlayer;
			allowReset = false;
			init_game();
		}
	}
}

void do_player_keys()
{
	// Assume player keys are off
	for (int i = 0; i < 2; i ++)
	{
		player[i].upKey = false;
		player[i].downKey = false;
		player[i].leftKey = false;
		player[i].rightKey = false;
		player[i].shootKey = false;
	}

		// Player 1 key detection
		if (player[0].hp > 0)
		{
			if (key[KEY_UP])
				player[0].upKey = true;
			if (key[KEY_DOWN])
				player[0].downKey = true;
			if (key[KEY_LEFT])
				player[0].leftKey = true;
			if (key[KEY_RIGHT])
				player[0].rightKey = true;
			if (key[KEY_ENTER] || key[KEY_SPACE] || key[KEY_RCONTROL])
				if (gameTicks > 10)
					player[0].shootKey = true;
		}

		// Player 2 key detection
		if (player[1].hp > 0 && useAi == false)
		{
			if (key[KEY_W])
				player[1].upKey = true;
			if (key[KEY_S])
				player[1].downKey = true;
			if (key[KEY_A])
				player[1].leftKey = true;
			if (key[KEY_D])
				player[1].rightKey = true;
			if (key[KEY_LCONTROL] || key[KEY_LSHIFT])
				if (gameTicks > 10)
					player[1].shootKey = true;
		}
}

void do_game_logic()
{
	static int crashDelay = 0;
	static bool bulletFound = false;

	if (gameTicks == 0)
	{
		// Play motor sound
		play_sample((SAMPLE*)sfx_data[wavMotor].dat, 90, 128, 1000, true);

		// Play rain sound if applicable
		if (weather == 1)
		{
			play_sample((SAMPLE*)sfx_data[wavRain].dat, 255, 128, 1000, true);
		}
	}

	// Keep track of game time
	gameTicks ++;

	do_general_keys();

	// Random thunder when raining
	if (weather == 1 && rand() % 7000 > 6980)
	{
		play_sample((SAMPLE*)sfx_data[wavThunder].dat, 255, 128, 1000, false);
	}

	if (paused == false)
	{
		do_player_keys();

		if (useAi == true)
		{
			do_ai(1);
		}

		for (int i = 0; i < numRaindrops; i ++)
		{
			// Move raindrops
			raindrop[i].x += raindrop[i].xSpeed;
			raindrop[i].y += raindrop[i].ySpeed;

			if (raindrop[i].x > SCREEN_W)
			{
				if (weather == 1)
					raindrop[i].x = (rand() % SCREEN_W + 50) - (raindrop[i].sprite.width / 2) - 90;

				if (weather == 2)
					raindrop[i].x = (rand() % SCREEN_W) - (raindrop[i].sprite.width / 2);

				raindrop[i].y = -(rand() % 30);
			}

			if (raindrop[i].y > SCREEN_H - picGround[weather].height - picRaindrop[weather - 1].height)
			{
				if (weather == 1)
					raindrop[i].x = (rand() % SCREEN_W + 50) - (raindrop[i].sprite.width / 2) - 90;

				if (weather == 2)
					raindrop[i].x = (rand() % SCREEN_W) - (raindrop[i].sprite.width / 2);

				raindrop[i].y = -(rand() % 30);
			}
		}

		for (int i = 0; i < numClouds; i ++)
		{
			// Move clouds
			cloud[i].x += cloud[i].xSpeed;
			cloud[i].y += cloud[i].ySpeed;

			// Keep clouds on screen
			if (cloud[i].x + cloud[i].sprite.width < 0)
			{
				cloud[i].x = SCREEN_W;
			}

			if (cloud[i].x > SCREEN_W)
			{
				cloud[i].x = -cloud[i].sprite.width;
			}
		}

		// Wait a little between player crash detections
		if (crashDelay  > 0)
		{
			crashDelay --;
		}

		// Players crashing into each other
		if (player[0].x + player[0].width > player[1].x &&
			player[0].x < player[1].x + player[1].width &&
			player[0].y + player[0].height > player[1].y &&
			player[0].y < player[1].y + player[1].height)
		{
			if (crashDelay <= 0)
			{
				if (player[1].hp > 0)
				{
					player[0].hp += -int(fabs((player[0].xSpeed) * .6) + 1) -
						int(fabs(player[0].ySpeed * .6));
				}

				if (player[0].hp > 0)
				{
					player[1].hp += -int(fabs((player[1].xSpeed) * .6) + 1) -
						int(fabs(player[1].ySpeed * .6));
				}

				crashDelay = 10;

				play_sample((SAMPLE*)sfx_data[wavExplosion].dat, 255, 128, 1000, false);
			}

			if (player[0].x < player[1].x)
			{
				player[0].x -= 1;
				player[1].x += 1;

				player[0].xSpeed = -abs(player[0].xSpeed * .6) - .7;
				player[1].xSpeed = abs(player[1].xSpeed * .6) + .7;
			}
			else
			{
				player[0].x += 1;
				player[1].x -= 1;

				player[0].xSpeed = abs(player[0].xSpeed * .6) + .7;
				player[1].xSpeed = -abs(player[1].xSpeed * .6) - .7;
			}

			player[0].ySpeed *= .9;
			player[1].ySpeed *= .9;
		}

		for (int i = 0; i < 2; i ++)
		{
			if (player[i].hp > 0)
			{
				// Player facing
				if (player[i].leftKey == true)
				{
					player[i].face = 0;
				}

				if (player[i].rightKey == true)
				{
					player[i].face = 1;
				}

				// Reloads ammo when player runs out
				if (player[i].reloading == true)
				{
					if (gameTicks % 20 == 0)
					{
						player[i].ammo += (player[i].maxAmmo - 1) / 20 + 1;
					}

					if (player[i].ammo > player[i].maxAmmo)
					{
						player[i].ammo = player[i].maxAmmo;
						player[i].reloading = false;
					}
				}

				// Creates new bullet if player is shooting
				if (player[i].shootKey == true && player[i].bulletDelay <= 0 &&
					player[i].ammo > 0 && player[i].reloading == false)
				{
					player[i].bulletDelay = 7;
					player[i].ammo --;

					bulletFound = false;

					for (int j = 0; j < 15 && bulletFound == false; j ++)
					{
						if (player[i].bullet[j].used == false)
						{
							player[i].bullet[j].used = true;
							player[i].bullet[j].y = player[i].y + 20;
							player[i].bullet[j].ySpeed =  .2 * (2 - (rand() % 5));

							if (player[i].face == 0)
							{
								player[i].bullet[j].x = player[i].x;
								player[i].bullet[j].xSpeed = -9;
							}
							else
							{
								player[i].bullet[j].x = player[i].x + player[i].width -
									player[i].bullet[j].sprite.width;
								player[i].bullet[j].xSpeed = 9;
							}

							bulletFound = true;

							play_sample((SAMPLE*)sfx_data[wavGun].dat, 255, 128, 1000, false);
						}
					}
				}
				else
				{
					if (player[i].ammo == 0)
					{
						player[i].reloading = true;
					}

					player[i].bulletDelay --;
				}
			}

			for (int j = 0; j < 15; j ++)
			{
				if (player[i].bullet[j].used == true)
				{
					// Bullet movement due to gravity
					player[i].bullet[j].ySpeed += .05;

					// Adjust bullet to new location
					player[i].bullet[j].x += player[i].bullet[j].xSpeed;
					player[i].bullet[j].y += player[i].bullet[j].ySpeed;

					// Remove bullet if off the screen
					if (player[i].bullet[j].x < -player[i].bullet[j].sprite.width ||
						player[i].bullet[j].x > SCREEN_W ||
						player[i].bullet[j].y + player[i].bullet[j].sprite.height >
						SCREEN_H - picGround[weather].height)
					{
						player[i].bullet[j].used = false;
						player[i].bullet[j].xSpeed = 0;
						player[i].bullet[j].ySpeed = 0;
					}

					// Bullet collision with player
					if (i == 0)
					{
						if (player[i].bullet[j].x + player[i].bullet[j].sprite.width > player[1].x &&
							player[i].bullet[j].x < player[1].x + player[1].width &&
							player[i].bullet[j].y + player[i].bullet[j].sprite.height > player[1].y &&
							player[i].bullet[j].y < player[1].y + player[1].height)
						{
							player[i].bullet[j].used = false;
							player[1].xSpeed += player[i].bullet[j].xSpeed * .04;

							if (player[0].hp > 0)
							{
                                player[1].hp -= 2;
							}

							play_sample((SAMPLE*)sfx_data[wavExplosion].dat, 255, 128, 1000, false);
						}
					}
					else
					{
						if (player[i].bullet[j].x + player[i].bullet[j].sprite.width > player[0].x &&
							player[i].bullet[j].x < player[0].x + player[0].width &&
							player[i].bullet[j].y + player[i].bullet[j].sprite.height > player[0].y &&
							player[i].bullet[j].y < player[0].y + player[0].height)
						{
							player[i].bullet[j].used = false;
							player[0].xSpeed += player[i].bullet[j].xSpeed * .04;

							if (player[1].hp > 0)
							{
								player[0].hp -= 2;
							}

							play_sample((SAMPLE*)sfx_data[wavExplosion].dat, 255, 128, 1000, false);
						}
					}
				}
			}

			if (player[i].hp > 0)
			{
				// Player movement from keys
				if (player[i].leftKey) player[i].xSpeed -= .12;
				if (player[i].rightKey) player[i].xSpeed += .12;
				if (player[i].upKey) player[i].ySpeed -= .16;
				if (player[i].downKey) player[i].ySpeed += .16;

				// Rotate rotor
				player[i].rotorAngle += 8;
			}
			else
			{
				// Rotate rotor slowly
				player[i].rotorAngle += 1;
			}

			// Player movement due to gravity
			player[i].ySpeed += .05;

			// Player's horizontal motion gradually moves to zero
			if (player[i].xSpeed < 0) player[i].xSpeed += .03;
			if (player[i].xSpeed > 0) player[i].xSpeed -= .03;

			if (fabs(player[i].xSpeed) < .03) player[i].xSpeed = 0;
		}

		for (int i = 0; i < 2; i ++)
		{
			// Restrict player speed to within reason
			if (player[i].xSpeed < -4) player[i].xSpeed = -4;
			if (player[i].xSpeed > 4) player[i].xSpeed = 4;
			if (player[i].ySpeed < -4) player[i].ySpeed = -4;
			if (player[i].ySpeed > 5.4) player[i].ySpeed = 5.4;

			// Adjust player to new location
			player[i].x += player[i].xSpeed;
			player[i].y += player[i].ySpeed;

			// Restrict player's location on left
			if (player[i].x < 0)
			{
				player[i].x = 0;
				player[i].xSpeed = -(player[i].xSpeed * .7);
			}

			// Restrict player's location on right
			if (player[i].x > SCREEN_W - player[i].width)
			{
				player[i].x = SCREEN_W - player[i].width;
				player[i].xSpeed = -(player[i].xSpeed * .7);
			}

			// Restrict player's location on top
			if (player[i].y < 0)
			{
				player[i].y = 0;
				player[i].ySpeed = -(player[i].ySpeed * .7);
			}

			// Restrict player's location on bottom
			if (player[i].y > SCREEN_H - player[i].height - picGround[weather].height)
			{
				if (player[i].ySpeed > 2)
				{
					if (i == 0 && player[1].hp > 0)
					{
						player[i].hp -= int(player[i].ySpeed);
					}

					if (i == 1 && player[0].hp > 0)
					{
						player[i].hp -= int(player[i].ySpeed);
					}

					play_sample((SAMPLE*)sfx_data[wavExplosion].dat, 255, 128, 1000, false);
				}

				player[i].y = SCREEN_H - player[i].height - picGround[weather].height;
				player[i].ySpeed = -(player[i].ySpeed * .3);
			}

			if (player[i].y >= SCREEN_H - player[i].height - picGround[weather].height)
			{
				if (player[i].hp <= 0 && player[i].crashed == false)
				{
					player[i].crashed = true;

					play_sample((SAMPLE*)sfx_data[wavCrash].dat, 255, 128, 1000, false);
				}
			}

			// Restrict player hp
			if (player[i].hp < 0)
			{
				player[i].hp = 0;
			}
		}
	}
}

void draw_game()
{
	static BITMAP *tempBmp = create_bitmap(34, 34);
	static BITMAP *tempBmp2 = create_bitmap(34, 34);
	static BITMAP *tempBmp3 = create_bitmap(68, 68);
	static BITMAP *tempBmp4 = create_bitmap(68, 68);
	static BITMAP *tempBmp5 = create_bitmap(80, 44);

	static int imgAdjust = 0;

	// Draw sky
	draw_sprite(buffer, picSky[weather].file, 0, 0);

	// Draw ground
	draw_sprite(buffer, picGround[weather].file, 0,	SCREEN_H - picGround[weather].height);

	// Draw rain
	if (weather > 0)
	{
		for (int i = 0; i < numRaindrops; i ++)
		{
			if (raindrop[i].z == 1)
			{
				draw_sprite(buffer, raindrop[i].sprite.file, raindrop[i].x, raindrop[i].y);
			}
		}
	}

	// Draw background clouds
	for (int i = 0; i < numClouds; i ++)
	{
		if (cloud[i].z == 1)
		{
			if (weather == 0)
			{
				set_trans_blender(128, 128, 128, 170);
			}
			else
			{
				set_trans_blender(128, 128, 128, 130);
			}

			draw_trans_sprite(buffer, cloud[i].sprite.file, cloud[i].x, cloud[i].y);
		}
	}

	// Draw hitpoints bars
	draw_sprite(buffer, picHpBarBg.file, 4, 35);
	draw_sprite(buffer, picHpBarBg.file, SCREEN_W - 250 - 6, 35);

	stretch_blit(picHpBar1.file, buffer, 0, 0, 1, picHpBar1.height,
		SCREEN_W - 250 - 5, 36, player[0].hp * 5, picHpBar1.height);
	stretch_blit(picHpBar2.file, buffer, 0, 0, 1, picHpBar2.height,
		5, 36, player[1].hp * 5, picHpBar2.height);

	// Draw ammo bars
	draw_sprite(buffer, picAmmoBarBg.file, 4, 60);
	draw_sprite(buffer, picAmmoBarBg.file, SCREEN_W - 250 - 6, 60);

	stretch_blit(picAmmoBar1.file, buffer, 0, 0, 1, picAmmoBar1.height,
		SCREEN_W - 250 - 5, 61, player[0].ammo * 250 / player[0].maxAmmo, picAmmoBar1.height);
	stretch_blit(picAmmoBar2.file, buffer, 0, 0, 1, picAmmoBar2.height,
		5, 61, player[1].ammo * 250 / player[1].maxAmmo, picHpBar2.height);

	// Print player labels
	textprintf(buffer, font, SCREEN_W - 250 - 6, 6, makecol(255, 255, 255),
		"Player 1");

	textprintf(buffer, font, 6, 6, makecol(255, 255, 255),
		"Player 2");

	for (int i = 0; i < 2; i ++)
	{
		// Draw bullets
		for (int j = 0; j < 15; j ++)
		{
			if (player[i].bullet[j].used == true)
			{
				draw_sprite(buffer, (BITMAP*)graphics_data[bmpBullet].dat,
					player[i].bullet[j].x, player[i].bullet[j].y);
			}
		}

		if (player[i].face == 0)
		{
			// Draw windshield
			if (player[i].hp > 0)
			{
				set_trans_blender(128, 128, 220, 170);
				draw_trans_sprite(buffer, (BITMAP*)graphics_data[bmpWindshield].dat,
					player[i].x, player[i].y);
			}

			// Draw helicopter body
			if (player[i].hp < 1 && player[i].crashed == true)
				imgAdjust = player[i].width * 5 + 6;
			else
				if (player[i].hp < 10)
					imgAdjust = player[i].width * 4 + 5;
				else
					if (player[i].hp < 20)
						imgAdjust = player[i].width * 3 + 4;
					else
						if (player[i].hp < 30)
							imgAdjust = player[i].width * 2 + 3;
						else
							if (player[i].hp < 40)
								imgAdjust = player[i].width + 2;
							else
								imgAdjust = 1;

			if (player[i].hp > 0)
			{
				masked_blit(player[i].sprite.file, buffer, imgAdjust, 1,
					player[i].x, player[i].y, player[i].width, player[i].height);
			}
			else
			{
				masked_blit(player[i].sprite.file, buffer, imgAdjust, 1,
					player[i].x, player[i].y + 3, player[i].width, player[i].height);
			}

			if (player[i].hp > 0 || player[i].crashed == false)
			{
				// Draw side rotor
				clear_to_color(tempBmp, makecol(255, 0, 255));
				clear_to_color(tempBmp2, makecol(255, 0, 255));

				draw_sprite(tempBmp, (BITMAP*)graphics_data[bmpSideRotor].dat, 0, 0);
				rotate_sprite(tempBmp2, tempBmp, 0, 0, itofix(player[i].rotorAngle * 1.5));
				draw_sprite(buffer, tempBmp2, player[i].x + 59, player[i].y - 6);

				// Draw top rotor
				clear_to_color(tempBmp3, makecol(255, 0, 255));
				clear_to_color(tempBmp4, makecol(255, 0, 255));

				rotate_sprite(tempBmp3, (BITMAP*)graphics_data[bmpTopRotor].dat, 0, 0,
					itofix(player[i].rotorAngle));
				stretch_blit(tempBmp3, tempBmp4, 0, 0, 68, 68, 0, 0, 68, 10);
				draw_sprite(buffer, tempBmp4, player[i].x - 8, player[i].y);
			}
		}
		else
		{
			// Draw windshield
			if (player[i].hp > 0)
			{
				clear_to_color(tempBmp5, makecol(255, 0, 255));

				set_trans_blender(128, 128, 128, 128);
				draw_sprite_h_flip(tempBmp5, (BITMAP*)graphics_data[bmpWindshield].dat, 0, 0);
				draw_trans_sprite(buffer, tempBmp5, player[i].x, player[i].y);
			}

			// Draw helicopter body
			if (player[i].hp < 1 && player[i].crashed == true)
				imgAdjust = player[i].width * 5 + 6;
			else
				if (player[i].hp < 10)
					imgAdjust = player[i].width * 4 + 5;
				else
					if (player[i].hp < 20)
						imgAdjust = player[i].width * 3 + 4;
					else
						if (player[i].hp < 30)
							imgAdjust = player[i].width * 2 + 3;
						else
							if (player[i].hp < 40)
								imgAdjust = player[i].width + 2;
							else
								imgAdjust = 1;

			clear_to_color(tempBmp5, makecol(255, 0, 255));

			masked_blit(player[i].sprite.file, tempBmp5, imgAdjust, 1,
				0, 0, player[i].width, player[i].height);

			if (player[i].hp > 0)
			{
				draw_sprite_h_flip(buffer, tempBmp5, player[i].x, player[i].y);
			}
			else
			{
				draw_sprite_h_flip(buffer, tempBmp5, player[i].x, player[i].y + 3);
			}

			if (player[i].hp > 0 || player[i].crashed == false)
			{
				// Draw side rotor
				clear_to_color(tempBmp, makecol(255, 0, 255));
				clear_to_color(tempBmp2, makecol(255, 0, 255));

				draw_sprite(tempBmp, (BITMAP*)graphics_data[bmpSideRotor].dat, 0, 0);
				rotate_sprite(tempBmp2, tempBmp, 0, 0, itofix(player[i].rotorAngle * 1.5));
				draw_sprite(buffer, tempBmp2, player[i].x - 13, player[i].y - 6);

				// Draw top rotor
				clear_to_color(tempBmp3, makecol(255, 0, 255));
				clear_to_color(tempBmp4, makecol(255, 0, 255));

				rotate_sprite(tempBmp3, (BITMAP*)graphics_data[bmpTopRotor].dat, 0, 0,
					itofix(player[i].rotorAngle));
				stretch_blit(tempBmp3, tempBmp4, 0, 0, 68, 68, 0, 0, 68, 10);
				draw_sprite(buffer, tempBmp4, player[i].x + 20, player[i].y);
			}
		}
	}

	// Draw rain
	if (weather > 0)
	{
		for (int i = 0; i < numRaindrops; i ++)
		{
			if (raindrop[i].z == 0)
			{
				draw_sprite(buffer, raindrop[i].sprite.file, raindrop[i].x, raindrop[i].y);
			}
		}
	}

	// Draw foreground clouds
	for (int i = 0; i < numClouds; i ++)
	{
		if (cloud[i].z == 0)
		{
			if (weather == 0)
			{
				set_trans_blender(128, 128, 128, 190);
			}
			else
			{
				set_trans_blender(128, 128, 128, 150);
			}

			draw_trans_sprite(buffer, cloud[i].sprite.file, cloud[i].x, cloud[i].y);
		}
	}

	// Render screen
	blit(buffer, screen, 0, 0, 0, 0, 800, 600);

	// Clear screen
	clear_to_color(buffer, makecol(0, 0, 0));

	release_screen();
}

void init_game()
{
	stop_sample((SAMPLE*)sfx_data[wavMotor].dat);
	stop_sample((SAMPLE*)sfx_data[wavCrash].dat);
	stop_sample((SAMPLE*)sfx_data[wavRain].dat);
	stop_sample((SAMPLE*)sfx_data[wavThunder].dat);

	gameTicks = 0;
	weather = rand() % 3;

	if (curScreen == onePlayer)
	{
		useAi = true;
	}

	if (curScreen == twoPlayer)
	{
		useAi = false;
	}

	// Initialize players
	for (int i = 0; i < 2; i ++)
	{
		for (int j = 0; j < 15; j ++)
		{
			player[i].bullet[j].sprite = picBullet;
			player[i].bullet[j].x = 0;
			player[i].bullet[j].y = 0;
			player[i].bullet[j].xSpeed = 0;
			player[i].bullet[j].ySpeed = 0;
			player[i].bullet[j].used = false;
		}

		player[i].upKey = false;
		player[i].downKey = false;
		player[i].leftKey = false;
		player[i].rightKey = false;
		player[i].shootKey = false;

		player[i].y = SCREEN_H - player[i].height - picGround[weather].height;
		player[i].xSpeed = 0;
		player[i].ySpeed = 0;
		player[i].hp = 50;
		player[i].maxAmmo = 20;
		player[i].ammo = player[i].maxAmmo;
		player[i].bulletDelay = 0;
		player[i].reloading = false;
		player[i].crashed = false;
		player[i].width = 80;
		player[i].height = 44;
	}

	player[0].x = SCREEN_W - (player[0].width * 2);
	player[1].x = player[1].width;

	player[0].face = 0;
	player[1].face = 1;

	player[0].rotorAngle = 0;
	player[1].rotorAngle = 70;

	player[0].sprite = picBody1;
	player[1].sprite = picBody2;

	// Initialize clouds
	for (int i = 0; i < numClouds; i ++)
	{
		cloud[i].x = (rand() % SCREEN_W) - (cloud[i].sprite.width / 2);

		if (rand() % 6 > 1)
			cloud[i].y = (rand() % (SCREEN_H - (picGround[weather].height * 6)));
		else
			cloud[i].y = (rand() % (SCREEN_H - (picGround[weather].height * 4)));

		if (cloud[i].y > 100)
			cloud[i].z = rand() % 2;
		else
			cloud[i].z = 1;

		if (cloud[i].y < 180)
			cloud[i].sprite = picCloud[(rand() % 4)];
		else
			cloud[i].sprite = picCloud[(rand() % 2)];

		while (fabs(cloud[i].xSpeed) < .1)
		{
			cloud[i].xSpeed = float((rand() % 31) - 15) / 35;
		}

		cloud[i].ySpeed = 0;
	}

	// Initialize raindrops
	for (int i = 0; i < numRaindrops; i ++)
	{
		if (weather == 1)
		{
			raindrop[i].sprite = picRaindrop[0];
			raindrop[i].x = (rand() % SCREEN_W + 50) - (raindrop[i].sprite.width / 2) - 90;
			raindrop[i].xSpeed = 1.3;
			raindrop[i].ySpeed = 6 + float(rand() % 40 / 10);
		}

		if (weather == 2)
		{
			raindrop[i].sprite = picRaindrop[1];
			raindrop[i].x = (rand() % SCREEN_W) - (raindrop[i].sprite.width / 2);
			raindrop[i].xSpeed = 0;
			raindrop[i].ySpeed = 2 + float(rand() % 40 / 20);
		}

		raindrop[i].y = (rand() % (SCREEN_H - picGround[weather].height)) - (raindrop[i].sprite.width / 2);
		raindrop[i].z = rand() % 2;
	}

	// Adjust scenery based on weather
	switch (weather)
	{
		case 0:
			numClouds = 20;
			break;
		case 1:
			numClouds = 40;
			break;
		case 2:
			numClouds = 16;
	}
}

void init_game_pictures()
{
	sfx_data = load_datafile("Sfx.dat");
	graphics_data = load_datafile("Graphics.dat");

	static COLOR_MAP global_trans_table;
	static PALETTE pal;
	create_trans_table(&global_trans_table, pal, 128, 128, 128, NULL);

	load_picture(&picAmmoBar1, (BITMAP*)graphics_data[bmpAmmoBar1].dat);
	load_picture(&picAmmoBar2, (BITMAP*)graphics_data[bmpAmmoBar2].dat);
	load_picture(&picAmmoBarBg, (BITMAP*)graphics_data[bmpAmmoBarBg].dat);
	load_picture(&picBody1, (BITMAP*)graphics_data[bmpBody1].dat);
	load_picture(&picBody2, (BITMAP*)graphics_data[bmpBody2].dat);
	load_picture(&picBullet, (BITMAP*)graphics_data[bmpBullet].dat);
	load_picture(&picHpBar1, (BITMAP*)graphics_data[bmpHpBar1].dat);
	load_picture(&picHpBar2, (BITMAP*)graphics_data[bmpHpBar2].dat);
	load_picture(&picHpBarBg, (BITMAP*)graphics_data[bmpHpBarBg].dat);
	load_picture(&picGround[0], (BITMAP*)graphics_data[bmpClearGround].dat);
	load_picture(&picGround[1], (BITMAP*)graphics_data[bmpRainyGround].dat);
	load_picture(&picGround[2], (BITMAP*)graphics_data[bmpSnowyGround].dat);
	load_picture(&picSky[0], (BITMAP*)graphics_data[bmpClearSky].dat);
	load_picture(&picSky[1], (BITMAP*)graphics_data[bmpRainySky].dat);
	load_picture(&picSky[2], (BITMAP*)graphics_data[bmpSnowySky].dat);
	load_picture(&picCloud[0], (BITMAP*)graphics_data[bmpCloud1].dat);
	load_picture(&picCloud[1], (BITMAP*)graphics_data[bmpCloud2].dat);
	load_picture(&picCloud[2], (BITMAP*)graphics_data[bmpCloud3].dat);
	load_picture(&picCloud[3], (BITMAP*)graphics_data[bmpCloud4].dat);
	load_picture(&picRaindrop[0], (BITMAP*)graphics_data[bmpRaindrop].dat);
	load_picture(&picRaindrop[1], (BITMAP*)graphics_data[bmpSnowflake].dat);
}