/*
  Name: impossible castle
  Copyright: 2007 Pie32 Games
  Author: Jeff Bernard
  Date: 02/18/07 15:50 - 02/18/07 16:49
  Description: My own little Minor Hack, conceptualized and written in 59 minutes
*/

#include <allegro.h>
#include <cstdio>
#include <vector>

volatile int speed;

class monster
{
   private:
      float x, y;
   public:
      monster()
      {
         x = rand()%(SCREEN_W-10);
         y = rand()%(SCREEN_H-10);
      }
      bool logic(int px, int py)
      {
         float dx, dy;
         do 
         {
            dx = rand()%1000/100;
            dy = rand()%1000/100;
            if (rand()%2)
               dx = -dx;
            if (rand()%2)
               dy = -dy;
         } while (x+dx < 0 || x+dx > SCREEN_W || y+dy < 0 || y+dy > SCREEN_H);
         x+=dx;
         y+=dy;
         
         if (x-4 <= px && x+4 >= px && y-4 <= py && y+4 >= py)
            return true;
         return false;
      }
      void draw(BITMAP* buffer)
      {
         circlefill(buffer, (int)x-1, (int)y-1, 4, makecol(64,64,64));
      }
};

void init();
void deinit();
void makeRoom(BITMAP* room);
//void outline(BITMAP* room);
void renderScreen(BITMAP* room, BITMAP* buffer, int px, int py, int level, std::vector<monster> monsters);
void increment_timer()
{
   speed++;
}
END_OF_FUNCTION(increment_timer)

void play()
{
     BITMAP* buffer = create_bitmap(SCREEN_W, SCREEN_H);
	clear_to_color(buffer, makecol(0,0,0));
	BITMAP* room = create_bitmap(SCREEN_W, SCREEN_H);
	
	makeRoom(room);
	
	int px = SCREEN_W/2;
	int py = SCREEN_H/2;
	int level = 1;
	std::vector<monster> monsters;
	bool gameOver = false;

	while (!key[KEY_ESC] && !gameOver)
    {
	   while (speed > 0 && !key[KEY_ESC] && !gameOver)
	   {
          if (key[KEY_UP] && (getpixel(room, px, py-1) == makecol(10,10,10) || getpixel(room, px, py-1) == makecol(255,255,255)))
             py--;
          else if (key[KEY_DOWN] && (getpixel(room, px, py+1) == makecol(10,10,10) || getpixel(room, px, py+1) == makecol(255,255,255)))
             py++;
          if (key[KEY_LEFT] && (getpixel(room, px-1, py) == makecol(10,10,10) || getpixel(room, px-1, py) == makecol(255,255,255)))
             px--;
          else if (key[KEY_RIGHT] && (getpixel(room, px+1, py) == makecol(10,10,10) || getpixel(room, px+1, py) == makecol(255,255,255)))
             px++;
          for (int i = 0; i < monsters.size(); i++)
             if (monsters[i].logic(px, py))
                gameOver = true;
          speed--;
       }
       renderScreen(room, buffer, px, py, level, monsters);
       if (getpixel(room, px, py) == makecol(255,255,255))
       {
          level++;
          makeRoom(room);
          do
          {
             px = rand()%(SCREEN_W-5);
	         py = rand()%(SCREEN_H-5);
          } while (getpixel(room, px, py) != makecol(10,10,10));
          monsters.clear();
          for (int i = 0; i < level; i++)
          {
             monster blob;
             monsters.push_back(blob);
          }
       }
	}
	
	destroy_bitmap(buffer);
	destroy_bitmap(room);
	deinit();
	
	textprintf_ex(screen, font, SCREEN_W/2-10, SCREEN_H/2-10, makecol(255,255,255), makecol(0,0,0), "GAME OVER!");
	textprintf_ex(screen, font, SCREEN_W/2-10, SCREEN_H/2, makecol(255,255,255), makecol(0,0,0), "Press Escape to quit");
    textprintf_ex(screen, font, SCREEN_W/2-10, SCREEN_H/2+10, makecol(255,255,255), makecol(0,0,0), "Or Space for new game");
    while (!key[KEY_ESC] && !key[KEY_SPACE]);
    if (key[KEY_SPACE])
       play();
 }

int main()
{
	init();
	
	play();

	return 0;
}
END_OF_MAIN()

void renderScreen(BITMAP* room, BITMAP* buffer, int px, int py, int level, std::vector<monster> monsters)
{
   clear_to_color(buffer, makecol(100,99,100));
   masked_blit(room, buffer, 0, 0, 0, 0, buffer->w, buffer->h);
   circlefill(buffer, px-1, py-1, 4, makecol(55,55,55));
   for (int i = 0; i < monsters.size(); i++)
      monsters[i].draw(buffer);
   textprintf_ex(buffer, font, 1, 1, makecol(255,255,255), -1, "Level: %d", level);
   blit(buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
}

void makeRoom(BITMAP* room)
{
   clear_to_color(room, makecol(255,0,255));
   int panels = 20+rand()%100;
   int size = rand()%20+10;
   int vary = rand()%50+50;
   int x = SCREEN_W/2;
   int y = SCREEN_H/2;
   
   // make first square ooo
   rectfill(room, x-size-vary, y-size-vary, x+size+vary, y+size+vary, makecol(10,10,10));
   
   // make the rest of the room, bizzy
   int cx;
   int cy;
   for (int i = 0; i < panels-1; i++)
   {
      // ensure growth
      cx = rand()%vary;
      cy = rand()%vary;
      if (rand()%2)
         cx *= -1;
      if (rand()%2)
         cy *= -1;
      
      // enable proper size
      int attempts = 0;
      do
      {
         size = rand()%vary;
         if (++attempts > 2) // we need to reset
            break;
      } while (x+cx+size > room->w || x+cx-size < 0 || y+cy+size > room->h || y+cy-size < 0);
        
      // mutate!
      if (attempts <= 2)
      {
         rectfill(room, x+cx-size, y+cy-size, x+cx+size, y+cy+size, makecol(10,10,10));
         x += cx;
         y += cy;
      }
      else // reset
      {
         x = SCREEN_W/2;
         y = SCREEN_H/2;
      }
   }
   
   // place flag
   int w, h;
   do
   {
      w = rand()%(room->w-10);
      h = rand()%(room->h-10);
   } while (getpixel(room, w, h) != makecol(10,10,10));
   rectfill(room, w-6, h-6, w+6, h+6, makecol(255,255,255));
   
   //outline(room);
}


void init()
{
	int depth, res;
	allegro_init();
	depth = desktop_color_depth();
	if (depth == 0)
       depth = 32;
	set_color_depth(depth);
	res = set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0);
	if (res != 0)
    {
	   allegro_message(allegro_error);
	   exit(-1);
	}
	
	srand(time(0));

	install_timer();
	install_keyboard();
	LOCK_VARIABLE(speed);
	LOCK_FUNCTION(increment_timer);
	install_int_ex(increment_timer, BPS_TO_TIMER(140));
}

void deinit()
{
	clear_keybuf();
}
